/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.psi.AbstractPSITabel;
import nl.digitalekabeltelevisie.data.mpeg.psi.PATsection;
import nl.digitalekabeltelevisie.util.Utils;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeader;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeaderBuilder;

public class PAT
extends AbstractPSITabel {
    private PATsection[] pat = null;
    private final List<PATsection[]> patVersions = new ArrayList<PATsection[]>();
    private PATsection[] newPAT = null;
    private int actualVersionNo = -1;

    public PAT(PSI parent) {
        super(parent);
    }

    public void update(PATsection section) {
        if (this.pat == null) {
            this.pat = new PATsection[section.getSectionLastNumber() + 1];
        }
        if (this.pat[section.getSectionNumber()] == null) {
            this.pat[section.getSectionNumber()] = section;
        } else {
            PATsection last = this.pat[section.getSectionNumber()];
            PAT.updateSectionVersion(section, last);
        }
        if (section.getVersion() != this.actualVersionNo) {
            if (this.newPAT == null) {
                this.newPAT = new PATsection[section.getSectionLastNumber() + 1];
            }
            this.newPAT[section.getSectionNumber()] = section;
            boolean allFilled = true;
            for (PATsection element : this.newPAT) {
                allFilled &= element != null;
            }
            if (allFilled) {
                PATsection[] actualPAT = this.newPAT;
                this.patVersions.add(actualPAT);
                this.actualVersionNo = section.getVersion();
                this.newPAT = null;
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        KVP kvp = new KVP("PAT");
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(kvp);
        if (this.pat != null) {
            kvp.addTableSource(this::getTableModel, "PAT");
            for (PATsection element : this.pat) {
                if (element == null) continue;
                if (!Utils.simpleModus(modus)) {
                    PAT.addSectionVersionsToJTree(t, element, modus);
                    continue;
                }
                t.add(element.getJTreeNode(modus));
            }
        }
        return t;
    }

    public int getTransportStreamId() {
        if (this.pat != null) {
            for (PATsection element : this.pat) {
                if (element == null) continue;
                return element.getTransportStreamId();
            }
        }
        return -1;
    }

    public boolean inPAT(int pid) {
        if (this.pat != null) {
            PATsection[] pATsectionArray = this.pat;
            int n = pATsectionArray.length;
            for (int i = 0; i < n; ++i) {
                PATsection element;
                for (PATsection patSectionVersion = element = pATsectionArray[i]; patSectionVersion != null; patSectionVersion = (PATsection)patSectionVersion.getNextVersion()) {
                    for (PATsection.Program program : patSectionVersion.getPrograms()) {
                        if (program.getProgram_map_PID() != pid) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public PATsection[] getPATsections() {
        return this.pat;
    }

    public PAT getPat(long packetNo) {
        if (this.pat == null || this.pat.length == 0) {
            return null;
        }
        if (this.pat[0] != null && packetNo < (long)this.pat[0].getFirst_packet_no()) {
            return this;
        }
        if (this.pat[this.pat.length - 1] != null && packetNo < (long)this.pat[this.pat.length].getFirst_packet_no()) {
            return this;
        }
        PATsection l = this.pat[this.pat.length - 1];
        while ((long)l.getLast_packet_no() < packetNo && l.getNextVersion() != null) {
            l = (PATsection)l.getNextVersion();
        }
        return null;
    }

    public TableModel getTableModel() {
        FlexTableModel<PATsection, PATsection.Program> tableModel = new FlexTableModel<PATsection, PATsection.Program>(PAT.buildPatTableHeader());
        if (this.pat != null) {
            for (PATsection element : this.pat) {
                if (element == null) continue;
                tableModel.addData(element, element.getPrograms());
            }
        }
        tableModel.process();
        return tableModel;
    }

    static TableHeader<PATsection, PATsection.Program> buildPatTableHeader() {
        return new TableHeaderBuilder().addOptionalRowColumn("program_number", PATsection.Program::getProgram_number, Integer.class).addOptionalRowColumn("program_map_PID", PATsection.Program::getProgram_map_PID, Integer.class).addOptionalRowColumn("name", PATsection.Program::getServiceNameOrNit, String.class).build();
    }
}

