/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.psi.PAT;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSectionExtendedSyntax;
import nl.digitalekabeltelevisie.gui.TableSource;
import nl.digitalekabeltelevisie.util.Utils;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;

public class PATsection
extends TableSectionExtendedSyntax
implements TableSource {
    private List<Program> programs;

    public PATsection(PsiSectionData raw_data, PID parent) {
        super(raw_data, parent);
        int programsLength = this.sectionLength - 9;
        this.programs = this.buildProgramList(raw_data.getData(), 8, programsLength);
    }

    private List<Program> buildProgramList(byte[] data, int offset, int programInfoLength) {
        ArrayList<Program> r = new ArrayList<Program>();
        for (int t = 0; t < programInfoLength; t += 4) {
            Program c = new Program(Utils.getInt(data, offset + t, 2, 65535), Utils.getInt(data, offset + t + 2, 2, 8191));
            r.add(c);
        }
        return r;
    }

    public int getTransportStreamId() {
        return this.getTableIdExtension();
    }

    public int noPrograms() {
        return this.programs.size();
    }

    public int getProgramNumber(int i) {
        return Byte.toUnsignedInt(this.raw_data.getData()[8 + i * 4]) * 256 + Byte.toUnsignedInt(this.raw_data.getData()[9 + i * 4]);
    }

    public int getProgramMapPID(int i) {
        return (Byte.toUnsignedInt(this.raw_data.getData()[10 + i * 4]) & 0x1F) * 256 + Byte.toUnsignedInt(this.raw_data.getData()[11 + i * 4]);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("PATsection section=");
        b.append(this.getSectionNumber()).append(", lastSection=").append(this.getSectionLastNumber()).append(", transport_stream_id=").append(this.getTransportStreamId()).append(", noProgramms=").append(this.noPrograms());
        for (int i = 0; i < this.noPrograms(); ++i) {
            b.append(", ").append(i).append(":").append(this.getProgramNumber(i)).append(":").append(this.getProgramMapPID(i));
        }
        return b.toString();
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        KVP kvp = (KVP)t.getUserObject();
        kvp.addTableSource(this, "PAT");
        Utils.addListJTree(t, this.programs, modus, "programs");
        return t;
    }

    @Override
    protected String getTableIdExtensionLabel() {
        return "transport_stream_id";
    }

    public List<Program> getPrograms() {
        return this.programs;
    }

    public void setPrograms(List<Program> programs) {
        this.programs = programs;
    }

    @Override
    public TableModel getTableModel() {
        FlexTableModel<PATsection, Program> tableModel = new FlexTableModel<PATsection, Program>(PAT.buildPatTableHeader());
        tableModel.addData(this, this.getPrograms());
        tableModel.process();
        return tableModel;
    }

    public class Program
    implements TreeNode {
        private int program_number;
        private int program_map_PID;

        public Program(int program_number, int program_map_PID) {
            this.program_number = program_number;
            this.program_map_PID = program_map_PID;
        }

        public int getProgram_map_PID() {
            return this.program_map_PID;
        }

        public void setProgram_map_PID(int program_map_PID) {
            this.program_map_PID = program_map_PID;
        }

        public int getProgram_number() {
            return this.program_number;
        }

        public void setProgram_number(int program_number) {
            this.program_number = program_number;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            Object postFix = "";
            String serviceName = this.getServiceNameOrNit();
            if (serviceName != null) {
                postFix = " (" + serviceName + ")";
            }
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("program" + (String)postFix));
            t.add(new DefaultMutableTreeNode(new KVP("program_number", this.program_number, null)));
            t.add(new DefaultMutableTreeNode(new KVP("program_map_PID", this.program_map_PID, null)));
            return t;
        }

        public String getServiceNameOrNit() {
            String serviceName = PATsection.this.getParentPID().getParentTransportStream().getPsi().getSdt().getServiceNameForActualTransportStream(this.program_number);
            if (serviceName == null && this.program_map_PID == 16) {
                serviceName = "NIT";
            }
            return serviceName;
        }
    }
}

