/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.psi.AbstractPSITabel;
import nl.digitalekabeltelevisie.data.mpeg.psi.RCTsection;
import nl.digitalekabeltelevisie.util.Utils;

public class RCT
extends AbstractPSITabel {
    private final Map<Integer, RCTsection[]> rcts = new HashMap<Integer, RCTsection[]>();
    private int pid = 0;

    public RCT(PSI parent) {
        super(parent);
    }

    public void update(RCTsection section) {
        this.pid = section.getParentPID().getPid();
        int key = section.getTableIdExtension();
        RCTsection[] sections = this.rcts.computeIfAbsent(key, k -> new RCTsection[section.getSectionLastNumber() + 1]);
        if (sections[section.getSectionNumber()] == null) {
            sections[section.getSectionNumber()] = section;
        } else {
            RCTsection last = sections[section.getSectionNumber()];
            RCT.updateSectionVersion(section, last);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("RCT (Related Content Table) PID=" + this.pid));
        TreeSet<Integer> s = new TreeSet<Integer>(this.rcts.keySet());
        for (Integer type : s) {
            RCTsection[] sections = this.rcts.get(type);
            DefaultMutableTreeNode n = new DefaultMutableTreeNode(new KVP("RCT", type, Utils.getAppTypeIDString(type)));
            for (RCTsection tsection : sections) {
                if (tsection == null) continue;
                RCT.addSectionVersionsToJTree(n, tsection, modus);
            }
            t.add(n);
        }
        return t;
    }
}

