/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DescriptorFactory;
import nl.digitalekabeltelevisie.data.mpeg.psi.SDT;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSectionExtendedSyntax;
import nl.digitalekabeltelevisie.util.Utils;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;

public class SDTsection
extends TableSectionExtendedSyntax {
    private List<Service> serviceList;
    private int originalNetworkID;

    public SDTsection(PsiSectionData raw_data, PID parent) {
        super(raw_data, parent);
        this.originalNetworkID = Utils.getInt(raw_data.getData(), 8, 2, 65535);
        this.serviceList = this.buildServicesList(raw_data.getData(), 11, this.sectionLength - 12);
    }

    public int getTransportStreamID() {
        return this.getTableIdExtension();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("SDTsection section=");
        b.append(this.getSectionNumber()).append(", lastSection=").append(this.getSectionLastNumber()).append(", tableType=").append(SDTsection.getTableType(this.tableId)).append(", TransportStreamID=").append(this.getTransportStreamID()).append(", OriginalNetworkID=").append(this.getOriginalNetworkID()).append(", ");
        return b.toString();
    }

    public List<Service> getServiceList() {
        return this.serviceList;
    }

    public void setServiceList(List<Service> transportStreamList) {
        this.serviceList = transportStreamList;
    }

    public int noServices() {
        return this.serviceList.size();
    }

    private List<Service> buildServicesList(byte[] data, int offset, int programInfoLength) {
        Service c;
        ArrayList<Service> r = new ArrayList<Service>();
        for (int t = 0; t < programInfoLength; t += 5 + c.getServiceDescriptorsLength()) {
            c = new Service();
            c.setServiceID(Utils.getInt(data, offset + t, 2, 65535));
            c.setReserved(Utils.getInt(data, offset + t + 2, 1, 252) >> 2);
            c.setEitScheduleFlag(Utils.getInt(data, offset + t + 2, 1, 2) >> 1);
            c.setEitPresentFollowingFlag(Utils.getInt(data, offset + t + 2, 1, 1));
            c.setRunningStatus(Utils.getInt(data, offset + t + 3, 1, 224) >> 5);
            c.setFreeCAmode(Utils.getInt(data, offset + t + 3, 1, 16) >> 4);
            c.setServiceDescriptorsLength(Utils.getInt(data, offset + t + 3, 2, 4095));
            c.setDescriptorList(DescriptorFactory.buildDescriptorList(data, offset + t + 5, c.getServiceDescriptorsLength(), this));
            r.add(c);
        }
        return r;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        ((KVP)t.getUserObject()).addTableSource(this::getTableModel, "SDT Section");
        t.add(new DefaultMutableTreeNode(new KVP("original_network_id", this.originalNetworkID, Utils.getOriginalNetworkIDString(this.originalNetworkID))));
        Utils.addListJTree(t, this.serviceList, modus, "services_loop");
        return t;
    }

    @Override
    protected String getTableIdExtensionLabel() {
        return "transport_stream_id";
    }

    public int getOriginalNetworkID() {
        return this.originalNetworkID;
    }

    public void setOriginalNetworkID(int originalNetworkID) {
        this.originalNetworkID = originalNetworkID;
    }

    public static String getEitScheduleFlagString(int eitScheduleFlag) {
        switch (eitScheduleFlag) {
            case 0: {
                return "No EIT schedule information";
            }
            case 1: {
                return "EIT schedule information present in TS";
            }
        }
        return "Illegal value";
    }

    public static String getEitPresentFollowingFlagString(int eitPresentFollowingFlag) {
        switch (eitPresentFollowingFlag) {
            case 0: {
                return "No EIT_present_following information";
            }
            case 1: {
                return "EIT_present_following information present in TS";
            }
        }
        return "Illegal value";
    }

    public TableModel getTableModel() {
        FlexTableModel<SDTsection, Service> tableModel = new FlexTableModel<SDTsection, Service>(SDT.buildSdtTableHeader());
        tableModel.addData(this, this.getServiceList());
        tableModel.process();
        return tableModel;
    }

    public class Service
    implements TreeNode {
        private int serviceID;
        private int reserved;
        private int eitScheduleFlag;
        private int eitPresentFollowingFlag;
        private int runningStatus;
        private int freeCAmode;
        private int serviceDescriptorsLength;
        private List<Descriptor> descriptorList;

        public List<Descriptor> getDescriptorList() {
            return this.descriptorList;
        }

        public void setDescriptorList(List<Descriptor> descriptorList) {
            this.descriptorList = descriptorList;
        }

        public int getServiceDescriptorsLength() {
            return this.serviceDescriptorsLength;
        }

        public void setServiceDescriptorsLength(int transportDescriptorsLength) {
            this.serviceDescriptorsLength = transportDescriptorsLength;
        }

        public int getServiceID() {
            return this.serviceID;
        }

        public void setServiceID(int transportStreamID) {
            this.serviceID = transportStreamID;
        }

        public String toString() {
            StringBuilder b = new StringBuilder("Service, serviceID=");
            b.append(this.getServiceID()).append(", reserved_future_use=").append(this.getReserved()).append(", EIT_schedule_flag=");
            b.append(this.getEitScheduleFlag()).append(", EIT_present_following_flag=").append(this.getEitPresentFollowingFlag()).append(", running_status=");
            b.append(this.getRunningStatus()).append(", free_CA_mode=").append(this.getFreeCAmode()).append(", descriptors_loop_length=").append(this.getServiceDescriptorsLength()).append(",descriptors=");
            for (Descriptor d : this.descriptorList) {
                b.append(d).append(", ");
            }
            return b.toString();
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            String s = SDTsection.this.getPSI().getSdt().getServiceNameDVBString(SDTsection.this.originalNetworkID, SDTsection.this.tableIdExtension, this.serviceID).map(DVBString::toString).orElse("Service " + this.serviceID);
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("service (" + s + ")"));
            t.add(new DefaultMutableTreeNode(new KVP("service_id", this.serviceID, null)));
            t.add(new DefaultMutableTreeNode(new KVP("reserved_future_use", this.reserved, null)));
            t.add(new DefaultMutableTreeNode(new KVP("EIT_schedule_flag", this.eitScheduleFlag, SDTsection.getEitScheduleFlagString(this.eitScheduleFlag))));
            t.add(new DefaultMutableTreeNode(new KVP("EIT_present_following_flag", this.eitPresentFollowingFlag, SDTsection.getEitPresentFollowingFlagString(this.eitPresentFollowingFlag))));
            t.add(new DefaultMutableTreeNode(new KVP("running_status", this.runningStatus, TableSection.getRunningStatusString(this.runningStatus))));
            t.add(new DefaultMutableTreeNode(new KVP("free_CA_mode", this.freeCAmode, TableSection.getFreeCAmodeString(this.freeCAmode))));
            t.add(new DefaultMutableTreeNode(new KVP("service_descriptors_length", this.getServiceDescriptorsLength(), null)));
            Utils.addListJTree(t, this.descriptorList, modus, "service_descriptors");
            return t;
        }

        public int getEitPresentFollowingFlag() {
            return this.eitPresentFollowingFlag;
        }

        public void setEitPresentFollowingFlag(int eitPresentFollowingFlag) {
            this.eitPresentFollowingFlag = eitPresentFollowingFlag;
        }

        public int getEitScheduleFlag() {
            return this.eitScheduleFlag;
        }

        public void setEitScheduleFlag(int eitScheduleFlag) {
            this.eitScheduleFlag = eitScheduleFlag;
        }

        public int getFreeCAmode() {
            return this.freeCAmode;
        }

        public void setFreeCAmode(int freeCAmode) {
            this.freeCAmode = freeCAmode;
        }

        public int getRunningStatus() {
            return this.runningStatus;
        }

        public void setRunningStatus(int runningStatus) {
            this.runningStatus = runningStatus;
        }

        public int getReserved() {
            return this.reserved;
        }

        public void setReserved(int reserved) {
            this.reserved = reserved;
        }
    }
}

