/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DescriptorFactory;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSectionExtendedSyntax;
import nl.digitalekabeltelevisie.util.Utils;

public class SITsection
extends TableSectionExtendedSyntax {
    private final List<Descriptor> transmissionDescriptorList;
    private final List<Service> serviceList;
    private final int transmissionInfoLoopLength;

    public SITsection(PsiSectionData raw_data, PID parent) {
        super(raw_data, parent);
        this.transmissionInfoLoopLength = Utils.getInt(raw_data.getData(), 8, 2, 4095);
        this.transmissionDescriptorList = DescriptorFactory.buildDescriptorList(raw_data.getData(), 10, this.transmissionInfoLoopLength, this);
        this.serviceList = this.buildServiceList(raw_data.getData(), 10 + this.transmissionInfoLoopLength, this.sectionLength - this.transmissionInfoLoopLength - 15);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("SITsection section=");
        b.append(this.getSectionNumber()).append(", lastSection=").append(this.getSectionLastNumber()).append(", tableType=").append(SITsection.getTableType(this.tableId)).append(", ");
        return b.toString();
    }

    private List<Service> buildServiceList(byte[] data, int start, int len) {
        int serviceLoopLength;
        ArrayList<Service> r = new ArrayList<Service>();
        for (int t = 0; t < len; t += 4 + serviceLoopLength) {
            int serviceId = Utils.getInt(data, start + t, 2, 65535);
            int dvbReservedFutureUse = Utils.getInt(data, start + t + 2, 1, 128) >> 7;
            int runningStatus = Utils.getInt(data, start + t + 2, 1, 112) >> 4;
            serviceLoopLength = Utils.getInt(data, start + t + 2, 2, 4095);
            List<Descriptor> descriptorList = DescriptorFactory.buildDescriptorList(this.raw_data.getData(), 10, serviceLoopLength, this);
            Service c = new Service();
            c.setServiceID(serviceId);
            c.setReservedFutureUse(dvbReservedFutureUse);
            c.setRunningStatus(runningStatus);
            c.setServiceLoopLength(serviceLoopLength);
            c.setDescriptorList(descriptorList);
            r.add(c);
        }
        return r;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("transmission_info_loop_length", this.transmissionInfoLoopLength, null)));
        Utils.addListJTree(t, this.transmissionDescriptorList, modus, "transmission_descriptors");
        Utils.addListJTree(t, this.serviceList, modus, "transport_stream_loop");
        return t;
    }

    public List<Descriptor> getTransmissionDescriptorList() {
        return this.transmissionDescriptorList;
    }

    public List<Service> getServiceList() {
        return this.serviceList;
    }

    public int getTransmissionInfoLoopLength() {
        return this.transmissionInfoLoopLength;
    }

    public static class Service
    implements TreeNode {
        private int serviceID;
        private int reservedFutureUse;
        private int runningStatus;
        private int serviceLoopLength;
        private List<Descriptor> descriptorList;

        public List<Descriptor> getDescriptorList() {
            return this.descriptorList;
        }

        public void setDescriptorList(List<Descriptor> descriptorList) {
            this.descriptorList = descriptorList;
        }

        public String toString() {
            StringBuilder b = new StringBuilder("Service, serviceID=");
            b.append(this.serviceID).append(", reservedFutureUse=").append(this.reservedFutureUse).append(", ");
            for (Descriptor d : this.descriptorList) {
                b.append(d).append(", ");
            }
            return b.toString();
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("transport_stream:", this.serviceID, null));
            t.add(new DefaultMutableTreeNode(new KVP("service_id", this.serviceID, null)));
            t.add(new DefaultMutableTreeNode(new KVP("original_network_id", this.reservedFutureUse, Utils.getOriginalNetworkIDString(this.reservedFutureUse))));
            t.add(new DefaultMutableTreeNode(new KVP("service_loop_length", this.serviceLoopLength, null)));
            Utils.addListJTree(t, this.descriptorList, modus, "transport_descriptors");
            return t;
        }

        public int getServiceID() {
            return this.serviceID;
        }

        public void setServiceID(int serviceID) {
            this.serviceID = serviceID;
        }

        public int getReservedFutureUse() {
            return this.reservedFutureUse;
        }

        public void setReservedFutureUse(int reservedFutureUse) {
            this.reservedFutureUse = reservedFutureUse;
        }

        public int getRunningStatus() {
            return this.runningStatus;
        }

        public void setRunningStatus(int runningStatus) {
            this.runningStatus = runningStatus;
        }

        public int getServiceLoopLength() {
            return this.serviceLoopLength;
        }

        public void setServiceLoopLength(int serviceLoopLength) {
            this.serviceLoopLength = serviceLoopLength;
        }
    }
}

