/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.psi.AbstractPSITabel;
import nl.digitalekabeltelevisie.data.mpeg.psi.TDTsection;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeader;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeaderBuilder;

public class TDT
extends AbstractPSITabel {
    private final List<TDTsection> tdtSectionList = new ArrayList<TDTsection>();

    public TDT(PSI parent) {
        super(parent);
    }

    public void update(TDTsection section) {
        this.tdtSectionList.add(section);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        KVP kvp = new KVP("TDT");
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(kvp);
        if (!this.tdtSectionList.isEmpty()) {
            kvp.addTableSource(this::getTableModel, "TDT");
        }
        for (TDTsection tdTsection : this.tdtSectionList) {
            t.add(tdTsection.getJTreeNode(modus));
        }
        return t;
    }

    public List<TDTsection> getTdtSectionList() {
        return this.tdtSectionList;
    }

    static TableHeader<TDTsection, TDTsection> buildTdtTableHeader() {
        return new TableHeaderBuilder().addRequiredRowColumn("UTC_time", TDTsection::getUTC_timeString, String.class).build();
    }

    public TableModel getTableModel() {
        FlexTableModel<TDTsection, TDTsection> tableModel = new FlexTableModel<TDTsection, TDTsection>(TDT.buildTdtTableHeader());
        for (TDTsection element : this.tdtSectionList) {
            if (element == null) continue;
            tableModel.addData(element, List.of(element));
        }
        tableModel.process();
        return tableModel;
    }
}

