/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.Arrays;
import java.util.List;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DescriptorFactory;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.LocalTimeOffsetDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TOT;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;

public class TOTsection
extends TableSection {
    private final byte[] UTC_time;
    private final int descriptorsLoopLength;
    private final List<Descriptor> descriptorList;

    public TOTsection(PsiSectionData raw_data, PID parent) {
        super(raw_data, parent);
        this.UTC_time = Arrays.copyOfRange(raw_data.getData(), 3, 8);
        this.descriptorsLoopLength = Utils.getInt(raw_data.getData(), 8, 2, 4095);
        this.descriptorList = DescriptorFactory.buildDescriptorList(raw_data.getData(), 10, this.descriptorsLoopLength - 4, this);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("TOTsection UTC_Time=");
        b.append(Utils.toHexString(this.UTC_time)).append(", UTC_timeString=").append(Utils.getUTCFormattedString(this.UTC_time)).append(", length=").append(this.getSectionLength()).append(", ");
        for (Descriptor d : this.descriptorList) {
            b.append(d).append(", ");
        }
        return b.toString();
    }

    public byte[] getUTC_time() {
        return this.UTC_time;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        KVP kvp = (KVP)t.getUserObject();
        kvp.addTableSource(this::getTableModel, "TOT Section");
        t.add(new DefaultMutableTreeNode(new KVP("UTC_time", this.UTC_time, Utils.getUTCFormattedString(this.UTC_time))));
        if (!Utils.simpleModus(modus)) {
            t.add(new DefaultMutableTreeNode(new KVP("descriptors_loop_length", this.descriptorsLoopLength, null)));
        }
        Utils.addListJTree(t, this.descriptorList, modus, "descriptors");
        return t;
    }

    public int getDescriptorsLoopLength() {
        return this.descriptorsLoopLength;
    }

    public List<Descriptor> getDescriptorList() {
        return this.descriptorList;
    }

    public TableModel getTableModel() {
        FlexTableModel<TOTsection, LocalTimeOffsetDescriptor> tableModel = new FlexTableModel<TOTsection, LocalTimeOffsetDescriptor>(TOT.buildTotTableHeader());
        tableModel.addData(this, Descriptor.findGenericDescriptorsInList(this.getDescriptorList(), LocalTimeOffsetDescriptor.class));
        tableModel.process();
        return tableModel;
    }
}

