/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.Formatter;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.CRCcheck;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.TransportStream;
import nl.digitalekabeltelevisie.util.Utils;

public class TableSection
implements TreeNode {
    protected PsiSectionData raw_data;
    private PID parentPID;
    protected int tableId;
    protected int sectionSyntaxIndicator;
    protected int privateIndicator;
    protected int sectionLength;
    protected int tableIdExtension;
    protected int version;
    protected int currentNext;
    protected int sectionNumber;
    protected int sectionLastNumber;
    protected long crc;
    protected boolean crc_error;
    protected TableSection nextVersion;
    private int firstPacketNo;
    private int lastPacketNo;
    private long minPacketDistance = Long.MAX_VALUE;
    private long maxPacketDistance;
    private int occurrenceCount;
    private int packetNo;

    public TableSection(PsiSectionData raw_data, PID parent) {
        this.raw_data = raw_data;
        this.packetNo = raw_data.getPacket_no();
        this.firstPacketNo = raw_data.getPacket_no();
        this.lastPacketNo = raw_data.getPacket_no();
        this.occurrenceCount = 1;
        this.parentPID = parent;
        byte[] bytes = raw_data.getData();
        this.tableId = Utils.getInt(bytes, 0, 1, 255);
        this.sectionSyntaxIndicator = Utils.getInt(bytes, 1, 1, 128) >> 7;
        this.privateIndicator = Utils.getInt(bytes, 1, 1, 64) >> 6;
        this.sectionLength = Utils.getInt(bytes, 1, 2, 4095);
        if (this.sectionSyntaxIndicator == 1) {
            long res;
            this.tableIdExtension = Utils.getInt(bytes, 3, 2, 65535);
            this.version = Utils.getInt(bytes, 5, 1, 62) >> 1;
            this.currentNext = Utils.getInt(bytes, 5, 1, 1);
            this.sectionNumber = Utils.getInt(bytes, 6, 1, 255);
            this.sectionLastNumber = Utils.getInt(bytes, 7, 1, 255);
            int startCRC = this.sectionLength - 1;
            this.crc = (long)Byte.toUnsignedInt(bytes[startCRC]) << 24 | (long)Byte.toUnsignedInt(bytes[startCRC + 1]) << 16 | (long)Byte.toUnsignedInt(bytes[startCRC + 2]) << 8 | (long)Byte.toUnsignedInt(bytes[startCRC + 3]);
            if (this.tableId != 114 && (res = CRCcheck.crc32(bytes, this.sectionLength + 3)) != 0L) {
                this.crc_error = true;
                throw new RuntimeException("CRC Error in packet for pid:" + parent.getPid() + ",tableID:" + this.tableId + ",tableIdExtension:" + this.tableIdExtension + ",CRC=" + this.crc + ", packetNo=" + this.packetNo + ", privateIndicator=" + this.privateIndicator + ", sectionSyntaxIndicator:" + this.sectionSyntaxIndicator);
            }
        }
    }

    public long getCrc() {
        return this.crc;
    }

    public void setCrc(long crc) {
        this.crc = crc;
    }

    public int getTableIdExtension() {
        return this.tableIdExtension;
    }

    public void setTableIdExtension(int extension) {
        this.tableIdExtension = extension;
    }

    public int getSectionLastNumber() {
        return this.sectionLastNumber;
    }

    public void setSectionLastNumber(int lastNumber) {
        this.sectionLastNumber = lastNumber;
    }

    public int getSectionLength() {
        return this.sectionLength;
    }

    public void setSectionLength(int length) {
        this.sectionLength = length;
    }

    public int getSectionNumber() {
        return this.sectionNumber;
    }

    public void setSectionNumber(int number) {
        this.sectionNumber = number;
    }

    public int getTableId() {
        return this.tableId;
    }

    public void setTableId(int tableId) {
        this.tableId = tableId;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public PsiSectionData getRaw_data() {
        return this.raw_data;
    }

    public void setRaw_data(PsiSectionData raw_data) {
        this.raw_data = raw_data;
    }

    public static String getTableType(int tableId) {
        switch (tableId) {
            case 0: {
                return "program_association_section";
            }
            case 1: {
                return "conditional_access_section";
            }
            case 2: {
                return "program_map_section";
            }
            case 3: {
                return "transport_stream_description_section";
            }
            case 4: {
                return "ISO_IEC_14496_scene_description_section";
            }
            case 5: {
                return "ISO_IEC_14496_object_descriptor_section";
            }
            case 6: {
                return "Metadata Table";
            }
            case 7: {
                return "IPMP_Control_Information_section (ISO 13818-11)";
            }
            case 8: {
                return "ISO_IEC_14496_section";
            }
            case 9: {
                return "ISO/IEC 23001-11 (Green access unit) section";
            }
            case 10: {
                return "ISO/IEC 23001-10 (Quality access unit) section";
            }
            case 11: {
                return "ISO/IEC 23001-13 (Media Orchestration access unit) section";
            }
            case 56: {
                return "ISO/IEC 13818-6 reserved";
            }
            case 57: {
                return "ISO/IEC 13818-6 reserved";
            }
            case 58: {
                return "DSM-CC - multiprotocol encapsulated data";
            }
            case 59: {
                return "DSM-CC - U-N messages (DSI or DII)";
            }
            case 60: {
                return "DSM-CC - Download Data Messages (DDB)";
            }
            case 61: {
                return "DSM-CC - stream descriptorlist";
            }
            case 62: {
                return "DSM-CC sections with private data // DVB datagram (ISO/IEC 13818-6)";
            }
            case 63: {
                return "DSM-CC - Addressable Sections";
            }
            case 64: {
                return "network_information_section - actual_network";
            }
            case 65: {
                return "network_information_section - other_network";
            }
            case 66: {
                return "service_description_section - actual_transport_stream";
            }
            case 70: {
                return "service_description_section - other_transport_stream";
            }
            case 74: {
                return "bouquet_association_section";
            }
            case 75: {
                return "SSU Update Notification Table (UNT)";
            }
            case 76: {
                return "IP/MAC Notification Table (INT)";
            }
            case 77: {
                return "satellite_access_table_section";
            }
            case 78: {
                return "event_information_section - actual_transport_stream, present/following";
            }
            case 79: {
                return "event_information_section - other_transport_stream, present/following";
            }
            case 112: {
                return "time_date_section (TDT)";
            }
            case 113: {
                return "running_status_section (RST)";
            }
            case 114: {
                return "stuffing_section (ST)";
            }
            case 115: {
                return "time_offset_section (TOT)";
            }
            case 116: {
                return "MHP-application information section (AIT)";
            }
            case 117: {
                return "TVA-container section (CT)";
            }
            case 118: {
                return "TVA-related content section (RCT)";
            }
            case 119: {
                return "TVA-content identifier section (CIT)";
            }
            case 120: {
                return "MPE-FEC section (MFT)";
            }
            case 121: {
                return "TVA-resolution notification section (RNT)";
            }
            case 122: {
                return "MPE-IFEC section";
            }
            case 123: {
                return "protection message section";
            }
            case 124: {
                return "Downloadable Font Information Table (DFIT)";
            }
            case 126: {
                return "discontinuity_information_section";
            }
            case 127: {
                return "selection_information_section";
            }
            case 128: {
                return "CA_message_section, ECM 1";
            }
            case 129: {
                return "CA_message_section, ECM 2";
            }
            case 145: {
                return "user defined / Service Guide Table (SGT)";
            }
            case 188: {
                return "user defined / M7 Fastscan Network Table (FNT) ";
            }
            case 189: {
                return "user defined / M7 Fastscan Services Table (FST) ";
            }
            case 190: {
                return "user defined / M7 Operator Network Table (ONT) ";
            }
            case 192: {
                return "user defined / ATSC - Program Information Message";
            }
            case 193: {
                return "user defined / ATSC - Program Name Message";
            }
            case 194: {
                return "user defined / ATSC/SCTE - Network Information Message";
            }
            case 195: {
                return "user defined / ATSC/SCTE - Network Text Table (NTT)";
            }
            case 196: {
                return "user defined / ATSC/SCTE - Short Form Virtual Channel Table (S-VCT)";
            }
            case 197: {
                return "user defined / ATSC/SCTE - System Time Table (STT)";
            }
            case 198: {
                return "user defined / ATSC/SCTE - Subtitle Message (SCTE-27)";
            }
            case 199: {
                return "user defined / ATSC - Master Guide Table (MGT)";
            }
            case 200: {
                return "user defined / ATSC - Terrestrial Virtual Channel Table (TVCT)";
            }
            case 201: {
                return "user defined / ATSC - Cable Virtual Channel Table (CVCT) / Long-form Virtual Channel Table (L-VCT)";
            }
            case 202: {
                return "user defined / ATSC - Rating Region Table (RRT)";
            }
            case 203: {
                return "user defined / ATSC - Event Information Table (EIT)";
            }
            case 204: {
                return "user defined / ATSC - Extended Text Table (ETT)";
            }
            case 205: {
                return "user defined / ATSC - System Time Table (STT)";
            }
            case 206: {
                return "user defined / ATSC - Data Event Table (DET)";
            }
            case 207: {
                return "user defined / ATSC - Data Service Table (DST)";
            }
            case 208: {
                return "user defined / ATSC - Program Identifier Table (PIT)";
            }
            case 209: {
                return "user defined / ATSC - Network Resource Table (NRT)";
            }
            case 210: {
                return "user defined / ATSC - Long-term Service Table (L-TST)";
            }
            case 211: {
                return "user defined / ATSC - Directed Channel Change Table (DCCT)";
            }
            case 212: {
                return "user defined / ATSC - DCC Selection Code Table (DCCSCT)";
            }
            case 213: {
                return "user defined / ATSC - Selection Information Table (SIT)";
            }
            case 214: {
                return "user defined / ATSC - Aggregate Event Information Table (AEIT)";
            }
            case 215: {
                return "user defined / ATSC - Aggregate Extended Text Table (AETT)";
            }
            case 216: {
                return "user defined / ATSC - Cable Emergency Alert";
            }
            case 217: {
                return "user defined / ATSC - Aggregate Data Event Table";
            }
            case 218: {
                return "user defined / ATSC - Satellite VCT (SVCT)";
            }
            case 252: {
                return "user defined / SCTE - Splice_info_section (SCTE-35)";
            }
            case 255: {
                return "not used (illegal)";
            }
        }
        if (8 <= tableId && tableId <= 63) {
            return "ITU-T Rec. H.222.0|ISO/IEC13818 reserved";
        }
        if (67 <= tableId && tableId <= 69) {
            return "reserved for future use";
        }
        if (71 <= tableId && tableId <= 73) {
            return "reserved for future use";
        }
        if (80 <= tableId && tableId <= 95) {
            return "event_information_section - actual_transport_stream, schedule";
        }
        if (96 <= tableId && tableId <= 111) {
            return "event_information_section - other_transport_stream, schedule";
        }
        if (122 <= tableId && tableId <= 125) {
            return "reserved for future use";
        }
        if (130 <= tableId && tableId <= 143) {
            return "CA_message_section, CA System private";
        }
        if (144 <= tableId && tableId <= 254) {
            return "user defined";
        }
        return "illegal value";
    }

    public static String getRunningStatusString(int runningStatus) {
        return switch (runningStatus) {
            case 0 -> "undefined";
            case 1 -> "not running";
            case 2 -> "starts in a few seconds (e.g. for video recording)";
            case 3 -> "pausing";
            case 4 -> "running";
            case 5 -> "service off-air";
            case 6 -> "reserved for future use";
            case 7 -> "reserved for future use";
            default -> "Illegal value";
        };
    }

    public static String getFreeCAmodeString(int freeCAmode) {
        return switch (freeCAmode) {
            case 0 -> "clear";
            case 1 -> "one or more streams scrambled";
            default -> "Illegal value";
        };
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        KVP t = this.getSectionKVP(modus);
        this.addTableDetails(modus, t);
        return t;
    }

    private KVP getSectionKVP(int modus) {
        KVP kvp = new KVP("TableType: " + TableSection.getTableType(this.tableId) + " (" + this.sectionNumber + "/" + this.sectionLastNumber + ")");
        if (Utils.showVersionModus(modus) && this.sectionSyntaxIndicator == 1) {
            kvp.appendLabel(" <version " + this.version + ">");
        }
        kvp.setCrumb("tablesection:" + this.sectionNumber);
        return kvp;
    }

    protected void addTableDetails(int modus, DefaultMutableTreeNode t) {
        if (Utils.packetModus(modus)) {
            t.add(new KVP("first_packet_no", this.firstPacketNo).setDescription(this.parentPID.getParentTransportStream().getPacketTime(this.firstPacketNo)));
            t.add(new KVP("last_packet_no", this.lastPacketNo).setDescription(this.parentPID.getParentTransportStream().getPacketTime(this.lastPacketNo)));
            t.add(new KVP("occurrence_count", this.occurrenceCount).setDescription(this.getRepetitionRate(this.occurrenceCount, this.lastPacketNo, this.firstPacketNo)));
            if (this.occurrenceCount >= 2) {
                if (this.getParentTransportStream().isAVCHD()) {
                    t.add(new KVP("min_packet_distance in ticks", this.minPacketDistance).setDescription(Utils.printPCRTime(this.minPacketDistance)));
                    t.add(new KVP("max_packet_distance in ticks", this.maxPacketDistance).setDescription(Utils.printPCRTime(this.maxPacketDistance)));
                } else {
                    t.add(new KVP("min_packet_distance in packets", this.minPacketDistance).setDescription(this.getDistanceSecs(this.minPacketDistance)));
                    t.add(new KVP("max_packet_distance in packets", this.maxPacketDistance).setDescription(this.getDistanceSecs(this.maxPacketDistance)));
                }
            }
        }
        t.add(new KVP("table_id", this.tableId, TableSection.getTableType(this.tableId)));
        t.add(new KVP("section_syntax_indicator", this.sectionSyntaxIndicator));
        t.add(new KVP("private_indicator", this.privateIndicator));
        t.add(new KVP("section_length", this.sectionLength));
        if (this.sectionSyntaxIndicator == 1 && this.tableId != 114) {
            t.add(new KVP(this.getTableIdExtensionLabel(), this.tableIdExtension).setDescription(this.getTableIdExtensionDescription(this.tableIdExtension)));
            t.add(new KVP("version", this.version));
            t.add(new KVP("current_next_indicator", this.currentNext).setDescription(this.currentNext == 1 ? "current" : "next"));
            t.add(new KVP("section_number", this.sectionNumber));
            t.add(new KVP("last_section_number", this.sectionLastNumber));
            t.add(new KVP("private_data", this.raw_data.getData(), 8, this.sectionLength - 5));
        } else {
            t.add(new KVP("private_data", this.raw_data.getData(), 3, this.sectionLength));
        }
    }

    protected String getTableIdExtensionLabel() {
        return "table_id_extension";
    }

    protected String getTableIdExtensionDescription(int tableIdExtension) {
        return null;
    }

    private String getRepetitionRate(int count, int last, int first) {
        TransportStream parentTransportStream = this.parentPID.getParentTransportStream();
        long bitrate = parentTransportStream.getBitRate();
        if (bitrate > 0L && count >= 2) {
            float repRate;
            if (parentTransportStream.isAVCHD()) {
                long timeDiff = parentTransportStream.getAVCHDPacketTime(last) - parentTransportStream.getAVCHDPacketTime(first);
                repRate = (float)timeDiff / 2.7E7f / (float)(count - 1);
            } else {
                repRate = (float)(last - first) * (float)parentTransportStream.getPacketLenghth() * 8.0f / (float)((long)(count - 1) * bitrate);
            }
            try (Formatter formatter = new Formatter();){
                String string = "repetition rate: " + String.valueOf(formatter.format("%3.3f seconds", Float.valueOf(repRate)));
                return string;
            }
        }
        return null;
    }

    private String getDistanceSecs(long distanceInPackets) {
        TransportStream parentTransportStream = this.parentPID.getParentTransportStream();
        long bitrate = parentTransportStream.getBitRate();
        if (bitrate > 0L) {
            float repRate = (float)distanceInPackets * (float)parentTransportStream.getPacketLenghth() * 8.0f / (float)bitrate;
            try (Formatter formatter = new Formatter();){
                String string = "interval: " + String.valueOf(formatter.format("%3.3f seconds", Float.valueOf(repRate)));
                return string;
            }
        }
        return null;
    }

    public PID getParentPID() {
        return this.parentPID;
    }

    public void setParentPID(PID parentPID) {
        this.parentPID = parentPID;
    }

    public TransportStream getParentTransportStream() {
        return this.parentPID.getParentTransportStream();
    }

    public PSI getPSI() {
        return this.getParentTransportStream().getPsi();
    }

    public int getCurrentNext() {
        return this.currentNext;
    }

    public void setCurrentNext(int currentNext) {
        this.currentNext = currentNext;
    }

    public int getPrivateIndicator() {
        return this.privateIndicator;
    }

    public void setPrivateIndicator(int privateIndicator) {
        this.privateIndicator = privateIndicator;
    }

    public int getSectionSyntaxIndicator() {
        return this.sectionSyntaxIndicator;
    }

    public void setSectionSyntaxIndicator(int sectionSyntaxIndicator) {
        this.sectionSyntaxIndicator = sectionSyntaxIndicator;
    }

    public boolean isCrc_error() {
        return this.crc_error;
    }

    public void setCrc_error(boolean crc_error) {
        this.crc_error = crc_error;
    }

    public TableSection getNextVersion() {
        return this.nextVersion;
    }

    public void setNextVersion(TableSection next) {
        this.nextVersion = next;
    }

    public int getFirst_packet_no() {
        return this.firstPacketNo;
    }

    public void setFirst_packet_no(int first_packet_no) {
        this.firstPacketNo = first_packet_no;
    }

    public int getLast_packet_no() {
        return this.lastPacketNo;
    }

    public void setLast_packet_no(int last_packet_no) {
        this.lastPacketNo = last_packet_no;
    }

    public int getOccurrence_count() {
        return this.occurrenceCount;
    }

    public void setOccurrence_count(int occurrence_count) {
        this.occurrenceCount = occurrence_count;
    }

    public int getPacket_no() {
        return this.packetNo;
    }

    public void setPacket_no(int packetNo) {
        this.packetNo = packetNo;
        this.raw_data.setPacket_no(packetNo);
    }

    public String toString() {
        return "TableSection" + (String)(this.sectionSyntaxIndicator == 1 ? "tableIdExtension:" + this.tableIdExtension : "simple Syntax");
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.raw_data == null ? 0 : this.raw_data.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableSection other = (TableSection)obj;
        if (this.raw_data == null) {
            return other.raw_data == null;
        }
        return this.raw_data.equals(other.raw_data);
    }

    public long getMinPacketDistance() {
        return this.minPacketDistance;
    }

    public void setMinPacketDistance(long minPacketDistance) {
        this.minPacketDistance = minPacketDistance;
    }

    public long getMaxPacketDistance() {
        return this.maxPacketDistance;
    }

    public void setMaxPacketDistance(long maxPacketDistance) {
        this.maxPacketDistance = maxPacketDistance;
    }
}

