/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.psi.AbstractPSITabel;
import nl.digitalekabeltelevisie.data.mpeg.psi.UNTsection;
import nl.digitalekabeltelevisie.util.Utils;

public class UNT
extends AbstractPSITabel {
    private final Map<Integer, UNTsection[]> ssu = new HashMap<Integer, UNTsection[]>();
    private int pid = 0;

    public UNT(PSI parent) {
        super(parent);
    }

    public void update(UNTsection section) {
        this.pid = section.getParentPID().getPid();
        int key = section.getOui();
        UNTsection[] sections = this.ssu.computeIfAbsent(key, k -> new UNTsection[section.getSectionLastNumber() + 1]);
        if (sections[section.getSectionNumber()] == null) {
            sections[section.getSectionNumber()] = section;
        } else {
            UNTsection last = sections[section.getSectionNumber()];
            UNT.updateSectionVersion(section, last);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("UNT (Update Notification Table) PID=" + this.pid));
        TreeSet<Integer> s = new TreeSet<Integer>(this.ssu.keySet());
        for (Integer oui : s) {
            UNTsection[] sections = this.ssu.get(oui);
            DefaultMutableTreeNode n = new DefaultMutableTreeNode(new KVP("oui", oui, Utils.getOUIString(oui)));
            for (UNTsection tsection : sections) {
                if (tsection == null) continue;
                UNT.addSectionVersionsToJTree(n, tsection, modus);
            }
            t.add(n);
        }
        return t;
    }
}

