/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DescriptorFactory;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.untable.CompatibilityDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSectionExtendedSyntax;
import nl.digitalekabeltelevisie.util.Utils;

public class UNTsection
extends TableSectionExtendedSyntax {
    private final List<PlatformLoop> platformLoopList = new ArrayList<PlatformLoop>();
    private final int action_type;
    private final int oui_hash;
    private final int oui;
    private final int processing_order;
    private final int common_descriptor_loop_length;
    private final List<Descriptor> common_descriptor_loop;

    public static String getUNTActionTypeString(int actionType) {
        return switch (actionType) {
            case 0 -> "reserved";
            case 1 -> "System Software Update";
            default -> "reserved for future use";
        };
    }

    public static String getUNTProcessingOrderString(int p) {
        if (p >= 1 && p <= 254) {
            return "subsequent actions (ascending)";
        }
        if (p == 0) {
            return "first action";
        }
        return "reserved for future use";
    }

    public UNTsection(PsiSectionData raw_data, PID parent) {
        super(raw_data, parent);
        PlatformLoop pf;
        this.action_type = Utils.getInt(raw_data.getData(), 3, 1, 255);
        this.oui_hash = Utils.getInt(raw_data.getData(), 4, 1, 255);
        this.oui = Utils.getInt(raw_data.getData(), 8, 3, 0xFFFFFF);
        this.processing_order = Utils.getInt(raw_data.getData(), 11, 1, 255);
        this.common_descriptor_loop_length = Utils.getInt(raw_data.getData(), 12, 2, 4095);
        this.common_descriptor_loop = DescriptorFactory.buildDescriptorList(raw_data.getData(), 14, this.common_descriptor_loop_length, this);
        for (int t = 0; t < this.sectionLength - 18 - this.common_descriptor_loop_length; t += pf.getPlatform_loop_length() + pf.getCompatibilityDescriptor().getCompatibilityDescriptorLength() + 4) {
            pf = this.buildPlatformLoop(raw_data.getData(), 14 + t + this.common_descriptor_loop_length, this.sectionLength - 18 - this.common_descriptor_loop_length - t);
            this.platformLoopList.add(pf);
        }
    }

    @Override
    protected String getTableIdExtensionLabel() {
        return "action_type (8)/ OUI_hash (8)";
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("UNTsection section=");
        b.append(this.getSectionNumber()).append(", lastSection=").append(this.getSectionLastNumber()).append(", tableType=").append(UNTsection.getTableType(this.tableId)).append(", ");
        return b.toString();
    }

    private PlatformLoop buildPlatformLoop(byte[] data, int offset, int length) {
        PlatformLoop p = new PlatformLoop();
        CompatibilityDescriptor cd = new CompatibilityDescriptor(data, offset);
        p.setCompatibilityDescriptor(cd);
        int compLength = cd.getCompatibilityDescriptorLength();
        int platform_loop_length = Utils.getInt(data, offset + compLength + 2, 2, 65535);
        p.setPlatform_loop_length(platform_loop_length);
        p.setTarget_loop(this.buildTargetLoopList(data, offset + compLength + 4, platform_loop_length));
        return p;
    }

    private List<TargetLoop> buildTargetLoopList(byte[] data, int i, int programInfoLength) {
        TargetLoop c;
        ArrayList<TargetLoop> r = new ArrayList<TargetLoop>();
        for (int t = 0; t < programInfoLength; t += 2 + c.getOperational_descriptor_loop_length()) {
            c = new TargetLoop();
            c.setTarget_descriptor_loop_length(Utils.getInt(data, i + t, 2, 4095));
            c.setTarget_descriptor_loop(DescriptorFactory.buildDescriptorList(data, i + t + 2, c.getTarget_descriptor_loop_length(), this));
            c.setOperational_descriptor_loop_length(Utils.getInt(data, i + (t += 2 + c.getTarget_descriptor_loop_length()), 2, 4095));
            c.setOperational_descriptor_loop(DescriptorFactory.buildDescriptorList(data, i + t + 2, c.getOperational_descriptor_loop_length(), this));
            r.add(c);
        }
        return r;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("action_type", this.action_type, UNTsection.getUNTActionTypeString(this.action_type))));
        t.add(new DefaultMutableTreeNode(new KVP("oui_hash", this.oui_hash, null)));
        t.add(new DefaultMutableTreeNode(new KVP("oui", this.oui, Utils.getOUIString(this.oui))));
        t.add(new DefaultMutableTreeNode(new KVP("processing_order", this.processing_order, UNTsection.getUNTProcessingOrderString(this.processing_order))));
        t.add(new DefaultMutableTreeNode(new KVP("common_descriptor_loop_length", this.common_descriptor_loop_length, null)));
        Utils.addListJTree(t, this.common_descriptor_loop, modus, "common_descriptor_loop");
        Utils.addListJTree(t, this.platformLoopList, modus, "platform_loop");
        return t;
    }

    public int getOui() {
        return this.oui;
    }

    public int getAction_type() {
        return this.action_type;
    }

    public static class PlatformLoop
    implements TreeNode {
        private CompatibilityDescriptor compatibilityDescriptor;
        private int platform_loop_length;
        private List<TargetLoop> target_loop;

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("platform"));
            t.add(this.compatibilityDescriptor.getJTreeNode(modus));
            t.add(new DefaultMutableTreeNode(new KVP("platform_loop_length", this.platform_loop_length, null)));
            Utils.addListJTree(t, this.target_loop, modus, "target_loop");
            return t;
        }

        public CompatibilityDescriptor getCompatibilityDescriptor() {
            return this.compatibilityDescriptor;
        }

        public void setCompatibilityDescriptor(CompatibilityDescriptor compatibilityDescriptor) {
            this.compatibilityDescriptor = compatibilityDescriptor;
        }

        public int getPlatform_loop_length() {
            return this.platform_loop_length;
        }

        public void setPlatform_loop_length(int platform_loop_length) {
            this.platform_loop_length = platform_loop_length;
        }

        public List<TargetLoop> getTarget_loop() {
            return this.target_loop;
        }

        public void setTarget_loop(List<TargetLoop> target_loop) {
            this.target_loop = target_loop;
        }
    }

    public static class TargetLoop
    implements TreeNode {
        private int target_descriptor_loop_length;
        private int operational_descriptor_loop_length;
        private List<Descriptor> target_descriptor_loop;
        private List<Descriptor> operational_descriptor_loop;

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("target"));
            t.add(new DefaultMutableTreeNode(new KVP("target_descriptor_loop_length", this.target_descriptor_loop_length, null)));
            Utils.addListJTree(t, this.target_descriptor_loop, modus, "target_descriptor_loop");
            t.add(new DefaultMutableTreeNode(new KVP("operational_descriptor_loop_length", this.operational_descriptor_loop_length, null)));
            Utils.addListJTree(t, this.operational_descriptor_loop, modus, "operational_descriptor_loop");
            return t;
        }

        public List<Descriptor> getOperational_descriptor_loop() {
            return this.operational_descriptor_loop;
        }

        public void setOperational_descriptor_loop(List<Descriptor> operational_descriptor_loop) {
            this.operational_descriptor_loop = operational_descriptor_loop;
        }

        public int getOperational_descriptor_loop_length() {
            return this.operational_descriptor_loop_length;
        }

        public void setOperational_descriptor_loop_length(int operational_descriptor_loop_length) {
            this.operational_descriptor_loop_length = operational_descriptor_loop_length;
        }

        public List<Descriptor> getTarget_descriptor_loop() {
            return this.target_descriptor_loop;
        }

        public void setTarget_descriptor_loop(List<Descriptor> target_descriptor_loop) {
            this.target_descriptor_loop = target_descriptor_loop;
        }

        public int getTarget_descriptor_loop_length() {
            return this.target_descriptor_loop_length;
        }

        public void setTarget_descriptor_loop_length(int target_descriptor_loop_length) {
            this.target_descriptor_loop_length = target_descriptor_loop_length;
        }
    }
}

