/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi.handler;

import java.util.List;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.TSPacket;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.DSMCCs;
import nl.digitalekabeltelevisie.data.mpeg.pes.GeneralPidHandler;
import nl.digitalekabeltelevisie.data.mpeg.psi.AITs;
import nl.digitalekabeltelevisie.data.mpeg.psi.AITsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.BAT;
import nl.digitalekabeltelevisie.data.mpeg.psi.BATsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.CAT;
import nl.digitalekabeltelevisie.data.mpeg.psi.CAsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.DFITSection;
import nl.digitalekabeltelevisie.data.mpeg.psi.DFITs;
import nl.digitalekabeltelevisie.data.mpeg.psi.EIT;
import nl.digitalekabeltelevisie.data.mpeg.psi.EITsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.GeneralPSITable;
import nl.digitalekabeltelevisie.data.mpeg.psi.INT;
import nl.digitalekabeltelevisie.data.mpeg.psi.INTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.NIT;
import nl.digitalekabeltelevisie.data.mpeg.psi.NITsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.PAT;
import nl.digitalekabeltelevisie.data.mpeg.psi.PATsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.PMTs;
import nl.digitalekabeltelevisie.data.mpeg.psi.PMTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.RCTs;
import nl.digitalekabeltelevisie.data.mpeg.psi.RCTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.SCTE35;
import nl.digitalekabeltelevisie.data.mpeg.psi.SDT;
import nl.digitalekabeltelevisie.data.mpeg.psi.SDTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.SIT;
import nl.digitalekabeltelevisie.data.mpeg.psi.SITsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.SpliceInfoSection;
import nl.digitalekabeltelevisie.data.mpeg.psi.TDT;
import nl.digitalekabeltelevisie.data.mpeg.psi.TDTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.TOT;
import nl.digitalekabeltelevisie.data.mpeg.psi.TOTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.TSDT;
import nl.digitalekabeltelevisie.data.mpeg.psi.TSDTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSectionExtendedSyntax;
import nl.digitalekabeltelevisie.data.mpeg.psi.UNTs;
import nl.digitalekabeltelevisie.data.mpeg.psi.UNTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.m7fastscan.FNTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.m7fastscan.FSTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.m7fastscan.M7Fastscan;
import nl.digitalekabeltelevisie.data.mpeg.psi.m7fastscan.ONTSection;
import nl.digitalekabeltelevisie.data.mpeg.psi.ses.SGT;
import nl.digitalekabeltelevisie.data.mpeg.psi.ses.SGTsection;

public class GeneralPsiTableHandler
extends GeneralPidHandler {
    private static final Logger logger = Logger.getLogger(GeneralPsiTableHandler.class.getName());
    private PAT pat;
    private CAT cat;
    private BAT bat;
    private TSDT tsdt;
    private NIT nit;
    private SDT sdt;
    private PMTs pmts;
    private EIT eit;
    private TDT tdt;
    private TOT tot;
    private SIT sit;
    private UNTs unt_table;
    private INT int_table;
    private AITs ait_table;
    private RCTs rct_table;
    private DSMCCs dsm_table;
    private SCTE35 scte35_table;
    private DFITs dfit_table;
    private M7Fastscan m7fastscan;
    private SGT sgt;

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new KVP("Interpreted PSI"));
        GeneralPsiTableHandler.addToNodeIfNotNull(node, this.pat, modus);
        GeneralPsiTableHandler.addToNodeIfNotNull(node, this.cat, modus);
        GeneralPsiTableHandler.addToNodeIfNotNull(node, this.bat, modus);
        GeneralPsiTableHandler.addToNodeIfNotNull(node, this.tsdt, modus);
        GeneralPsiTableHandler.addToNodeIfNotNull(node, this.pmts, modus);
        GeneralPsiTableHandler.addToNodeIfNotNull(node, this.nit, modus);
        GeneralPsiTableHandler.addToNodeIfNotNull(node, this.sdt, modus);
        GeneralPsiTableHandler.addToNodeIfNotNull(node, this.eit, modus);
        GeneralPsiTableHandler.addToNodeIfNotNull(node, this.tdt, modus);
        GeneralPsiTableHandler.addToNodeIfNotNull(node, this.tot, modus);
        GeneralPsiTableHandler.addToNodeIfNotNull(node, this.sit, modus);
        GeneralPsiTableHandler.addToNodeIfNotNull(node, this.ait_table, modus);
        GeneralPsiTableHandler.addToNodeIfNotNull(node, this.unt_table, modus);
        GeneralPsiTableHandler.addToNodeIfNotNull(node, this.int_table, modus);
        GeneralPsiTableHandler.addToNodeIfNotNull(node, this.rct_table, modus);
        GeneralPsiTableHandler.addToNodeIfNotNull(node, this.scte35_table, modus);
        GeneralPsiTableHandler.addToNodeIfNotNull(node, this.dfit_table, modus);
        GeneralPsiTableHandler.addToNodeIfNotNull(node, this.dsm_table, modus);
        GeneralPsiTableHandler.addToNodeIfNotNull(node, this.m7fastscan, modus);
        GeneralPsiTableHandler.addToNodeIfNotNull(node, this.sgt, modus);
        return node;
    }

    @Override
    public String getMenuDescription() {
        return "Interpret as PSI";
    }

    @Override
    public void processTSPacket(TSPacket packet) {
    }

    @Override
    public void postProcess() {
        this.initialized = true;
        GeneralPSITable psi = this.pid.getPsi();
        List<GeneralPSITable.TableSectionOccurrence> tableSectionOccurrences = psi.getTableSectionOccurrences();
        for (GeneralPSITable.TableSectionOccurrence tableSectionOccurrence : tableSectionOccurrences) {
            int packetNo = tableSectionOccurrence.getPacketNo();
            TableSection section = new TableSection(new PsiSectionData(tableSectionOccurrence.getTableSection().getRaw_data()), this.pid);
            section.setPacket_no(packetNo);
            this.interpretSectionByTableId(section);
        }
    }

    private void interpretSectionByTableId(TableSection section) {
        if (section == null) {
            return;
        }
        try {
            int tableID = section.getTableId();
            if (tableID == 0) {
                this.handlePAT(section);
            } else if (tableID == 1) {
                this.handleCAT(section);
            } else if (tableID == 2) {
                this.handlePMT(section);
            } else if (tableID == 3) {
                this.handleTSDT(section);
            } else if (tableID >= 55 && tableID <= 63) {
                this.handleDSMCC(section);
            } else if (tableID == 64 || tableID == 65) {
                this.handleNIT(section);
            } else if (tableID == 74) {
                this.handleBAT(section);
            } else if (tableID == 66 || tableID == 70) {
                this.handleSDT(section);
            } else if (78 <= tableID && tableID <= 111) {
                this.handleEIT(section);
            } else if (tableID == 75) {
                this.handleUNT(section);
            } else if (tableID == 76) {
                this.handleINT(section);
            } else if (tableID == 112) {
                this.handleTDT(section);
            } else if (tableID == 115) {
                this.handleTOT(section);
            } else if (tableID == 116) {
                this.handleAIT(section);
            } else if (tableID == 118) {
                this.handleRCT(section);
            } else if (tableID == 127) {
                this.handleSIT(section);
            } else if (tableID == 124) {
                this.handleDFIT(section);
            } else if (tableID == 145) {
                this.handleSGT(section);
            } else if (tableID >= 188 && tableID <= 190) {
                this.handleFastScan(section);
            } else if (tableID == 252) {
                this.handleSCTE35(section);
            }
        }
        catch (RuntimeException rte) {
            logger.info("Ignoring section with tableId:" + section.getTableId() + ", exception:" + rte.getMessage());
        }
    }

    private void handlePAT(TableSection section) {
        if (this.pat == null) {
            this.pat = new PAT(this.getTransportStream().getPsi());
        }
        PATsection p = new PATsection(section.getRaw_data(), this.pid);
        GeneralPsiTableHandler.copyMetaData(section, p);
        this.pat.update(p);
    }

    private void handlePMT(TableSection section) {
        if (this.pmts == null) {
            this.pmts = new PMTs(this.getTransportStream().getPsi());
        }
        PMTsection pmt = new PMTsection(section.getRaw_data(), this.pid);
        GeneralPsiTableHandler.copyMetaData(section, pmt);
        this.pmts.update(pmt);
    }

    private void handleTSDT(TableSection section) {
        if (this.tsdt == null) {
            this.tsdt = new TSDT(this.getTransportStream().getPsi());
        }
        TSDTsection s = new TSDTsection(section.getRaw_data(), this.pid);
        GeneralPsiTableHandler.copyMetaData(section, s);
        this.tsdt.update(s);
    }

    private void handleNIT(TableSection section) {
        if (this.nit == null) {
            this.nit = new NIT(this.getTransportStream().getPsi());
        }
        NITsection s = new NITsection(section.getRaw_data(), this.pid);
        GeneralPsiTableHandler.copyMetaData(section, s);
        this.nit.update(s);
    }

    private void handleBAT(TableSection section) {
        if (this.bat == null) {
            this.bat = new BAT(this.getTransportStream().getPsi());
        }
        BATsection s = new BATsection(section.getRaw_data(), this.pid);
        GeneralPsiTableHandler.copyMetaData(section, s);
        this.bat.update(s);
    }

    private void handleEIT(TableSection section) {
        if (this.eit == null) {
            this.eit = new EIT(this.getTransportStream().getPsi());
        }
        EITsection s = new EITsection(section.getRaw_data(), this.pid);
        GeneralPsiTableHandler.copyMetaData(section, s);
        this.eit.update(s);
    }

    private void handleCAT(TableSection section) {
        if (this.cat == null) {
            this.cat = new CAT(this.getTransportStream().getPsi());
        }
        CAsection s = new CAsection(section.getRaw_data(), this.pid);
        GeneralPsiTableHandler.copyMetaData(section, s);
        this.cat.update(s);
    }

    private void handleSDT(TableSection section) {
        if (this.sdt == null) {
            this.sdt = new SDT(this.getTransportStream().getPsi());
        }
        SDTsection s = new SDTsection(section.getRaw_data(), this.pid);
        GeneralPsiTableHandler.copyMetaData(section, s);
        this.sdt.update(s);
    }

    private void handleAIT(TableSection section) {
        if (this.ait_table == null) {
            this.ait_table = new AITs(this.getTransportStream().getPsi());
        }
        AITsection s = new AITsection(section.getRaw_data(), this.pid);
        GeneralPsiTableHandler.copyMetaData(section, s);
        this.ait_table.update(s);
    }

    private void handleSIT(TableSection section) {
        if (this.sit == null) {
            this.sit = new SIT(this.getTransportStream().getPsi());
        }
        SITsection s = new SITsection(section.getRaw_data(), this.pid);
        GeneralPsiTableHandler.copyMetaData(section, s);
        this.sit.update(s);
    }

    private void handleSGT(TableSection section) {
        if (this.sgt == null) {
            this.sgt = new SGT(this.getTransportStream().getPsi());
        }
        SGTsection s = new SGTsection(section.getRaw_data(), this.pid);
        GeneralPsiTableHandler.copyMetaData(section, s);
        this.sgt.update(s);
    }

    private void handleUNT(TableSection section) {
        if (this.unt_table == null) {
            this.unt_table = new UNTs(this.getTransportStream().getPsi());
        }
        UNTsection s = new UNTsection(section.getRaw_data(), this.pid);
        GeneralPsiTableHandler.copyMetaData(section, s);
        this.unt_table.update(s);
    }

    private void handleINT(TableSection section) {
        if (this.int_table == null) {
            this.int_table = new INT(this.getTransportStream().getPsi());
        }
        INTsection s = new INTsection(section.getRaw_data(), this.pid);
        GeneralPsiTableHandler.copyMetaData(section, s);
        this.int_table.update(s);
    }

    private void handleRCT(TableSection section) {
        if (this.rct_table == null) {
            this.rct_table = new RCTs(this.getTransportStream().getPsi());
        }
        RCTsection s = new RCTsection(section.getRaw_data(), this.pid);
        GeneralPsiTableHandler.copyMetaData(section, s);
        this.rct_table.update(s);
    }

    private void handleSCTE35(TableSection section) {
        if (this.scte35_table == null) {
            this.scte35_table = new SCTE35(this.getTransportStream().getPsi());
        }
        SpliceInfoSection s = new SpliceInfoSection(section.getRaw_data(), this.pid);
        GeneralPsiTableHandler.copyMetaData(section, s);
        this.scte35_table.update(s);
    }

    private void handleDFIT(TableSection section) {
        if (this.dfit_table == null) {
            this.dfit_table = new DFITs(this.getTransportStream().getPsi());
        }
        DFITSection s = new DFITSection(section.getRaw_data(), this.pid);
        GeneralPsiTableHandler.copyMetaData(section, s);
        this.dfit_table.update(s);
    }

    private void handleDSMCC(TableSection section) {
        if (this.dsm_table == null) {
            this.dsm_table = new DSMCCs(this.getTransportStream().getPsi());
        }
        TableSectionExtendedSyntax s = new TableSectionExtendedSyntax(section.getRaw_data(), this.pid);
        GeneralPsiTableHandler.copyMetaData(section, s);
        this.dsm_table.update(s);
    }

    private void handleTDT(TableSection section) {
        if (this.tdt == null) {
            this.tdt = new TDT(this.getTransportStream().getPsi());
        }
        TDTsection s = new TDTsection(section.getRaw_data(), this.pid);
        GeneralPsiTableHandler.copyMetaData(section, s);
        this.tdt.update(s);
    }

    private void handleTOT(TableSection section) {
        if (this.tot == null) {
            this.tot = new TOT(this.getTransportStream().getPsi());
        }
        TOTsection s = new TOTsection(section.getRaw_data(), this.pid);
        GeneralPsiTableHandler.copyMetaData(section, s);
        this.tot.update(s);
    }

    private void handleFastScan(TableSection section) {
        int tableId;
        if (this.m7fastscan == null) {
            this.m7fastscan = new M7Fastscan(this.getTransportStream().getPsi());
        }
        if ((tableId = section.getTableId()) == 188) {
            FNTsection s = new FNTsection(section.getRaw_data(), this.pid);
            GeneralPsiTableHandler.copyMetaData(section, s);
            this.m7fastscan.update(s);
        } else if (tableId == 189) {
            FSTsection s = new FSTsection(section.getRaw_data(), this.pid);
            GeneralPsiTableHandler.copyMetaData(section, s);
            this.m7fastscan.update(s);
        } else if (tableId == 190) {
            ONTSection s = new ONTSection(section.getRaw_data(), this.pid);
            GeneralPsiTableHandler.copyMetaData(section, s);
            this.m7fastscan.update(s);
        }
    }

    private static void copyMetaData(TableSection source, TableSection dest) {
        dest.setFirst_packet_no(source.getPacket_no());
        dest.setLast_packet_no(source.getPacket_no());
        dest.setMaxPacketDistance(0L);
        dest.setMinPacketDistance(Integer.MAX_VALUE);
        dest.setOccurrence_count(1);
    }

    private static void addToNodeIfNotNull(DefaultMutableTreeNode node, TreeNode treeNode, int modus) {
        if (treeNode != null) {
            node.add(treeNode.getJTreeNode(modus));
        }
    }
}

