/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi.m7fastscan;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.table.TableModel;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DescriptorFactory;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.NetworkNameDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.SatelliteDeliverySystemDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ServiceListDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.m7fastscan.M7LogicalChannelDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSectionExtendedSyntax;
import nl.digitalekabeltelevisie.util.Utils;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeader;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeaderBuilder;

public class FNTsection
extends TableSectionExtendedSyntax {
    private final List<Descriptor> networkDescriptorList;
    private final List<TransportStream> transportStreamList;
    private final int network_descriptors_loop_length;
    private final int transport_stream_loop_length;

    public FNTsection(PsiSectionData raw_data, PID parent) {
        super(raw_data, parent);
        this.network_descriptors_loop_length = Utils.getInt(raw_data.getData(), 8, 2, 4095);
        this.networkDescriptorList = DescriptorFactory.buildDescriptorList(raw_data.getData(), 10, this.network_descriptors_loop_length, this);
        this.transport_stream_loop_length = Utils.getInt(raw_data.getData(), 10 + this.network_descriptors_loop_length, 2, 4095);
        this.transportStreamList = this.buildTransportStreamList(raw_data.getData(), 12 + this.network_descriptors_loop_length, this.transport_stream_loop_length);
    }

    public int getOperatorNetworkID() {
        return this.getTableIdExtension();
    }

    @Override
    public String toString() {
        return "FNTsection section=" + this.getSectionNumber() + ", lastSection=" + this.getSectionLastNumber() + ", tableType=" + FNTsection.getTableType(this.tableId) + ", NetworkID=" + this.getOperatorNetworkID() + ", ";
    }

    public List<Descriptor> getNetworkDescriptorList() {
        return this.networkDescriptorList;
    }

    public List<TransportStream> getTransportStreamList() {
        return this.transportStreamList;
    }

    public int getTransportStreamLoopLength() {
        return this.transport_stream_loop_length;
    }

    public int noTransportStreams() {
        return this.transportStreamList.size();
    }

    private List<TransportStream> buildTransportStreamList(byte[] data, int i, int programInfoLength) {
        int transportDescriptorsLength;
        ArrayList<TransportStream> transportStreams = new ArrayList<TransportStream>();
        for (int t = 0; t < programInfoLength; t += 6 + transportDescriptorsLength) {
            int transportStreamID = Utils.getInt(data, i + t, 2, 65535);
            int originalNetworkID = Utils.getInt(data, i + t + 2, 2, 65535);
            transportDescriptorsLength = Utils.getInt(data, i + t + 4, 2, 4095);
            List<Descriptor> descriptorList = DescriptorFactory.buildDescriptorList(data, i + t + 6, transportDescriptorsLength, this);
            TransportStream transportStream = new TransportStream(transportStreamID, originalNetworkID, transportDescriptorsLength, descriptorList);
            transportStreams.add(transportStream);
        }
        return transportStreams;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP kvp = (KVP)super.getJTreeNode(modus);
        kvp.addTableSource(this::getTableModel, "FNT");
        kvp.add(new KVP("network_descriptors_loop_length", this.network_descriptors_loop_length));
        kvp.addList(this.networkDescriptorList, modus, "network_descriptors");
        kvp.add(new KVP("transport_stream_loop_length", this.transport_stream_loop_length));
        kvp.addList(this.transportStreamList, modus, "transport_stream_loop");
        return kvp;
    }

    public TableModel getTableModel() {
        FlexTableModel<FNTsection, TransportStream> tableModel = new FlexTableModel<FNTsection, TransportStream>(FNTsection.buildFntTableHeader());
        tableModel.addData(this, this.transportStreamList);
        tableModel.process();
        return tableModel;
    }

    static TableHeader<FNTsection, TransportStream> buildFntTableHeader() {
        return new TableHeaderBuilder().addOptionalBaseColumn("network name", network -> Descriptor.findDescriptorApplyFunc(network.getNetworkDescriptorList(), NetworkNameDescriptor.class, nnd -> "".equals(nnd.getNetworkNameAsString()) ? null : nnd.getNetworkNameAsString()), String.class).addRequiredRowColumn("onid", TransportStream::originalNetworkID, Integer.class).addRequiredRowColumn("tsid", TransportStream::transportStreamID, Integer.class).addOptionalRowColumn("sat frequency", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), SatelliteDeliverySystemDescriptor.class, sat -> Descriptor.formatSatelliteFrequency(sat.getFrequency())), Number.class).addOptionalRowColumn("sat position", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), SatelliteDeliverySystemDescriptor.class, sat -> Descriptor.formatOrbitualPosition(sat.getOrbitalPosition())), Number.class).addOptionalRowColumn("sat west_east", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), SatelliteDeliverySystemDescriptor.class, SatelliteDeliverySystemDescriptor::getWestEastFlagString), String.class).addOptionalRowColumn("sat polarization", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), SatelliteDeliverySystemDescriptor.class, sat -> SatelliteDeliverySystemDescriptor.getPolarizationString(sat.getPolarization())), String.class).addOptionalRowColumn("mod system", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), SatelliteDeliverySystemDescriptor.class, SatelliteDeliverySystemDescriptor::getModulationSystemString), String.class).addOptionalRowColumn("roll_off", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), SatelliteDeliverySystemDescriptor.class, sat -> sat.getModulationSystem() == 1 ? SatelliteDeliverySystemDescriptor.getRollOffString(sat.getRollOff()) : null), Number.class).addOptionalRowColumn("mod type", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), SatelliteDeliverySystemDescriptor.class, sat -> SatelliteDeliverySystemDescriptor.getModulationString(sat.getModulationType())), String.class).addOptionalRowColumn("sat symbol_rate", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), SatelliteDeliverySystemDescriptor.class, sat -> Descriptor.formatSymbolRate(sat.getSymbol_rate())), Number.class).addOptionalRowColumn("sat fec_inner", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), SatelliteDeliverySystemDescriptor.class, sat -> Descriptor.getFEC_innerString(sat.getFEC_inner())), String.class).addOptionalRepeatingGroupedColumn("sid", transportStream -> Descriptor.findDescriptorApplyListFunc(transportStream.descriptorList(), ServiceListDescriptor.class, sld -> sld.getServiceList().stream().map(ServiceListDescriptor.Service::getServiceID).collect(Collectors.toList())), Integer.class, "service_list").addOptionalRepeatingGroupedColumn("type", transportStream -> Descriptor.findDescriptorApplyListFunc(transportStream.descriptorList(), ServiceListDescriptor.class, sld -> sld.getServiceList().stream().map(p -> Descriptor.getServiceTypeString(p.getServiceType())).collect(Collectors.toList())), String.class, "service_list").addOptionalRepeatingGroupedColumn("lcn sid", transportStream -> Descriptor.findDescriptorApplyListFunc(transportStream.descriptorList(), M7LogicalChannelDescriptor.class, lcd -> lcd.getChannelList().stream().map(M7LogicalChannelDescriptor.LogicalChannel::serviceID).collect(Collectors.toList())), Integer.class, "lcn_list").addOptionalRepeatingGroupedColumn("lcn no", transportStream -> Descriptor.findDescriptorApplyListFunc(transportStream.descriptorList(), M7LogicalChannelDescriptor.class, lcd -> lcd.getChannelList().stream().map(M7LogicalChannelDescriptor.LogicalChannel::logicalChannelNumber).collect(Collectors.toList())), Integer.class, "lcn_list").build();
    }

    public record TransportStream(int transportStreamID, int originalNetworkID, int transportDescriptorsLength, List<Descriptor> descriptorList) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP kvp = new KVP("transport_stream:", this.transportStreamID);
            kvp.add(new KVP("transport_stream_id", this.transportStreamID));
            kvp.add(new KVP("original_network_id", this.originalNetworkID, Utils.getOriginalNetworkIDString(this.originalNetworkID)));
            kvp.add(new KVP("transport_descriptors_length", this.transportDescriptorsLength));
            kvp.addList(this.descriptorList, modus, "transport_descriptors");
            return kvp;
        }
    }
}

