/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi.m7fastscan;

import java.nio.charset.Charset;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableModel;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.SatelliteDeliverySystemDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ServiceDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.m7fastscan.M7LogicalChannelDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.AbstractPSITabel;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSectionExtendedSyntax;
import nl.digitalekabeltelevisie.data.mpeg.psi.m7fastscan.FNTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.m7fastscan.FSTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.m7fastscan.M7Fastscan;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeader;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeaderBuilder;

public class OperatorFastscan
implements TreeNode {
    public static final Charset m7FastScanCharset = Charset.forName("ISO-8859-9");
    private static final Logger logger = Logger.getLogger(OperatorFastscan.class.getName());
    private final int pid;
    private int operatorNetworkId = -1;
    private final M7Fastscan m7Fastscan;
    private FNTsection[] fntSections;
    private FSTsection[] fstSections;

    public OperatorFastscan(int pid, M7Fastscan m7Fastscan) {
        this.pid = pid;
        this.m7Fastscan = m7Fastscan;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP networkKVP = new KVP("Pid", this.pid, this.getOperatorSubListName());
        if (this.fntSections == null) {
            networkKVP.addHTMLSource(() -> "FNT Missing", "FNT Missing");
        } else if (this.fstSections == null) {
            networkKVP.addHTMLSource(() -> "FST Missing", "FST Missing");
        } else {
            networkKVP.addTableSource(this::getTableModel, "Operator Fastscan");
        }
        if (this.fstSections != null) {
            KVP fstKvp = new KVP("FST");
            fstKvp.addTableSource(this::getFstTableModel, "FST");
            for (TableSectionExtendedSyntax tableSectionExtendedSyntax : this.fstSections) {
                if (tableSectionExtendedSyntax == null) continue;
                AbstractPSITabel.addSectionVersionsToJTree(fstKvp, tableSectionExtendedSyntax, modus);
            }
            networkKVP.add(fstKvp);
        }
        if (this.fntSections != null) {
            KVP fntKvp = new KVP("FNT");
            fntKvp.addTableSource(this::getFntTableModel, "FNT");
            for (TableSectionExtendedSyntax tableSectionExtendedSyntax : this.fntSections) {
                if (tableSectionExtendedSyntax == null) continue;
                AbstractPSITabel.addSectionVersionsToJTree(fntKvp, tableSectionExtendedSyntax, modus);
            }
            networkKVP.add(fntKvp);
        }
        return networkKVP;
    }

    public String getOperatorSubListName() {
        return this.m7Fastscan.getOperatorSubListName(this.operatorNetworkId, this.pid);
    }

    public void update(FSTsection section) {
        if (this.operatorNetworkId == -1) {
            this.operatorNetworkId = section.getOperatorNetworkID();
        } else if (this.operatorNetworkId != section.getOperatorNetworkID()) {
            logger.log(Level.WARNING, "update::FSTsection, ocurrent peratorNetworkId:" + this.operatorNetworkId + " not equal to section.getOperatorNetworkID():" + section.getOperatorNetworkID());
        }
        if (this.fstSections == null) {
            this.fstSections = new FSTsection[section.getSectionLastNumber() + 1];
        }
        if (this.fstSections[section.getSectionNumber()] == null) {
            this.fstSections[section.getSectionNumber()] = section;
        } else {
            FSTsection last = this.fstSections[section.getSectionNumber()];
            AbstractPSITabel.updateSectionVersion(section, last);
        }
    }

    public void update(FNTsection section) {
        if (this.operatorNetworkId == -1) {
            this.operatorNetworkId = section.getOperatorNetworkID();
        } else if (this.operatorNetworkId != section.getOperatorNetworkID()) {
            logger.log(Level.WARNING, "update::FNTsection, ocurrent peratorNetworkId:" + this.operatorNetworkId + " not equal to section.getOperatorNetworkID():" + section.getOperatorNetworkID());
        }
        if (this.fntSections == null) {
            this.fntSections = new FNTsection[section.getSectionLastNumber() + 1];
        }
        if (this.fntSections[section.getSectionNumber()] == null) {
            this.fntSections[section.getSectionNumber()] = section;
        } else {
            FNTsection last = this.fntSections[section.getSectionNumber()];
            AbstractPSITabel.updateSectionVersion(section, last);
        }
    }

    public TableModel getFntTableModel() {
        FlexTableModel<FNTsection, FNTsection.TransportStream> tableModel = new FlexTableModel<FNTsection, FNTsection.TransportStream>(FNTsection.buildFntTableHeader());
        for (FNTsection fntSection : this.fntSections) {
            if (fntSection == null) continue;
            tableModel.addData(fntSection, fntSection.getTransportStreamList());
        }
        tableModel.process();
        return tableModel;
    }

    public TableModel getFstTableModel() {
        FlexTableModel<FSTsection, FSTsection.Service> tableModel = new FlexTableModel<FSTsection, FSTsection.Service>(FSTsection.buildFstTableHeader());
        for (FSTsection fstSection : this.fstSections) {
            if (fstSection == null) continue;
            tableModel.addData(fstSection, fstSection.getServiceList());
        }
        tableModel.process();
        return tableModel;
    }

    private TableHeader<FNTsection.TransportStream, FSTsection.Service> buildFastscanTableHeader() {
        return new TableHeaderBuilder().addOptionalRowColumn("lcn", this::getLcn, Integer.class).addRequiredRowColumn("onid", FSTsection.Service::original_network_id, Integer.class).addRequiredRowColumn("tsid", FSTsection.Service::transport_stream_id, Integer.class).addRequiredRowColumn("sid", FSTsection.Service::service_id, Integer.class).addOptionalRowColumn("service name", operator -> Descriptor.findDescriptorApplyFunc(operator.descriptorList(), ServiceDescriptor.class, sd -> sd.getServiceName().toString(m7FastScanCharset)), String.class).addOptionalRowColumn("service type", operator -> Descriptor.findDescriptorApplyFunc(operator.descriptorList(), ServiceDescriptor.class, sd -> Descriptor.getServiceTypeString(sd.getServiceType())), String.class).addOptionalRowColumn("service provider", operator -> Descriptor.findDescriptorApplyFunc(operator.descriptorList(), ServiceDescriptor.class, sd -> sd.getServiceProviderName().toString(m7FastScanCharset)), String.class).addOptionalRowColumn("position", this::getOrbitualPosition, Number.class).addOptionalRowColumn("w/e", this::getWestEastFlag, String.class).addOptionalRowColumn("frequency", this::getFrequency, Number.class).build();
    }

    private String getOrbitualPosition(FSTsection.Service service) {
        SatelliteDeliverySystemDescriptor sdd = this.getSatelliteDeliverySystemDescriptor(service);
        if (sdd != null) {
            return Descriptor.formatOrbitualPosition(sdd.getOrbitalPosition());
        }
        return null;
    }

    private String getWestEastFlag(FSTsection.Service service) {
        SatelliteDeliverySystemDescriptor sdd = this.getSatelliteDeliverySystemDescriptor(service);
        if (sdd != null) {
            return sdd.getWestEastFlagString();
        }
        return null;
    }

    private String getFrequency(FSTsection.Service service) {
        SatelliteDeliverySystemDescriptor sdd = this.getSatelliteDeliverySystemDescriptor(service);
        if (sdd != null) {
            return Descriptor.formatSatelliteFrequency(sdd.getFrequency());
        }
        return null;
    }

    private SatelliteDeliverySystemDescriptor getSatelliteDeliverySystemDescriptor(FSTsection.Service service) {
        List<SatelliteDeliverySystemDescriptor> lcnDescs;
        FNTsection.TransportStream ts = this.getTransportStreamFromFnt(service);
        if (ts != null && !(lcnDescs = Descriptor.findGenericDescriptorsInList(ts.descriptorList(), SatelliteDeliverySystemDescriptor.class)).isEmpty()) {
            return lcnDescs.getFirst();
        }
        return null;
    }

    private Integer getLcn(FSTsection.Service service) {
        List<M7LogicalChannelDescriptor> lcnDescs;
        FNTsection.TransportStream ts = this.getTransportStreamFromFnt(service);
        if (ts != null && !(lcnDescs = Descriptor.findGenericDescriptorsInList(ts.descriptorList(), M7LogicalChannelDescriptor.class)).isEmpty()) {
            M7LogicalChannelDescriptor desc = lcnDescs.getFirst();
            for (M7LogicalChannelDescriptor.LogicalChannel channel : desc.getChannelList()) {
                if (channel.serviceID() != service.service_id()) continue;
                return channel.logicalChannelNumber();
            }
        }
        return null;
    }

    private FNTsection.TransportStream getTransportStreamFromFnt(FSTsection.Service service) {
        for (FNTsection fntSection : this.fntSections) {
            if (fntSection == null) continue;
            for (FNTsection.TransportStream ts : fntSection.getTransportStreamList()) {
                if (ts.originalNetworkID() != service.original_network_id() || ts.transportStreamID() != service.transport_stream_id()) continue;
                return ts;
            }
        }
        return null;
    }

    public TableModel getTableModel() {
        FlexTableModel<FNTsection.TransportStream, FSTsection.Service> tableModel = new FlexTableModel<FNTsection.TransportStream, FSTsection.Service>(this.buildFastscanTableHeader());
        for (FSTsection fstSection : this.fstSections) {
            if (fstSection == null) continue;
            tableModel.addData(null, fstSection.getServiceList());
        }
        tableModel.process();
        return tableModel;
    }

    public static Charset getM7FastScanCharset() {
        return m7FastScanCharset;
    }

    public int getPid() {
        return this.pid;
    }

    public int getOperatorNetworkId() {
        return this.operatorNetworkId;
    }

    public FNTsection[] getFntSections() {
        return this.fntSections;
    }

    public FSTsection[] getFstSections() {
        return this.fstSections;
    }
}

