/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi.ses;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DescriptorFactory;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSectionExtendedSyntax;
import nl.digitalekabeltelevisie.data.mpeg.psi.ses.SGT;
import nl.digitalekabeltelevisie.util.Utils;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;

public class SGTsection
extends TableSectionExtendedSyntax {
    private int reserved1;
    private int reserved_future_use1;
    private int service_list_descriptors_length;
    private List<Descriptor> serviceListDescriptorsList;
    private int reserved_future_use2;
    private int service_loop_length;
    private List<Service> serviceList;

    public SGTsection(PsiSectionData raw_data, PID parent) {
        super(raw_data, parent);
        this.reserved1 = Utils.getInt(raw_data.getData(), 8, 2, 65535);
        this.reserved_future_use1 = Utils.getInt(raw_data.getData(), 10, 1, 240) >>> 4;
        this.service_list_descriptors_length = Utils.getInt(raw_data.getData(), 10, 2, 4095);
        this.serviceListDescriptorsList = DescriptorFactory.buildDescriptorList(raw_data.getData(), 12, this.service_list_descriptors_length, this);
        this.reserved_future_use2 = Utils.getInt(raw_data.getData(), 12 + this.service_list_descriptors_length, 1, 240) >>> 4;
        this.service_loop_length = Utils.getInt(raw_data.getData(), 12 + this.service_list_descriptors_length, 2, 4095);
        this.serviceList = this.buildServicesList(raw_data.getData(), 14 + this.service_list_descriptors_length, this.service_loop_length);
    }

    private List<Service> buildServicesList(byte[] data, int offset, int programInfoLength) {
        int service_descriptors_length;
        ArrayList<Service> r = new ArrayList<Service>();
        for (int t = offset; t < programInfoLength + offset; t += 12 + service_descriptors_length) {
            Service service = new Service();
            service.setService_id(Utils.getInt(data, t, 2, 65535));
            service.setTransport_stream_id(Utils.getInt(data, t + 2, 2, 65535));
            service.setOriginal_network_id(Utils.getInt(data, t + 4, 2, 65535));
            service.setLogical_channel_number(Utils.getInt(data, t + 6, 2, 65532) >>> 2);
            service.setVisible_service_flag(Utils.getInt(data, t + 7, 1, 2) >>> 1);
            service.setNew_service_flag(Utils.getInt(data, t + 7, 1, 1));
            service.setGenre_code(Utils.getInt(data, t + 8, 2, 65535));
            service.setReserved_future_use(Utils.getInt(data, t + 10, 1, 240) >>> 4);
            service_descriptors_length = Utils.getInt(data, t + 10, 2, 4095);
            service.setService_descriptors_length(service_descriptors_length);
            service.setDescriptorList(DescriptorFactory.buildDescriptorList(data, t + 12, service_descriptors_length, this));
            r.add(service);
        }
        return r;
    }

    @Override
    protected String getTableIdExtensionLabel() {
        return "service_list_id";
    }

    public int getServiceListId() {
        return this.getTableIdExtension();
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = (KVP)super.getJTreeNode(modus);
        t.addTableSource(this::getTableModel, "SGT Section");
        t.add(new KVP("reserved", this.reserved1));
        t.add(new KVP("reserved_future_use", this.reserved_future_use1));
        t.add(new KVP("service_list_descriptors_length", this.service_list_descriptors_length));
        Utils.addListJTree(t, this.serviceListDescriptorsList, modus, "service_list_descriptors");
        t.add(new KVP("reserved_future_use", this.reserved_future_use2));
        t.add(new KVP("service_loop_length", this.service_loop_length));
        Utils.addListJTree(t, this.serviceList, modus, "services_loop");
        return t;
    }

    public TableModel getTableModel() {
        FlexTableModel<SGTsection, Service> tableModel = new FlexTableModel<SGTsection, Service>(SGT.buildSgtTableHeader());
        tableModel.addData(this, this.serviceList);
        tableModel.process();
        return tableModel;
    }

    public int getReserved1() {
        return this.reserved1;
    }

    public int getReserved_future_use1() {
        return this.reserved_future_use1;
    }

    public int getService_list_descriptors_length() {
        return this.service_list_descriptors_length;
    }

    public List<Descriptor> getServiceListDescriptorsList() {
        return this.serviceListDescriptorsList;
    }

    public int getReserved_future_use2() {
        return this.reserved_future_use2;
    }

    public int getService_loop_length() {
        return this.service_loop_length;
    }

    public List<Service> getServiceList() {
        return this.serviceList;
    }

    public static class Service
    implements TreeNode {
        private int service_id;
        private int transport_stream_id;
        private int original_network_id;
        private int logical_channel_number;
        private int visible_service_flag;
        private int new_service_flag;
        private int genre_code;
        private int reserved_future_use;
        private int service_descriptors_length;
        private List<Descriptor> descriptorList;

        @Override
        public KVP getJTreeNode(int modus) {
            KVP kvp = new KVP("Service");
            kvp.add(new KVP("service_id", this.service_id));
            kvp.add(new KVP("transport_stream_id", this.transport_stream_id));
            kvp.add(new KVP("original_network_id", this.original_network_id));
            kvp.add(new KVP("logical_channel_number", this.logical_channel_number));
            kvp.add(new KVP("visible_service_flag", this.visible_service_flag));
            kvp.add(new KVP("new_service_flag", this.new_service_flag));
            kvp.add(new KVP("genre_code", this.genre_code));
            kvp.add(new KVP("reserved_future_use", this.reserved_future_use));
            kvp.add(new KVP("service_descriptors_length", this.service_descriptors_length));
            kvp.addList(this.descriptorList, modus, "service_descriptors");
            return kvp;
        }

        public int getService_id() {
            return this.service_id;
        }

        public void setService_id(int service_id) {
            this.service_id = service_id;
        }

        public int getTransport_stream_id() {
            return this.transport_stream_id;
        }

        public void setTransport_stream_id(int transport_stream_id) {
            this.transport_stream_id = transport_stream_id;
        }

        public int getOriginal_network_id() {
            return this.original_network_id;
        }

        public void setOriginal_network_id(int original_network_id) {
            this.original_network_id = original_network_id;
        }

        public int getLogical_channel_number() {
            return this.logical_channel_number;
        }

        public void setLogical_channel_number(int logical_channel_number) {
            this.logical_channel_number = logical_channel_number;
        }

        public int getVisible_service_flag() {
            return this.visible_service_flag;
        }

        public void setVisible_service_flag(int visible_service_flag) {
            this.visible_service_flag = visible_service_flag;
        }

        public int getNew_service_flag() {
            return this.new_service_flag;
        }

        public void setNew_service_flag(int new_service_flag) {
            this.new_service_flag = new_service_flag;
        }

        public int getGenre_code() {
            return this.genre_code;
        }

        public void setGenre_code(int genre_code) {
            this.genre_code = genre_code;
        }

        public int getReserved_future_use() {
            return this.reserved_future_use;
        }

        public void setReserved_future_use(int reserved_future_use) {
            this.reserved_future_use = reserved_future_use;
        }

        public int getService_descriptors_length() {
            return this.service_descriptors_length;
        }

        public void setService_descriptors_length(int service_descriptors_length) {
            this.service_descriptors_length = service_descriptors_length;
        }

        public List<Descriptor> getDescriptorList() {
            return this.descriptorList;
        }

        public void setDescriptorList(List<Descriptor> descriptorList) {
            this.descriptorList = descriptorList;
        }
    }
}

