/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import nl.digitalekabeltelevisie.controller.ChartLabel;
import nl.digitalekabeltelevisie.controller.ViewContext;
import nl.digitalekabeltelevisie.data.mpeg.TransportStream;
import nl.digitalekabeltelevisie.gui.TransportStreamView;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.data.xy.CategoryTableXYDataset;

public class BitRateChart
extends JPanel
implements TransportStreamView {
    private JFreeChart freeChart;
    private final JPanel buttonPanel = new JPanel();
    private final ChartPanel chartPanel;
    private boolean legendVisible = true;

    public BitRateChart(TransportStream transportStream, ViewContext viewContext) {
        super(new BorderLayout());
        this.addLegendRadioButtons();
        this.add((Component)this.buttonPanel, "First");
        this.chartPanel = new ChartPanel(null, false);
        this.chartPanel.isMouseWheelEnabled();
        this.chartPanel.setMouseWheelEnabled(true);
        this.setTransportStream(transportStream, viewContext);
        this.add((Component)this.chartPanel, "Center");
    }

    @Override
    public final void setTransportStream(TransportStream transportStream, ViewContext viewContext) {
        if (transportStream == null) {
            this.freeChart = null;
            this.chartPanel.setChart(GuiUtils.createTitleOnlyChart("No transportstream loaded, drag a MPEG-TS (*.ts;*.mpg;*.mpeg;*.m2ts;*.mts;*.tsa;*.tsv) file here"));
        } else {
            CategoryTableXYDataset categoryTableXYDataset = transportStream.isAVCHD() ? BitRateChart.createAvchdDataSet(transportStream, viewContext) : BitRateChart.createCbrDataSet(transportStream, viewContext);
            XYPlot plot = BitRateChart.createXYPlot(transportStream, viewContext, categoryTableXYDataset);
            this.freeChart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, plot, this.legendVisible);
            plot.setRangePannable(true);
            plot.setDomainPannable(true);
            this.chartPanel.setChart(this.freeChart);
            this.chartPanel.setDomainZoomable(true);
            this.chartPanel.setRangeZoomable(true);
        }
    }

    private static XYPlot createXYPlot(TransportStream transportStream, ViewContext viewContext, CategoryTableXYDataset categoryTableXYDataset) {
        NumberAxis xAxis = new NumberAxis("time");
        xAxis.setAutoRangeIncludesZero(false);
        xAxis.setLowerMargin(0.0);
        xAxis.setUpperMargin(0.0);
        xAxis.setNumberFormatOverride(new PacketTimeNumberFormat(transportStream));
        NumberAxis yAxis = new NumberAxis("bitrate");
        StandardXYToolTipGenerator toolTipGenerator = new StandardXYToolTipGenerator("PID: {0}, Time: {1}, bitrate: {2}", (NumberFormat)new PacketTimeNumberFormat(transportStream), NumberFormat.getNumberInstance());
        StackedXYAreaRenderer2 renderer = new StackedXYAreaRenderer2(toolTipGenerator, null);
        int noPIDs = viewContext.getShown().size();
        for (int i = 0; i < noPIDs; ++i) {
            renderer.setSeriesPaint(i, viewContext.getShown().get(i).getColor());
        }
        renderer.setOutline(false);
        XYPlot plot = new XYPlot(categoryTableXYDataset, xAxis, yAxis, renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        plot.setRangeAxis(yAxis);
        return plot;
    }

    private static CategoryTableXYDataset createCbrDataSet(TransportStream transportStream, ViewContext viewContext) {
        int noPIDs = viewContext.getShown().size();
        short[] used_pids = BitRateChart.createUsedPidsArray(viewContext, noPIDs);
        ChartLabel[] labels = BitRateChart.createChartLabels(viewContext, noPIDs);
        int numberOfSteps = viewContext.getGraphSteps();
        CategoryTableXYDataset categoryTableXYDataset = new CategoryTableXYDataset();
        int startPacketStep = BitRateChart.getFirstPacketNoOfStep(viewContext, 0);
        for (int step = 0; step < numberOfSteps; ++step) {
            int endPacketStep = BitRateChart.getFirstPacketNoOfStep(viewContext, step + 1);
            int[] pidcount = BitRateChart.countPidOccurrencesInStep(transportStream, startPacketStep, endPacketStep);
            for (int pidIndex = 0; pidIndex < used_pids.length; ++pidIndex) {
                if (transportStream.getBitRate() == -1L) {
                    categoryTableXYDataset.add(startPacketStep, pidcount[used_pids[pidIndex]], labels[pidIndex].getLabel());
                    continue;
                }
                if (endPacketStep <= startPacketStep) continue;
                categoryTableXYDataset.add(startPacketStep, (long)pidcount[used_pids[pidIndex]] * transportStream.getBitRate() / (long)(endPacketStep - startPacketStep), labels[pidIndex].getLabel());
            }
            startPacketStep = endPacketStep;
        }
        return categoryTableXYDataset;
    }

    static short[] createUsedPidsArray(ViewContext viewContext, int noPIDs) {
        short[] used_pids = new short[noPIDs];
        for (int i = 0; i < noPIDs; ++i) {
            used_pids[i] = viewContext.getShown().get(i).getPid();
        }
        return used_pids;
    }

    private static ChartLabel[] createChartLabels(ViewContext viewContext, int noPIDs) {
        ChartLabel[] labels = new ChartLabel[noPIDs];
        for (int i = 0; i < noPIDs; ++i) {
            labels[i] = viewContext.getShown().get(i);
        }
        return labels;
    }

    private static int[] countPidOccurrencesInStep(TransportStream transportStream, int startPacketStep, int endPacketStep) {
        int[] pidcount = new int[8192];
        for (int r = startPacketStep; r < endPacketStep; ++r) {
            short pid_current_packet;
            short s = pid_current_packet = transportStream.getPacket_pid(r);
            pidcount[s] = pidcount[s] + 1;
        }
        return pidcount;
    }

    private static int getFirstPacketNoOfStep(ViewContext viewContext, int step) {
        int steps = viewContext.getGraphSteps();
        long packetsInSelectedRange = viewContext.getEndPacket() - viewContext.getStartPacket();
        return viewContext.getStartPacket() + (int)((long)step * packetsInSelectedRange / (long)steps);
    }

    private void addLegendRadioButtons() {
        JLabel typeLabel = new JLabel("Legend:");
        this.buttonPanel.add(typeLabel);
        JRadioButton onButton = new JRadioButton("On");
        onButton.addActionListener(e -> {
            if (!this.legendVisible) {
                this.legendVisible = true;
                if (this.freeChart != null) {
                    this.freeChart.getLegend().setVisible(this.legendVisible);
                }
            }
        });
        JRadioButton offButton = new JRadioButton("Off");
        offButton.addActionListener(e -> {
            if (this.legendVisible) {
                this.legendVisible = false;
                if (this.freeChart != null) {
                    this.freeChart.getLegend().setVisible(this.legendVisible);
                }
            }
        });
        onButton.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(onButton);
        group.add(offButton);
        this.buttonPanel.add(onButton);
        this.buttonPanel.add(offButton);
    }

    private static CategoryTableXYDataset createAvchdDataSet(TransportStream transportStream, ViewContext viewContext) {
        int noPIDs = viewContext.getShown().size();
        short[] used_pids = BitRateChart.createUsedPidsArray(viewContext, noPIDs);
        ChartLabel[] labels = BitRateChart.createChartLabels(viewContext, noPIDs);
        int numberOfSteps = viewContext.getGraphSteps();
        CategoryTableXYDataset categoryTableXYDataset = new CategoryTableXYDataset();
        long startSelectionTime = transportStream.getAVCHDPacketTime(viewContext.getStartPacket());
        long endSelectionTime = transportStream.getAVCHDPacketTime(viewContext.getEndPacket() - 1);
        long selectionDuration = endSelectionTime - startSelectionTime;
        int packetIndex = viewContext.getStartPacket();
        long startStepPacketTime = startSelectionTime;
        for (int step = 0; step < numberOfSteps; ++step) {
            long endStepPacketTime = startSelectionTime + selectionDuration * (long)(step + 1) / (long)numberOfSteps;
            int[] pidcount = new int[8192];
            while (packetIndex < viewContext.getEndPacket() && transportStream.getAVCHDPacketTime(packetIndex) <= endStepPacketTime) {
                short pid_current_packet;
                short s = pid_current_packet = transportStream.getPacket_pid(packetIndex);
                pidcount[s] = pidcount[s] + 1;
                ++packetIndex;
            }
            for (int pidIndex = 0; pidIndex < used_pids.length; ++pidIndex) {
                if (endStepPacketTime <= startStepPacketTime) continue;
                long bitRate = (long)pidcount[used_pids[pidIndex]] * 27000000L * 8L * 192L / (endStepPacketTime - startStepPacketTime);
                categoryTableXYDataset.add(startStepPacketTime, bitRate, labels[pidIndex].getLabel());
            }
            startStepPacketTime = endStepPacketTime;
        }
        return categoryTableXYDataset;
    }

    public static final class PacketTimeNumberFormat
    extends NumberFormat {
        private final TransportStream transportStream;

        public PacketTimeNumberFormat(TransportStream transportStream) {
            this.transportStream = transportStream;
        }

        @Override
        public Number parse(String source, ParsePosition parsePosition) {
            return null;
        }

        @Override
        public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
            String s = this.transportStream.getShortPacketTime(number);
            return toAppendTo.append(s);
        }

        @Override
        public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
            String s = this.transportStream.getShortPacketTime((long)number);
            return toAppendTo.append(s);
        }
    }
}

