/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import nl.digitalekabeltelevisie.controller.ViewContext;
import nl.digitalekabeltelevisie.data.mpeg.TransportStream;
import nl.digitalekabeltelevisie.gui.EITableImage;
import nl.digitalekabeltelevisie.gui.ImageCopyAction;
import nl.digitalekabeltelevisie.gui.ImageSaveAction;
import nl.digitalekabeltelevisie.gui.TransportStreamView;
import nl.digitalekabeltelevisie.gui.utils.WrapLayout;

public class EITView
extends JPanel
implements TransportStreamView {
    private final EITableImage eitPanel;
    private final JPanel toolbar = new JPanel(new WrapLayout(0));

    public EITView(TransportStream transportStream, ViewContext viewContext) {
        super(new BorderLayout());
        this.eitPanel = new EITableImage(transportStream);
        JScrollPane scrollGrid = new JScrollPane(this.eitPanel);
        scrollGrid.setVerticalScrollBarPolicy(22);
        scrollGrid.setHorizontalScrollBarPolicy(32);
        this.createCopySaveButtonBar();
        this.toolbar.add(Box.createHorizontalStrut(50));
        this.addPfScheduleRadioButtons();
        this.toolbar.add(Box.createHorizontalStrut(50));
        this.addZoomRadioButtons();
        this.add((Component)this.toolbar, "First");
        this.add((Component)scrollGrid, "Center");
    }

    private void createCopySaveButtonBar() {
        ImageCopyAction copyAction = new ImageCopyAction(this, "Copy", this.eitPanel);
        JButton copyButton = new JButton(copyAction);
        KeyStroke copyKey = KeyStroke.getKeyStroke(67, 2);
        this.getInputMap(1).put(copyKey, "copy");
        this.getActionMap().put("copy", copyAction);
        this.toolbar.add(copyButton);
        ImageSaveAction saveAction = new ImageSaveAction(this, "Save As...", this.eitPanel);
        JButton saveButton = new JButton(saveAction);
        KeyStroke saveKey = KeyStroke.getKeyStroke(83, 2);
        this.getInputMap(1).put(saveKey, "save");
        this.getActionMap().put("save", saveAction);
        this.toolbar.add(saveButton);
    }

    private void addPfScheduleRadioButtons() {
        JLabel typeLabel = new JLabel("Table:");
        this.toolbar.add(typeLabel);
        JRadioButton pfButton = new JRadioButton("Present/Following");
        pfButton.addActionListener(e -> this.eitPanel.selectPresentFollowing());
        JRadioButton scheduleButton = new JRadioButton("Schedule");
        scheduleButton.addActionListener(e -> this.eitPanel.selectSchedule());
        scheduleButton.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(pfButton);
        group.add(scheduleButton);
        this.toolbar.add(pfButton);
        this.toolbar.add(scheduleButton);
    }

    private void addZoomRadioButtons() {
        JLabel typeLabel = new JLabel("Zoom:");
        this.toolbar.add(typeLabel);
        JRadioButton zoom1Button = new JRadioButton("1");
        zoom1Button.addActionListener(e -> this.eitPanel.setZoom(30000L));
        JRadioButton zoom2Button = new JRadioButton("2");
        zoom2Button.addActionListener(e -> this.eitPanel.setZoom(15000L));
        JRadioButton zoom3Button = new JRadioButton("3");
        zoom3Button.addActionListener(e -> this.eitPanel.setZoom(7500L));
        zoom2Button.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(zoom1Button);
        group.add(zoom2Button);
        group.add(zoom3Button);
        this.toolbar.add(zoom1Button);
        this.toolbar.add(zoom2Button);
        this.toolbar.add(zoom3Button);
    }

    @Override
    public void setTransportStream(TransportStream transportStream, ViewContext viewContext) {
        this.eitPanel.setTransportStream(transportStream);
        this.validate();
        this.repaint();
    }
}

