/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.data.mpeg.TransportStream;
import nl.digitalekabeltelevisie.data.mpeg.psi.EIT;
import nl.digitalekabeltelevisie.data.mpeg.psi.EITsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.TDTsection;
import nl.digitalekabeltelevisie.gui.ImageSource;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.Interval;
import nl.digitalekabeltelevisie.util.ServiceIdentification;
import nl.digitalekabeltelevisie.util.Utils;

public class EITableImage
extends JPanel
implements ComponentListener,
ImageSource,
Scrollable {
    private static final Logger logger = Logger.getLogger(EITableImage.class.getName());
    private static final String FONT_NAME = "SansSerif";
    private static final int LINE_HEIGHT = 20;
    private static final long DEFAULT_MILLI_SECS_PER_PIXEL = 30000L;
    private static final int SERVICE_NAME_WIDTH = 150;
    private static final int LEGEND_HEIGHT = 40;
    private static final String TIME_FORMAT = "%1$tH:%1$tM:%1$tS";
    private static final String DATE_FORMAT = "%1$tY/%1$tm/%1$td";
    private EIT eit;
    private long milliSecsPerPixel = 30000L;
    private Map<ServiceIdentification, EITsection[]> servicesTable = null;
    private SortedSet<ServiceIdentification> serviceOrder = null;
    private Interval interval;
    private boolean selectedSchedule = true;
    private int translatedX = 0;
    private int translatedY = 0;

    public EITableImage(EIT eit, Map<ServiceIdentification, EITsection[]> table) {
        this.eit = eit;
        this.servicesTable = table;
        this.serviceOrder = new TreeSet<ServiceIdentification>(table.keySet());
        this.interval = EIT.getSpanningInterval(this.serviceOrder, table);
        this.milliSecsPerPixel = 30000L;
    }

    public EITableImage(TransportStream stream) {
        this.addComponentListener(this);
        this.milliSecsPerPixel = 15000L;
        this.setTransportStream(stream);
        this.setToolTipText("");
        this.revalidate();
    }

    public final void setTransportStream(TransportStream stream) {
        if (stream != null) {
            this.eit = stream.getPsi().getEit();
            this.servicesTable = this.selectedSchedule ? this.eit.getCombinedSchedule() : this.eit.getCombinedPresentFollowing();
            this.serviceOrder = new TreeSet<ServiceIdentification>(this.servicesTable.keySet());
            this.interval = EIT.getSpanningInterval(this.serviceOrder, this.servicesTable);
        } else {
            this.eit = null;
            this.interval = null;
        }
        this.setSize(this.getDimension());
        this.repaint();
    }

    @Override
    public BufferedImage getImage() {
        if (this.interval == null) {
            return null;
        }
        LocalDateTime startDate = Utils.roundHourDown(this.interval.start());
        LocalDateTime endDate = Utils.roundHourUp(this.interval.end());
        int height = this.serviceOrder.size() * 20 + 1 + 40;
        int legendWidth = (int)(startDate.until(endDate, ChronoUnit.SECONDS) * 1000L / this.milliSecsPerPixel);
        int width = 151 + legendWidth;
        long size = (long)width * (long)height;
        if (size > Integer.MAX_VALUE) {
            return GuiUtils.getErrorImage("The combination of number of services and time interval\nis too large to display.");
        }
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D gd = img.createGraphics();
        gd.setColor(Color.BLUE);
        gd.fillRect(0, 0, width, height);
        gd.setColor(Color.WHITE);
        Font font = new Font(FONT_NAME, 0, 14);
        Font nameFont = new Font(FONT_NAME, 1, 14);
        gd.setFont(font);
        BasicStroke basicStroke = new BasicStroke(3.0f);
        gd.setStroke(basicStroke);
        this.drawLegend(gd, startDate, endDate, 150, 0, 40);
        this.drawActualTime(gd, startDate, 150, 0, 40);
        BasicStroke basicStroke1 = new BasicStroke(1.0f);
        gd.setStroke(basicStroke1);
        int offset = 40;
        int char_descend = 16;
        this.drawLabels(gd, this.serviceOrder, nameFont, 0, offset, char_descend);
        gd.setFont(font);
        for (ServiceIdentification serviceNo : this.serviceOrder) {
            EITsection[] eiTsections = this.servicesTable.get(serviceNo);
            this.drawServiceEvents(gd, startDate, 150, offset, char_descend, eiTsections);
            offset += 20;
        }
        return img;
    }

    private void drawServiceEvents(Graphics2D gd, LocalDateTime startDate, int x, int y, int char_descend, EITsection[] eiTsections) {
        for (EITsection section : eiTsections) {
            if (section == null) continue;
            List<EITsection.Event> eventList = section.getEventList();
            for (EITsection.Event event : eventList) {
                this.drawEvent(gd, startDate, event, x, y, char_descend);
            }
        }
    }

    private void drawEvent(Graphics2D gd, LocalDateTime startDate, EITsection.Event event, int x, int y, int char_descend) {
        byte[] startTime = event.getStartTime();
        if (Utils.isUndefined(startTime)) {
            return;
        }
        LocalDateTime eventStart = Utils.getUTCLocalDateTime(startTime);
        try {
            int w = (int)(Utils.getDurationSeconds(event.getDuration()) * 1000L / this.milliSecsPerPixel);
            int eventX = x + (int)(startDate.until(eventStart, ChronoUnit.MILLIS) / this.milliSecsPerPixel);
            String eventName = event.getEventName();
            gd.setColor(Color.GRAY);
            gd.fillRect(eventX, y, w, 20);
            gd.setColor(Color.BLACK);
            gd.drawRect(eventX, y, w, 20);
            Graphics2D gd2 = (Graphics2D)gd.create();
            gd2.clipRect(eventX + 5, y, w - 10, 20);
            gd2.setColor(Color.WHITE);
            gd2.drawString(eventName, eventX + 5, y + char_descend);
            gd2.dispose();
        }
        catch (NumberFormatException nfe) {
            logger.log(Level.WARNING, "drawEvent: Event.duration is not a valid BCD number;", nfe);
        }
    }

    private void drawLabels(Graphics2D gd, SortedSet<ServiceIdentification> serviceSet, Font nameFont, int x, int y, int char_descend) {
        int labelY = y;
        gd.setFont(nameFont);
        for (ServiceIdentification serviceNo : serviceSet) {
            String serviceName = this.eit.getParentPSI().getSdt().getServiceNameDVBString(serviceNo).map(DVBString::toString).orElse("Service " + serviceNo.serviceId());
            gd.setColor(Color.BLUE);
            gd.fillRect(x, labelY, 150, 20);
            gd.setColor(Color.WHITE);
            Graphics2D gd2 = (Graphics2D)gd.create();
            gd2.clipRect(x, labelY, 140, 20);
            gd2.drawString(serviceName, x + 5, labelY + char_descend);
            gd2.dispose();
            labelY += 20;
        }
    }

    private void drawActualTime(Graphics2D gd, LocalDateTime startDate, int x, int y, int legendHeight) {
        TDTsection first;
        LocalDateTime sectionStart;
        List<TDTsection> tdtSectionList;
        if (this.eit.getParentPSI().getTdt() != null && !(tdtSectionList = this.eit.getParentPSI().getTdt().getTdtSectionList()).isEmpty() && (sectionStart = Utils.getUTCLocalDateTime((first = tdtSectionList.getFirst()).getUTC_time())) != null) {
            gd.setColor(Color.RED);
            int labelX = x + (int)(startDate.until(sectionStart, ChronoUnit.SECONDS) * 1000L / this.milliSecsPerPixel);
            gd.drawLine(labelX, y, labelX, y + legendHeight - 1);
        }
    }

    private void drawLegend(Graphics2D gd, LocalDateTime startDate, LocalDateTime endDate, int x, int y, int legendHeight) {
        gd.setColor(Color.BLACK);
        int w = (int)(startDate.until(endDate, ChronoUnit.SECONDS) * 1000L / this.milliSecsPerPixel);
        gd.fillRect(x, y, w, legendHeight);
        gd.setColor(Color.WHITE);
        LocalDateTime hourMark = startDate;
        while (hourMark.isBefore(endDate)) {
            int labelX = x + (int)(startDate.until(hourMark, ChronoUnit.SECONDS) * 1000L / this.milliSecsPerPixel);
            gd.drawLine(labelX, y, labelX, legendHeight - 1 + y);
            String timeString = String.format(TIME_FORMAT, hourMark);
            String dateString = String.format(DATE_FORMAT, hourMark);
            gd.drawString(dateString, labelX + 5, y + 17);
            gd.drawString(timeString, labelX + 5, y + 37);
            hourMark = hourMark.plusHours(1L);
        }
    }

    public final Dimension getDimension() {
        if (this.eit != null && this.interval != null) {
            LocalDateTime startDate = Utils.roundHourDown(this.interval.start());
            LocalDateTime endDate = Utils.roundHourUp(this.interval.end());
            int legendHeight = 40;
            int height = this.serviceOrder.size() * 20 + 1 + legendHeight;
            int width = 151 + (int)(startDate.until(endDate, ChronoUnit.SECONDS) * 1000L / this.milliSecsPerPixel);
            return new Dimension(width, height);
        }
        return new Dimension(0, 0);
    }

    public void setMilliSecsPerPixel(long milliSecsPerPixel) {
        this.milliSecsPerPixel = milliSecsPerPixel;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        StringBuilder r1 = new StringBuilder();
        if (this.eit != null && this.interval != null) {
            int row;
            int x = e.getX();
            int y = e.getY();
            if (y > this.translatedY + 40 && (row = (y - 40) / 20) < this.serviceOrder.size()) {
                r1.append("<html><b>");
                ServiceIdentification serviceIdent = this.serviceOrder.toArray(new ServiceIdentification[0])[row];
                if (x > this.translatedX + 150) {
                    String name = this.eit.getParentPSI().getSdt().getServiceNameDVBString(serviceIdent).map(DVBString::toEscapedHTML).orElse("Service " + serviceIdent.serviceId());
                    r1.append(name).append("</b><br><br>");
                    LocalDateTime thisDate = Utils.roundHourDown(this.interval.start()).plusSeconds(this.milliSecsPerPixel * (long)(x - 150) / 1000L);
                    EITsection.Event event = this.findEvent(serviceIdent, thisDate);
                    if (event != null) {
                        r1.append(event.getHTML());
                    } else {
                        String timeString = String.format(TIME_FORMAT, thisDate);
                        String dateString = String.format(DATE_FORMAT, thisDate);
                        r1.append(dateString).append("&nbsp;").append(timeString);
                    }
                } else {
                    String name = this.eit.getParentPSI().getSdt().getServiceNameDVBString(serviceIdent).map(DVBString::toEscapedHTML).orElse("[Name not in SDT]<br><br>");
                    r1.append(name).append("</b><br><br>original_network_id:").append(serviceIdent.originalNetworkId()).append("<br>transport_stream_id:").append(serviceIdent.transportStreamId()).append("<br>service_id:").append(serviceIdent.serviceId());
                }
                r1.append("</html>");
            }
        }
        return r1.toString();
    }

    private EITsection.Event findEvent(ServiceIdentification serviceID, LocalDateTime date) {
        EITsection[] list;
        for (EITsection section : list = this.servicesTable.get(serviceID)) {
            if (section == null) continue;
            List<EITsection.Event> eventList = section.getEventList();
            for (EITsection.Event event : eventList) {
                LocalDateTime eventEnd;
                LocalDateTime eventStart;
                byte[] startTime = event.getStartTime();
                if (Utils.isUndefined(startTime) || !date.isAfter(eventStart = Utils.getUTCLocalDateTime(startTime)) && !date.equals(eventStart) || !(eventEnd = eventStart.plusSeconds(Utils.getDurationSeconds(event.getDuration()))).isAfter(date)) continue;
                return event;
            }
        }
        return null;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.repaint();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        this.setBackground(Color.BLUE);
        super.paintComponent(g);
        Graphics2D gd = (Graphics2D)g;
        gd.setColor(Color.BLACK);
        Rectangle rect = this.getVisibleRect();
        this.translatedX = rect.x;
        this.translatedY = rect.y;
        int viewWidth = rect.width;
        int viewHeight = rect.height;
        if (this.eit != null && this.interval != null) {
            LocalDateTime startDate = Utils.roundHourDown(this.interval.start());
            LocalDateTime endDate = Utils.roundHourUp(this.interval.end());
            gd.setColor(Color.WHITE);
            Font font = new Font(FONT_NAME, 0, 14);
            Font nameFont = new Font(FONT_NAME, 1, 14);
            gd.setFont(font);
            BasicStroke basicStroke = new BasicStroke(3.0f);
            gd.setStroke(basicStroke);
            BasicStroke basicStroke1 = new BasicStroke(1.0f);
            gd.setStroke(basicStroke1);
            int offset = 40;
            int char_descend = 16;
            this.drawLegend(gd, startDate, endDate, 150, this.translatedY, 40);
            this.drawActualTime(gd, startDate, 150, this.translatedY, 40);
            this.drawLabels(gd, this.serviceOrder, nameFont, this.translatedX, offset, char_descend);
            gd.setColor(Color.BLUE);
            gd.fillRect(this.translatedX, this.translatedY, 150, 40);
            Graphics2D gd2 = (Graphics2D)gd.create();
            gd2.setFont(font);
            gd2.clipRect(this.translatedX + 150, this.translatedY + 40, viewWidth - 150, viewHeight - 40);
            SortedSet<ServiceIdentification> order = this.serviceOrder;
            for (ServiceIdentification serviceNo : order) {
                EITsection[] eiTsections = this.servicesTable.get(serviceNo);
                this.drawServiceEvents(gd2, startDate, 150, offset, char_descend, eiTsections);
                offset += 20;
            }
            gd2.dispose();
        } else {
            gd.setColor(Color.WHITE);
            Font nameFont = new Font(FONT_NAME, 1, 14);
            gd.setFont(nameFont);
            gd.drawString("No EIT present (or empty)", 20, 20);
        }
    }

    public void selectPresentFollowing() {
        this.selectedSchedule = false;
        if (this.eit != null) {
            this.servicesTable = this.eit.getCombinedPresentFollowing();
            this.serviceOrder = new TreeSet<ServiceIdentification>(this.servicesTable.keySet());
            this.interval = EIT.getSpanningInterval(this.serviceOrder, this.servicesTable);
            this.setSize(this.getDimension());
            this.repaint();
        }
    }

    public void selectSchedule() {
        this.selectedSchedule = true;
        if (this.eit != null) {
            this.servicesTable = this.eit.getCombinedSchedule();
            this.serviceOrder = new TreeSet<ServiceIdentification>(this.servicesTable.keySet());
            this.interval = EIT.getSpanningInterval(this.serviceOrder, this.servicesTable);
            this.setSize(this.getDimension());
            this.repaint();
        }
    }

    public void setZoom(long l) {
        this.milliSecsPerPixel = l;
        this.setSize(this.getDimension());
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getDimension();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return (int)(3600000L / this.milliSecsPerPixel);
        }
        return 20;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            int w = (int)this.getVisibleRect().getWidth() - 150;
            int pixelsHour = (int)(3600000L / this.milliSecsPerPixel);
            return Math.max(pixelsHour, w - w % pixelsHour);
        }
        int h = (int)this.getVisibleRect().getHeight() - 40;
        return h - h % 20;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.eit == null || this.interval == null;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.eit == null || this.interval == null;
    }
}

