/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import nl.digitalekabeltelevisie.gui.FileDropHandler;
import nl.digitalekabeltelevisie.gui.TextHTMLTransferable;
import nl.digitalekabeltelevisie.main.DVBinspector;
import nl.digitalekabeltelevisie.util.Utils;

public class EditorTextHTMLTransferHandler
extends FileDropHandler {
    public EditorTextHTMLTransferHandler(DVBinspector controller) {
        super(controller);
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        JEditorPane pane = (JEditorPane)c;
        int start = pane.getSelectionStart();
        int end = pane.getSelectionEnd();
        HTMLDocument doc = (HTMLDocument)pane.getDocument();
        StringWriter sw = new StringWriter(end - start);
        try {
            pane.getEditorKit().write(sw, (Document)doc, start, end - start);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String htmlString = sw.toString();
        String plainText = Utils.extractTextFromHTML(htmlString);
        return new TextHTMLTransferable(plainText, htmlString);
    }

    @Override
    public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
        if (action == 1) {
            clip.setContents(this.createTransferable(comp), null);
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }
}

