/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui;

import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import nl.digitalekabeltelevisie.gui.ImageSource;
import nl.digitalekabeltelevisie.gui.ImageTransferable;

public class ImageCopyAction
extends AbstractAction {
    private final JPanel panel;
    private ImageSource imageSource;

    public ImageCopyAction(JPanel panel, String name, ImageSource imageSource) {
        super(name);
        this.panel = panel;
        this.imageSource = imageSource;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.panel.setCursor(Cursor.getPredefinedCursor(3));
        BufferedImage image = this.imageSource.getImage();
        if (image != null) {
            ImageTransferable it = new ImageTransferable(image);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(it, it);
        }
        this.panel.setCursor(Cursor.getDefaultCursor());
    }
}

