/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import nl.digitalekabeltelevisie.gui.ImageCopyAction;
import nl.digitalekabeltelevisie.gui.ImageSaveAction;
import nl.digitalekabeltelevisie.gui.ImageSource;
import nl.digitalekabeltelevisie.gui.utils.WrapLayout;

public class ImagePanel
extends JPanel
implements ImageSource {
    private final JPanel buttonPanel;
    private final ImageCanvas imageCanvas;
    private BufferedImage image;
    private double scale = 1.0;

    public ImagePanel() {
        super(new BorderLayout());
        this.setFocusable(true);
        this.imageCanvas = new ImageCanvas();
        JScrollPane imageScrollPane = new JScrollPane(this.imageCanvas);
        this.buttonPanel = new JPanel(new WrapLayout(0));
        this.addZoomRadioButtons();
        this.buttonPanel.add(Box.createHorizontalStrut(10));
        ImageCopyAction copyAction = new ImageCopyAction(this, "Copy", this);
        JButton copyButton = new JButton(copyAction);
        KeyStroke copyKey = KeyStroke.getKeyStroke(67, 128);
        this.imageCanvas.getInputMap().put(copyKey, "copy");
        this.imageCanvas.getActionMap().put("copy", copyAction);
        this.buttonPanel.add(copyButton);
        ImageSaveAction saveAction = new ImageSaveAction(this, "Save As...", this);
        JButton saveButton = new JButton(saveAction);
        KeyStroke saveKey = KeyStroke.getKeyStroke(83, 128);
        this.getInputMap().put(saveKey, "save");
        this.getActionMap().put("save", saveAction);
        this.buttonPanel.add(saveButton);
        this.add((Component)this.buttonPanel, "First");
        this.add((Component)imageScrollPane, "Center");
    }

    private void addZoomRadioButtons() {
        JLabel typeLabel = new JLabel("Zoom:");
        this.buttonPanel.add(typeLabel);
        JRadioButton zoom1Button = new JRadioButton("\u00bd");
        zoom1Button.addActionListener(e -> this.rescale(0.5));
        JRadioButton zoom2Button = new JRadioButton("1");
        zoom2Button.addActionListener(e -> this.rescale(1.0));
        JRadioButton zoom3Button = new JRadioButton("2x");
        zoom3Button.addActionListener(e -> this.rescale(2.0));
        zoom2Button.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(zoom1Button);
        group.add(zoom2Button);
        group.add(zoom3Button);
        this.buttonPanel.add(zoom1Button);
        this.buttonPanel.add(zoom2Button);
        this.buttonPanel.add(zoom3Button);
    }

    private void rescale(double newScale) {
        this.scale = newScale;
        this.showImage();
    }

    @Override
    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.showImage();
    }

    private void showImage() {
        this.imageCanvas.revalidate();
        this.imageCanvas.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        this.repaint();
    }

    private class ImageCanvas
    extends JPanel
    implements MouseListener,
    FocusListener {
        public ImageCanvas() {
            this.setFocusable(true);
            this.addMouseListener(this);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D gd2 = (Graphics2D)g;
            AffineTransform originalTransform = gd2.getTransform();
            AffineTransform idTransForm = new AffineTransform(ImagePanel.this.scale, 0.0, 0.0, ImagePanel.this.scale, originalTransform.getTranslateX(), originalTransform.getTranslateY());
            gd2.setTransform(idTransForm);
            gd2.drawImage((Image)ImagePanel.this.image, 0, 0, null);
        }

        @Override
        public Dimension getPreferredSize() {
            if (ImagePanel.this.image != null) {
                AffineTransform t = ((Graphics2D)this.getGraphics()).getTransform();
                return new Dimension((int)(ImagePanel.this.scale * (double)ImagePanel.this.image.getWidth() / t.getScaleX() + 1.0), (int)(ImagePanel.this.scale * (double)ImagePanel.this.image.getHeight() / t.getScaleY() + 1.0));
            }
            return new Dimension();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ImagePanel.this.imageCanvas.requestFocusInWindow();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

