/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.NumberFormatter;

public class PacketSelectionPanel
extends JPanel
implements ChangeListener,
PropertyChangeListener {
    private static final long serialVersionUID = -4816053364455328183L;
    private JFormattedTextField textField;
    private JSlider slider;
    private BoundedRangeModel boundedRangeModel;
    private NumberFormat numberFormat;

    PacketSelectionPanel(String myTitle, int low, int upper, int value) {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(myTitle), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.numberFormat = NumberFormat.getNumberInstance();
        this.numberFormat.setMaximumFractionDigits(0);
        NumberFormatter formatter = new NumberFormatter(this.numberFormat);
        formatter.setAllowsInvalid(false);
        formatter.setCommitsOnValidEdit(true);
        this.textField = new JFormattedTextField(formatter);
        this.textField.setColumns(10);
        this.textField.setValue(value);
        this.textField.addPropertyChangeListener(this);
        this.boundedRangeModel = new DefaultBoundedRangeModel(value, 0, low, upper);
        this.slider = new JSlider(this.boundedRangeModel);
        this.boundedRangeModel.addChangeListener(this);
        JPanel unitGroup = new JPanel(){
            private static final long serialVersionUID = 5163968821838752192L;

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        unitGroup.setLayout(new BoxLayout(unitGroup, 3));
        unitGroup.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        unitGroup.add(this.textField);
        unitGroup.add(this.slider);
        JPanel timePanel = new JPanel();
        timePanel.setLayout(new BoxLayout(timePanel, 3));
        this.setLayout(new BoxLayout(this, 2));
        this.setLayout(new BorderLayout());
        this.add((Component)unitGroup, "Center");
        this.add((Component)timePanel, "East");
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        NumberFormatter formatter = (NumberFormatter)this.textField.getFormatter();
        int min = this.boundedRangeModel.getMinimum();
        int max = this.boundedRangeModel.getMaximum();
        int val = this.boundedRangeModel.getValue();
        formatter.setMinimum(Integer.valueOf(min));
        formatter.setMaximum(Integer.valueOf(max));
        this.textField.setValue(val);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("value".equals(e.getPropertyName())) {
            Number value = (Number)e.getNewValue();
            this.boundedRangeModel.setValue(value.intValue());
        }
    }

    public void setRangeValue(int min, int max, int val) {
        this.slider.setMinimum(min);
        this.slider.setMaximum(max);
        this.slider.setValue(val);
        this.textField.setValue(val);
    }

    public int getValue() {
        return this.boundedRangeModel.getValue();
    }
}

