/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui;

import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import nl.digitalekabeltelevisie.data.mpeg.TransportStream;
import nl.digitalekabeltelevisie.gui.exception.NotAnMPEGFileException;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.main.DVBinspector;
import nl.digitalekabeltelevisie.util.PreferencesManager;

public class TSLoader
extends SwingWorker<TransportStream, Void> {
    private static final Logger logger = Logger.getLogger(TSLoader.class.getName());
    private final DVBinspector control;
    private final File file;

    public TSLoader(File file, DVBinspector controller) {
        this.file = file;
        this.control = controller;
        this.control.setTransportStream(null);
        this.control.getFrame().repaint();
    }

    @Override
    protected void done() {
        try {
            TransportStream ts = (TransportStream)this.get();
            if (ts != null) {
                this.control.setTransportStream(ts);
                this.control.resetSearch();
                PreferencesManager.setLastUsedDir(this.file.getParent());
                this.control.addRecentFile(this.file.getCanonicalPath());
                this.control.getTreeView().showRoot();
            }
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Error displaying stream", t);
            String msg = "Ooops. \n\nWhile displaying your stream an error occured from which DVB Inspector can not recover.\n\nError message: " + t.toString();
            this.showMessage(msg);
        }
        finally {
            this.control.getFrame().setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    protected TransportStream doInBackground() {
        TransportStream transportStream = null;
        try {
            transportStream = new TransportStream(this.file);
            transportStream.parseStream(this.control.getFrame());
        }
        catch (NotAnMPEGFileException e) {
            try {
                this.control.removeRecentFile(this.file.getCanonicalPath());
            }
            catch (IOException ioException) {
                logger.log(Level.INFO, "Removing file from recent files failed; ", ioException);
            }
            String msg = e.getMessage();
            logger.log(Level.WARNING, "could not determine packet size stream", e);
            this.showMessage(msg);
        }
        catch (InterruptedIOException t) {
            logger.log(Level.INFO, "Interrupted while loading stream", t);
            String msg = "Loading file was interrupted.\n\nDVB Inspector will show only part of stream.";
            this.showMessage("Loading file was interrupted.\n\nDVB Inspector will show only part of stream.");
            if (transportStream != null) {
                transportStream.postProcess();
            }
        }
        catch (Throwable t) {
            transportStream = null;
            logger.log(Level.WARNING, "error parsing transport stream", t);
            String improveMsg = GuiUtils.getImproveMsg();
            String msg = "Ooops. \n\nWhile parsing your stream an error occured from which DVB Inspector can not recover.\n\nError message: " + t.toString() + "\n\n" + improveMsg;
            this.showMessage(msg);
        }
        this.control.getFrame().setCursor(Cursor.getDefaultCursor());
        return transportStream;
    }

    public void showMessage(String msg) {
        this.control.getFrame().setCursor(Cursor.getDefaultCursor());
        JOptionPane.showMessageDialog(this.control.getFrame(), msg, "Error DVB Inspector", 0);
    }
}

