/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import nl.digitalekabeltelevisie.gui.TablePanel;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.PreferencesManager;

public class TableSaveAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(TableSaveAction.class.getName());
    private static final String TEXT = "TEXT";
    private static final String HTML = "HTML";
    private static final String CSV = "CSV";
    final TablePanel tablePanel;

    public TableSaveAction(TablePanel tablePanel, String label) {
        super(label);
        this.tablePanel = tablePanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = GuiUtils.createFileChooser(List.of(new FileNameExtensionFilter(HTML, "html", "htm"), new FileNameExtensionFilter(TEXT, "txt", "text"), new FileNameExtensionFilter(CSV, "csv")));
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        File saveFile = new File("dvb_inspector_table_" + df.format(new Date()));
        chooser.setSelectedFile(saveFile);
        int rval = chooser.showSaveDialog(this.tablePanel);
        if (rval == 0) {
            int n;
            saveFile = chooser.getSelectedFile();
            PreferencesManager.setSaveDir(saveFile.getParent());
            FileNameExtensionFilter filter = (FileNameExtensionFilter)chooser.getFileFilter();
            String extension = filter.getExtensions()[0];
            if (!saveFile.getName().endsWith("." + extension)) {
                saveFile = new File(saveFile.getPath() + "." + extension);
            }
            boolean write = true;
            if (saveFile.exists() && (n = JOptionPane.showConfirmDialog(this.tablePanel, "File " + String.valueOf(saveFile) + " already exists, want to overwrite?", "File already exists", 0)) == 1) {
                write = false;
            }
            if (write) {
                String content = switch (filter.getDescription()) {
                    case HTML -> this.tablePanel.getTableAsHtml();
                    case CSV -> this.tablePanel.getTableAsCsv();
                    default -> this.tablePanel.getTableAsText();
                };
                try {
                    Files.writeString(saveFile.toPath(), (CharSequence)content, new OpenOption[0]);
                }
                catch (IOException e1) {
                    logger.warning(() -> "IOException while saving table; " + String.valueOf(e1));
                }
            }
        }
    }
}

