/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import nl.digitalekabeltelevisie.util.PreferencesManager;

public final class RecentFiles {
    private List<String> recentFiles = new ArrayList<String>();
    private static final int MAX_ENTRIES = 10;

    public static RecentFiles getInstance() {
        return InstanceHolder.instance;
    }

    private RecentFiles() {
        this.init(PreferencesManager.getRecentFiles());
    }

    private void init(String allFiles) {
        this.recentFiles.clear();
        if (!allFiles.isEmpty()) {
            this.recentFiles.addAll(Arrays.asList(allFiles.split(File.pathSeparator)));
        }
        if (this.recentFiles.size() > 10) {
            this.recentFiles = this.recentFiles.subList(0, 10);
        }
    }

    private String getString() {
        return this.recentFiles.stream().collect(Collectors.joining(File.pathSeparator));
    }

    public void addOrMoveToBegin(String fileName) {
        this.recentFiles.remove(fileName);
        this.recentFiles.addFirst(fileName);
        if (this.recentFiles.size() > 10) {
            this.recentFiles = this.recentFiles.subList(0, 10);
        }
        PreferencesManager.setRecentFiles(this.getString());
    }

    public void reset() {
        this.recentFiles = new ArrayList<String>();
        PreferencesManager.setRecentFiles(this.getString());
    }

    public int getNumberOfEntries() {
        return this.recentFiles.size();
    }

    public boolean remove(String fileName) {
        boolean result = this.recentFiles.remove(fileName);
        PreferencesManager.setRecentFiles(this.getString());
        return result;
    }

    public List<String> getRecentFiles() {
        return this.recentFiles;
    }

    private static final class InstanceHolder {
        private static final RecentFiles instance = new RecentFiles();

        private InstanceHolder() {
        }
    }
}

