/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui.utils;

import java.text.NumberFormat;
import nl.digitalekabeltelevisie.data.mpeg.TemiTimeStamp;
import nl.digitalekabeltelevisie.gui.utils.TEMIXYDataset;
import nl.digitalekabeltelevisie.util.Utils;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.xy.XYDataset;

public class TEMIToolTipGenerator
implements XYToolTipGenerator {
    private final NumberFormat timeFormat;

    public TEMIToolTipGenerator(NumberFormat timeFormat) {
        this.timeFormat = timeFormat;
    }

    @Override
    public String generateToolTip(XYDataset dataset, int series, int item) {
        TEMIXYDataset temiDataSet = (TEMIXYDataset)dataset;
        String label = temiDataSet.getSeriesKey(series);
        TemiTimeStamp timeStamp = temiDataSet.getTimestamp(series, item);
        StringBuilder stringBuilder = new StringBuilder("<html>").append(label).append("<br>");
        stringBuilder.append("Packet No: ").append(timeStamp.getPacketNo()).append("<br>");
        stringBuilder.append("PTS: ").append(Utils.printTimebase90kHz(timeStamp.getPts())).append("<br>");
        stringBuilder.append("Time: ").append(this.timeFormat.format(timeStamp.getTime())).append("<br>");
        stringBuilder.append("media_timestamp: ").append(timeStamp.getMediaTimeStamp()).append("<br>");
        stringBuilder.append("time_scale: ").append(timeStamp.getTimescale()).append("<br>");
        stringBuilder.append("paused: ").append(timeStamp.getPaused()).append("<br>");
        stringBuilder.append("discontinuity:").append(timeStamp.getDiscontinuity()).append("<br>");
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }
}

