/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nl.digitalekabeltelevisie.controller.ViewContext;
import nl.digitalekabeltelevisie.data.mpeg.PCR;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.TemiTimeStamp;
import nl.digitalekabeltelevisie.data.mpeg.TransportStream;
import nl.digitalekabeltelevisie.data.mpeg.psi.PMTsection;
import org.jfree.data.DomainOrder;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.data.xy.XYDataset;

public class TEMIXYDataset
implements XYDataset {
    private DatasetGroup group;
    private final List<List<TemiTimeStamp>> seriesList = new ArrayList<List<TemiTimeStamp>>();
    private final List<String> seriesKeys = new ArrayList<String>();
    private long firstPcrPacketNo;
    private long pcrBase;
    private long packetsPerSec;

    public TEMIXYDataset(PMTsection pmt, TransportStream transportStream, ViewContext viewContext) {
        long bitRate = transportStream.getBitRate();
        int packetInBits = transportStream.getPacketLenghth() * 8;
        this.packetsPerSec = bitRate / (long)packetInBits;
        PID pcrPid = transportStream.getPID(pmt.getPcrPid());
        PCR firstPCR = pcrPid.getFirstPCR();
        this.firstPcrPacketNo = pcrPid.getFirstPCRpacketNo();
        this.pcrBase = firstPCR.getProgram_clock_reference_base();
        for (PMTsection.Component c : pmt.getComponentenList()) {
            short componentPid = (short)c.getElementaryPID();
            String componentLabel = componentPid + " - " + transportStream.getShortLabel(componentPid);
            PID pid = transportStream.getPID(componentPid);
            if (pid == null) continue;
            Map<Integer, ArrayList<TemiTimeStamp>> temiMap = pid.getTemiMap();
            for (Map.Entry<Integer, ArrayList<TemiTimeStamp>> entry : temiMap.entrySet()) {
                int time_line_id = entry.getKey();
                List value = entry.getValue();
                this.addToSeriesList(value, componentLabel + " TEMI time_line_id:" + time_line_id);
            }
        }
    }

    private void addToSeriesList(List<TemiTimeStamp> list, String componentLabel) {
        if (list != null && !list.isEmpty()) {
            this.seriesList.add(list);
            this.seriesKeys.add(componentLabel);
        }
    }

    @Override
    public int getSeriesCount() {
        return this.seriesList.size();
    }

    public String getSeriesKey(int series) {
        return this.seriesKeys.get(series);
    }

    @Override
    public int indexOf(Comparable seriesKey) {
        return this.seriesKeys.indexOf(seriesKey);
    }

    @Override
    public void addChangeListener(DatasetChangeListener listener) {
    }

    @Override
    public void removeChangeListener(DatasetChangeListener listener) {
    }

    @Override
    public DatasetGroup getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(DatasetGroup group) {
        this.group = group;
    }

    @Override
    public DomainOrder getDomainOrder() {
        return DomainOrder.ASCENDING;
    }

    @Override
    public int getItemCount(int series) {
        return this.seriesList.get(series).size();
    }

    @Override
    public Number getX(int series, int item) {
        return this.calcPacketNoFromPts(series, item);
    }

    private long calcPacketNoFromPts(int series, int item) {
        TemiTimeStamp temiTimeStamp = this.seriesList.get(series).get(item);
        long pts = temiTimeStamp.getPts();
        long delta = pts - this.pcrBase;
        if (pts < this.pcrBase) {
            delta = 0x200000000L + pts - this.pcrBase;
        }
        return this.firstPcrPacketNo + this.packetsPerSec * delta / 90000L;
    }

    protected TemiTimeStamp getTimestamp(int series, int item) {
        return this.seriesList.get(series).get(item);
    }

    @Override
    public double getXValue(int series, int item) {
        return this.calcPacketNoFromPts(series, item);
    }

    @Override
    public Number getY(int series, int item) {
        return this.seriesList.get(series).get(item).getTime();
    }

    @Override
    public double getYValue(int series, int item) {
        return this.seriesList.get(series).get(item).getTime();
    }
}

