/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui.xmleditorkit;

import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import nl.digitalekabeltelevisie.gui.xmleditorkit.TagView;
import nl.digitalekabeltelevisie.gui.xmleditorkit.XMLDocument;
import nl.digitalekabeltelevisie.gui.xmleditorkit.XMLReader;
import nl.digitalekabeltelevisie.gui.xmleditorkit.XMLViewFactory;

public class XMLEditorKit
extends StyledEditorKit {
    ViewFactory defaultFactory = new XMLViewFactory();
    MouseListener lstCollapse = new MouseAdapter(this){

        @Override
        public void mouseClicked(MouseEvent e) {
            Shape a;
            int i;
            View v;
            JEditorPane src = (JEditorPane)e.getSource();
            int pos = src.viewToModel(e.getPoint());
            for (v = src.getUI().getRootView(src); v != null && !(v instanceof TagView); v = v.getView(i)) {
                i = v.getViewIndex(pos, Position.Bias.Forward);
            }
            TagView deepest = (TagView)v;
            while (v != null && v instanceof TagView) {
                deepest = (TagView)v;
                int i2 = v.getViewIndex(pos, Position.Bias.Forward);
                v = v.getView(i2);
            }
            if (deepest != null && (a = XMLEditorKit.getAllocation(deepest, src)) != null) {
                Rectangle r = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
                r.y += 5;
                r.width = 10;
                r.height = 10;
                if (r.contains(e.getPoint())) {
                    deepest.setExpanded(!deepest.isExpanded());
                    XMLDocument doc = (XMLDocument)src.getDocument();
                    try {
                        doc.setUserChanges(false);
                        doc.insertString(++pos, "\n", new SimpleAttributeSet());
                        doc.remove(pos, 1);
                        doc.setUserChanges(true);
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    };
    Cursor oldCursor;
    MouseMotionListener lstMoveCollapse = new MouseMotionAdapter(){

        @Override
        public void mouseMoved(MouseEvent e) {
            Shape a;
            int i;
            View v;
            JEditorPane src = (JEditorPane)e.getSource();
            if (XMLEditorKit.this.oldCursor == null) {
                XMLEditorKit.this.oldCursor = src.getCursor();
            }
            int pos = src.viewToModel(e.getPoint());
            for (v = src.getUI().getRootView(src); v != null && !(v instanceof TagView); v = v.getView(i)) {
                i = v.getViewIndex(pos, Position.Bias.Forward);
            }
            TagView deepest = (TagView)v;
            while (v != null && v instanceof TagView) {
                deepest = (TagView)v;
                int i2 = v.getViewIndex(pos, Position.Bias.Forward);
                v = v.getView(i2);
            }
            if (deepest != null && (a = XMLEditorKit.getAllocation(deepest, src)) != null) {
                Rectangle r = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
                r.y += 5;
                r.width = 10;
                r.height = 10;
                if (r.contains(e.getPoint())) {
                    src.setCursor(Cursor.getPredefinedCursor(12));
                    return;
                }
            }
            src.setCursor(XMLEditorKit.this.oldCursor);
        }
    };

    @Override
    public ViewFactory getViewFactory() {
        return this.defaultFactory;
    }

    @Override
    public Document createDefaultDocument() {
        return new XMLDocument();
    }

    @Override
    public String getContentType() {
        return "text/xml";
    }

    @Override
    public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
        BufferedReader br = new BufferedReader(in);
        String s = br.readLine();
        StringBuffer buff = new StringBuffer();
        while (s != null) {
            buff.append(s);
            s = br.readLine();
        }
        int p = this.getInsertPosition(pos, doc);
        XMLReader.getInstance().read(new ByteArrayInputStream(buff.toString().getBytes()), doc, p);
    }

    @Override
    public void read(InputStream in, Document doc, int pos) throws IOException, BadLocationException {
        int p = this.getInsertPosition(pos, doc);
        XMLReader.getInstance().read(in, doc, p);
    }

    @Override
    public void write(OutputStream out, Document doc, int pos, int len) throws IOException, BadLocationException {
        int[] sel = new int[]{pos, pos + len};
        XMLEditorKit.correctSelectionBounds(sel, doc);
        pos = sel[0];
        len = sel[1] - pos;
        super.write(out, doc, pos, len);
    }

    @Override
    public void write(Writer out, Document doc, int pos, int len) throws IOException, BadLocationException {
        int[] sel = new int[]{pos, pos + len};
        XMLEditorKit.correctSelectionBounds(sel, doc);
        pos = sel[0];
        len = sel[1] - pos;
        super.write(out, doc, pos, len);
    }

    public static void correctSelectionBounds(int[] selection, Document d) {
        if (d instanceof XMLDocument && d.getLength() > 0) {
            Element commonParent;
            XMLDocument doc = (XMLDocument)d;
            int start = selection[0];
            Element root = doc.getDefaultRootElement();
            int i = root.getElementIndex(start);
            while (i >= 0 && root.getElement(i).getName().equals(XMLDocument.TAG_ELEMENT)) {
                root = root.getElement(i);
                i = root.getElementIndex(start);
            }
            Element startTag = root;
            int end = selection[0];
            root = doc.getDefaultRootElement();
            i = root.getElementIndex(end);
            while (i >= 0 && root.getElement(i).getName().equals(XMLDocument.TAG_ELEMENT)) {
                root = root.getElement(i);
                i = root.getElementIndex(end);
            }
            Element endTag = root;
            for (commonParent = startTag; commonParent != null && (commonParent.getStartOffset() > endTag.getStartOffset() || commonParent.getEndOffset() < endTag.getEndOffset()); commonParent = commonParent.getParentElement()) {
            }
            if (commonParent != null) {
                selection[0] = commonParent.getStartOffset();
                selection[1] = commonParent.getEndOffset();
            }
        }
    }

    protected int getInsertPosition(int pos, Document d) {
        if (d instanceof XMLDocument && d.getLength() > 0) {
            XMLDocument doc = (XMLDocument)d;
            Element root = doc.getDefaultRootElement();
            int i = root.getElementIndex(pos);
            while (i >= 0 && root.getElement(i).getName().equals(XMLDocument.TAG_ELEMENT)) {
                root = root.getElement(i);
                i = root.getElementIndex(pos);
            }
            while (root.getElementCount() < 3) {
                root = root.getParentElement();
            }
            return root.getElement(0).getEndOffset();
        }
        return pos;
    }

    @Override
    public void install(JEditorPane c) {
        super.install(c);
        c.addMouseListener(this.lstCollapse);
        c.addMouseMotionListener(this.lstMoveCollapse);
    }

    @Override
    public void deinstall(JEditorPane c) {
        c.removeMouseListener(this.lstCollapse);
        c.removeMouseMotionListener(this.lstMoveCollapse);
        super.deinstall(c);
    }

    protected static Shape getAllocation(View v, JEditorPane edit) {
        Insets ins = edit.getInsets();
        int x = ins.left;
        int y = ins.top;
        for (View vParent = v.getParent(); vParent != null; vParent = vParent.getParent()) {
            int i = vParent.getViewIndex(v.getStartOffset(), Position.Bias.Forward);
            Shape alloc = vParent.getChildAllocation(i, new Rectangle(0, 0, Short.MAX_VALUE, Short.MAX_VALUE));
            x += alloc.getBounds().x;
            y += alloc.getBounds().y;
        }
        if (v instanceof BoxView) {
            int ind = v.getParent().getViewIndex(v.getStartOffset(), Position.Bias.Forward);
            Rectangle r2 = v.getParent().getChildAllocation(ind, new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE)).getBounds();
            return new Rectangle(x, y, r2.width, r2.height);
        }
        return new Rectangle(x, y, (int)v.getPreferredSpan(0), (int)v.getPreferredSpan(1));
    }

    @Override
    public Action[] getActions() {
        Action[] res = super.getActions();
        for (int i = 0; i < res.length; ++i) {
            if (!(res[i] instanceof DefaultEditorKit.CopyAction)) continue;
            res[i] = new XMLCopyAction();
        }
        return res;
    }

    public class XMLCopyAction
    extends TextAction {
        public XMLCopyAction() {
            super("copy-to-clipboard");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null) {
                int end;
                int start = target.getSelectionStart();
                if (start != (end = target.getSelectionEnd())) {
                    int[] sel = new int[]{start, end};
                    XMLEditorKit.correctSelectionBounds(sel, target.getDocument());
                    target.setSelectionStart(sel[0]);
                    target.setSelectionEnd(sel[1]);
                }
                target.copy();
            }
        }
    }
}

