/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.util;

import java.nio.BufferUnderflowException;

public class BitString {
    private final StringBuilder bits;

    public int getNoBits() {
        return this.bits.length();
    }

    public BitString(String data) {
        if (data == null) {
            throw new NullPointerException();
        }
        if (!data.matches("[01]*")) {
            throw new IllegalArgumentException("use only '0' and '1' for data.");
        }
        this.bits = new StringBuilder(data);
    }

    public BitString(byte[] data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.bits = new StringBuilder();
        for (int n : data) {
            int t = n;
            if (t < 0) {
                t += 256;
            }
            this.addIntBits(t, 8);
        }
    }

    public BitString() {
        this.bits = new StringBuilder();
    }

    public final void addIntBits(int data, int numberOfbits) {
        StringBuilder t = new StringBuilder(Integer.toString(data, 2));
        if (t.length() > numberOfbits) {
            throw new IllegalArgumentException("data " + data + " does not fit in " + numberOfbits + " bits");
        }
        int s = numberOfbits - t.length();
        this.bits.append("0".repeat(Math.max(0, s)));
        this.bits.append((CharSequence)t);
    }

    public void addIntBitsReverse(int data, int numberOfbits) {
        StringBuilder t = new StringBuilder(Integer.toString(data, 2));
        if (t.length() > numberOfbits) {
            throw new IllegalArgumentException("data " + data + " does not fit in " + numberOfbits + " bits");
        }
        int s = numberOfbits - t.length();
        this.bits.append((CharSequence)t.reverse());
        this.bits.append("0".repeat(Math.max(0, s)));
    }

    public int getIntBits(int numberOfBits) {
        this.checkLength(numberOfBits);
        int result = Integer.parseInt(this.bits.substring(0, numberOfBits), 2);
        this.bits.delete(0, numberOfBits);
        return result;
    }

    public int getIntBitsReverse(int numberOfBits) {
        this.checkLength(numberOfBits);
        StringBuilder t = new StringBuilder(this.bits.substring(0, numberOfBits));
        int result = Integer.parseInt(t.reverse().toString(), 2);
        this.bits.delete(0, numberOfBits);
        return result;
    }

    private void checkLength(int numberOfBits) {
        if (numberOfBits > this.bits.length()) {
            throw new BufferUnderflowException();
        }
        if (numberOfBits > 32) {
            throw new IllegalArgumentException("int can contain only 32 bits.");
        }
        if (numberOfBits < 0) {
            throw new IllegalArgumentException("negative number of bits " + numberOfBits);
        }
    }

    public String toString() {
        return this.bits.toString();
    }

    public int getIntBitsEnd(int numberOfBits) {
        this.checkLength(numberOfBits);
        int totalBits = this.bits.length();
        int result = Integer.parseInt(this.bits.substring(totalBits - numberOfBits, totalBits), 2);
        this.bits.delete(totalBits - numberOfBits, totalBits);
        return result;
    }
}

