/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import nl.digitalekabeltelevisie.util.LazyListItemGetter;

public class JTreeLazyList {
    private static final int STEP_SIZE = 100;
    private RangeNode mutableTreeNode = null;
    LazyListItemGetter itemGetter = null;

    public JTreeLazyList(LazyListItemGetter itemGetter) {
        this.itemGetter = itemGetter;
    }

    public RangeNode getJTreeNode(int modus, String label) {
        if (this.mutableTreeNode == null) {
            int level = JTreeLazyList.determineLevel(this.itemGetter.getNoItems());
            this.mutableTreeNode = new RangeNode(level, 0, this.itemGetter.getNoItems(), label);
        }
        return this.mutableTreeNode;
    }

    private static int determineLevel(int noPackets2) {
        int level = 0;
        int upperBound = 100;
        while (upperBound < noPackets2) {
            upperBound *= 100;
            ++level;
        }
        return level;
    }

    static int ipower(int base, int exponent) {
        int result = 1;
        for (int exp = exponent; exp > 0; --exp) {
            result *= base;
        }
        return result;
    }

    public static int divideRoundUp(int num, int divisor) {
        return (num + divisor - 1) / divisor;
    }

    public class RangeNode
    implements MutableTreeNode {
        final int level;
        final int start;
        final int end;
        private MutableTreeNode[] children = null;
        private MutableTreeNode parent;
        private String label = "";

        private RangeNode(int level, int start, int end, MutableTreeNode parent) {
            this.level = level;
            this.start = start;
            this.end = end;
            this.parent = parent;
        }

        private RangeNode(int level, int start, int end, String label) {
            this.level = level;
            this.start = start;
            this.end = end;
            this.label = label;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.label).append('[').append(JTreeLazyList.this.itemGetter.getActualNumberForIndex(this.start)).append("..").append(JTreeLazyList.this.itemGetter.getActualNumberForIndex(this.end - 1)).append(']');
            return b.toString();
        }

        private RangeNode createChild(int level, int currentStart, int index) {
            int maxLeafsChild = JTreeLazyList.ipower(100, level);
            int childStart = currentStart + maxLeafsChild * index;
            int childEnd = currentStart + maxLeafsChild * (index + 1);
            childEnd = Math.min(JTreeLazyList.this.itemGetter.getNoItems(), childEnd);
            return new RangeNode(level - 1, childStart, childEnd, this);
        }

        @Override
        public MutableTreeNode getChildAt(int childIndex) {
            if (this.level > 0) {
                RangeNode t = null;
                if (this.children == null) {
                    this.children = new MutableTreeNode[100];
                }
                if ((t = (RangeNode)this.children[childIndex]) == null) {
                    t = this.createChild(this.level, this.start, childIndex);
                    this.children[childIndex] = t;
                }
                return t;
            }
            MutableTreeNode t = null;
            if (this.children == null) {
                this.children = new MutableTreeNode[100];
            }
            if ((t = this.children[childIndex]) == null) {
                t = JTreeLazyList.this.itemGetter.getTreeNode(childIndex + this.start);
                t.setParent(this);
                this.children[childIndex] = t;
            }
            return t;
        }

        @Override
        public int getChildCount() {
            int maxLeafsCurrentNode = JTreeLazyList.ipower(100, this.level + 1);
            if (this.start + maxLeafsCurrentNode <= JTreeLazyList.this.itemGetter.getNoItems()) {
                return 100;
            }
            if (this.level == 0) {
                return this.end - this.start;
            }
            return JTreeLazyList.divideRoundUp(this.end - this.start, JTreeLazyList.ipower(100, this.level));
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public int getIndex(TreeNode node) {
            return 0;
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        public Enumeration<MutableTreeNode> children() {
            int childCount = this.getChildCount();
            for (int t = 0; t < childCount; ++t) {
                this.getChildAt(t);
            }
            return Collections.enumeration(Arrays.asList(this.children));
        }

        @Override
        public void insert(MutableTreeNode child, int index) {
            throw new IllegalStateException("node does not allow children");
        }

        @Override
        public void remove(int index) {
            throw new IllegalStateException("node does not allow remove");
        }

        @Override
        public void remove(MutableTreeNode node) {
            throw new IllegalStateException("node does not allow remove");
        }

        @Override
        public void setUserObject(Object object) {
        }

        @Override
        public void removeFromParent() {
        }

        @Override
        public void setParent(MutableTreeNode newParent) {
            this.parent = newParent;
        }

        public String getLabel() {
            return this.label;
        }

        public MutableTreeNode findChildForActual(int actual) {
            int index = JTreeLazyList.this.itemGetter.getIndexForActualNumber(actual);
            return this.findChildForIndex(index);
        }

        private MutableTreeNode findChildForIndex(int index) {
            if (this.level == 0) {
                return this.getChildAt(index);
            }
            int divisor = JTreeLazyList.ipower(100, this.level);
            MutableTreeNode child = this.getChildAt(Integer.divideUnsigned(index, divisor));
            int newIndex = Integer.remainderUnsigned(index, divisor);
            if (child instanceof RangeNode) {
                RangeNode rangeNode = (RangeNode)child;
                return rangeNode.findChildForIndex(newIndex);
            }
            return null;
        }
    }
}

