/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.util;

import nl.digitalekabeltelevisie.util.RangeHashMap;

public class LookUpList {
    RangeHashMap<Integer, String> table;

    private LookUpList(Builder builder) {
        this.table = builder.getTable();
    }

    public String get(int i) {
        return this.table.find(i);
    }

    public String get(int i, String notFound) {
        String r = this.get(i);
        if (r == null) {
            return notFound;
        }
        return r;
    }

    public static class Builder {
        RangeHashMap<Integer, String> table = new RangeHashMap();

        public Builder() {
        }

        public Builder(String[] init_vals) {
            this();
            for (int i = 0; i < init_vals.length; ++i) {
                this.table.put(i, i, init_vals[i]);
            }
        }

        public Builder add(int i, String s) {
            this.table.put(i, i, s);
            return this;
        }

        public Builder add(int i, int j, String s) {
            this.table.put(i, j, s);
            return this;
        }

        public LookUpList build() {
            return new LookUpList(this);
        }

        public RangeHashMap<Integer, String> getTable() {
            return this.table;
        }
    }
}

