/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.util;

import java.util.Objects;
import nl.digitalekabeltelevisie.util.RangeHashMap;

public class OffsetHelper {
    private RangeHashMap<Integer, Long> rangeHashMap = new RangeHashMap();
    private int maxPackets = -1;
    private int packetLength = 0;
    RangeHashMap.Entry currentEntry = null;

    public OffsetHelper(int max_packets, int packetLength) {
        this.maxPackets = max_packets;
        this.packetLength = packetLength;
    }

    public void addPacket(int packetNo, long offset) {
        if (this.currentEntry == null) {
            RangeHashMap<Integer, Long> rangeHashMap = this.rangeHashMap;
            Objects.requireNonNull(rangeHashMap);
            this.currentEntry = new RangeHashMap.Entry(rangeHashMap, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.maxPackets), (Object)offset);
            this.rangeHashMap.put(0, this.currentEntry);
        } else if (this.calculateOffset(packetNo, this.currentEntry) != offset) {
            this.currentEntry.setUpper(packetNo - 1);
            RangeHashMap<Integer, Long> rangeHashMap = this.rangeHashMap;
            Objects.requireNonNull(rangeHashMap);
            this.currentEntry = new RangeHashMap.Entry(rangeHashMap, (Comparable)Integer.valueOf(packetNo), (Comparable)Integer.valueOf(this.maxPackets), (Object)offset);
            this.rangeHashMap.put(packetNo, this.currentEntry);
        }
    }

    public int getMaxPacket() {
        return this.maxPackets;
    }

    public long getOffset(int packetNo) {
        RangeHashMap.Entry entry = this.rangeHashMap.findEntry(packetNo);
        return this.calculateOffset(packetNo, entry);
    }

    private long calculateOffset(int packetNo, RangeHashMap.Entry entry) {
        return (Long)entry.getValue() + (long)(packetNo - (Integer)entry.getLower()) * (long)this.packetLength;
    }
}

