/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class PositionPushbackInputStream
extends PushbackInputStream {
    private long pos = 0L;
    private long mark = 0L;

    public PositionPushbackInputStream(InputStream in) {
        super(in);
    }

    public PositionPushbackInputStream(InputStream in, int size) {
        super(in, size);
    }

    public long getPosition() {
        return this.pos;
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        if (b >= 0) {
            ++this.pos;
        }
        return b;
    }

    @Override
    public long skip(long skip) throws IOException {
        long n = super.skip(skip);
        if (n > 0L) {
            this.pos += n;
        }
        return n;
    }

    @Override
    public void mark(int readlimit) {
        super.mark(readlimit);
        this.mark = this.pos;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.markSupported()) {
            throw new IOException("Mark not supported.");
        }
        super.reset();
        this.pos = this.mark;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = super.read(b, off, len);
        if (n > 0) {
            this.pos += (long)n;
        }
        return n;
    }

    @Override
    public void unread(int b) throws IOException {
        super.unread(b);
        --this.pos;
    }

    @Override
    public void unread(byte[] b, int off, int len) throws IOException {
        super.unread(b, off, len);
        this.pos -= (long)len;
    }

    @Override
    public void unread(byte[] b) throws IOException {
        super.unread(b);
        this.pos -= (long)b.length;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int n = super.read(b);
        if (n > 0) {
            this.pos += (long)n;
        }
        return n;
    }
}

