/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.util;

import java.awt.Component;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import javax.swing.ProgressMonitor;

public class ProgressMonitorLargeInputStream
extends FilterInputStream {
    private ProgressMonitor monitor;
    private long nread = 0L;
    private long size = 0L;
    private long divider = 1L;

    public ProgressMonitorLargeInputStream(Component parentComponent, Object message, InputStream in, long size) {
        super(in);
        this.size = size;
        if (size > Integer.MAX_VALUE) {
            this.divider = size / Integer.MAX_VALUE + 1L;
        }
        this.monitor = new ProgressMonitor(parentComponent, message, null, 0, (int)(size / this.divider));
        this.monitor.setMillisToPopup(2);
        this.monitor.setMillisToDecideToPopup(1);
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (c >= 0) {
            this.nread += (long)c;
            this.monitor.setProgress(this.getProgress());
        }
        if (this.monitor.isCanceled()) {
            InterruptedIOException exc = new InterruptedIOException("progress");
            throw exc;
        }
        return c;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int nr = this.in.read(b);
        if (nr > 0) {
            this.nread += (long)nr;
            this.monitor.setProgress(this.getProgress());
        }
        if (this.monitor.isCanceled()) {
            InterruptedIOException exc = new InterruptedIOException("progress");
            throw exc;
        }
        return nr;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int nr = this.in.read(b, off, len);
        if (nr > 0) {
            this.nread += (long)nr;
            this.monitor.setProgress(this.getProgress());
        }
        if (this.monitor.isCanceled()) {
            InterruptedIOException exc = new InterruptedIOException("progress");
            throw exc;
        }
        return nr;
    }

    @Override
    public long skip(long n) throws IOException {
        long nr = this.in.skip(n);
        if (nr > 0L) {
            this.nread += nr;
            this.monitor.setProgress(this.getProgress());
        }
        return nr;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.monitor.close();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.nread = this.size - (long)this.in.available();
        this.monitor.setProgress(this.getProgress());
    }

    private int getProgress() {
        return (int)(this.nread / this.divider);
    }
}

