/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.util;

import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvValidationException;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.psi.PMTsection;
import nl.digitalekabeltelevisie.gui.TableSource;
import nl.digitalekabeltelevisie.util.Iso6937ToUnicode;
import nl.digitalekabeltelevisie.util.PreferencesManager;
import nl.digitalekabeltelevisie.util.RangeHashMap;

public final class Utils {
    public static final int[] invNationalOptionSet = new int[]{0, 4, 2, 6, 1, 5, 3, 7};
    private static final Logger logger = Logger.getLogger(Utils.class.getName());
    private static final ClassLoader classL = Utils.class.getClassLoader();
    public static final int MASK_1BIT = 1;
    public static final int MASK_2BITS = 3;
    public static final int MASK_3BITS = 7;
    public static final int MASK_4BITS = 15;
    public static final int MASK_5BITS = 31;
    public static final int MASK_6BITS = 63;
    public static final int MASK_7BITS = 127;
    public static final int MASK_8BITS = 255;
    public static final int MASK_9BITS = 511;
    public static final int MASK_10BITS = 1023;
    public static final int MASK_12BITS = 4095;
    public static final int MASK_13BITS = 8191;
    public static final int MASK_14BITS = 16383;
    public static final int MASK_15BITS = Short.MAX_VALUE;
    public static final int MASK_16BITS = 65535;
    public static final int MASK_18BITS = 262143;
    public static final int MASK_20BITS = 1048575;
    public static final int MASK_22BITS = 0x3FFFFF;
    public static final int MASK_24BITS = 0xFFFFFF;
    public static final int MASK_30BITS = 0x3FFFFFFF;
    public static final int MASK_31BITS = Integer.MAX_VALUE;
    public static final int MASK_32BITS = -1;
    public static final long MASK_33BITS = 0x1FFFFFFFFL;
    public static final long MASK_40BITS = 0xFFFFFFFFFFL;
    public static final long MASK_48BITS = 0xDDFFFFFFFFFFL;
    public static final long MASK_64BITS = -1L;
    private static final Map<Integer, String> oui = new HashMap<Integer, String>();
    private static final RangeHashMap<Integer, String> bat = new RangeHashMap();
    private static final RangeHashMap<Integer, String> dataBroadcast = new RangeHashMap();
    private static final RangeHashMap<Integer, String> ca_system_id = new RangeHashMap();
    private static final RangeHashMap<Integer, String> original_network_id = new RangeHashMap();
    private static final RangeHashMap<Integer, String> platform_id = new RangeHashMap();
    private static final RangeHashMap<Integer, String> cni = new RangeHashMap();
    private static final RangeHashMap<Integer, String> app_type_id = new RangeHashMap();
    private static final RangeHashMap<Long, String> mhp_organisation_id = new RangeHashMap();
    private static final RangeHashMap<Integer, String> itu35_country_code = new RangeHashMap();
    private static final RangeHashMap<Long, String> private_data_spec_id = new RangeHashMap();
    private static final DecimalFormat f2 = new DecimalFormat("00");
    private static final DecimalFormat f4 = new DecimalFormat("0000");
    private static final DecimalFormat f6 = new DecimalFormat("000000");
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final int[] invtab;

    private Utils() {
    }

    private static void readOIUCsv(String fileName, Map<Integer, String> m) {
        try (CSVReader reader = new CSVReader(new InputStreamReader(classL.getResourceAsStream(fileName), StandardCharsets.UTF_8));){
            String[] nextLine;
            while ((nextLine = reader.readNext()) != null) {
                int key = Integer.parseInt(nextLine[1], 16);
                String name = nextLine[2];
                m.put(key, name);
            }
        }
        catch (CsvValidationException | IOException e) {
            logger.severe("There was a problem reading file: \"" + fileName + "\", exception:" + String.valueOf(e));
        }
    }

    private static void readCSVIdString(String fileName, RangeHashMap<Integer, String> m) {
        try (CSVReader reader = new CSVReader(new InputStreamReader(classL.getResourceAsStream(fileName), StandardCharsets.UTF_8));){
            String[] nextLine;
            while ((nextLine = reader.readNext()) != null) {
                int lower = Utils.decode(nextLine[0]);
                int upper = Utils.decode(nextLine[1]);
                m.put(lower, upper, nextLine[2]);
            }
        }
        catch (CsvValidationException | IOException e) {
            logger.severe("There was a problem reading file: \"" + fileName + "\", exception:" + String.valueOf(e));
        }
    }

    private static int decode(String text) {
        return text.startsWith("0b") || text.startsWith("0B") ? Integer.parseInt(text.substring(2), 2) : Integer.decode(text);
    }

    private static void readCSVIdLongString(String fileName, RangeHashMap<Long, String> m) {
        try (CSVReader reader = new CSVReader(new InputStreamReader(classL.getResourceAsStream(fileName), StandardCharsets.UTF_8));){
            String[] nextLine;
            while ((nextLine = reader.readNext()) != null) {
                long lower = Long.decode(nextLine[0]);
                long upper = Long.decode(nextLine[1]);
                m.put(lower, upper, nextLine[2]);
            }
        }
        catch (CsvValidationException | IOException | NumberFormatException e) {
            logger.severe("There was a problem reading file: \"" + fileName + "\", exception:" + String.valueOf(e));
        }
    }

    public static Image readIconImage(String fileName) {
        BufferedImage image = null;
        try (InputStream fileInputStream = classL.getResourceAsStream(fileName);){
            image = ImageIO.read(fileInputStream);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error reading icon image: exception:", e);
        }
        return image;
    }

    public static String getOUIString(int i) {
        String r = oui.get(i);
        if (r == null) {
            r = "unknown";
        }
        return r;
    }

    public static String getBouquetIDString(int i) {
        String r = bat.find(i);
        if (r == null) {
            r = "unknown";
        }
        return r;
    }

    public static String getDataBroadCastIDString(int i) {
        String r = dataBroadcast.find(i);
        if (r == null) {
            r = "unknown";
        }
        return r;
    }

    public static String getCASystemIDString(int i) {
        String r = ca_system_id.find(i);
        if (r == null) {
            r = "unknown";
        }
        return r;
    }

    public static String getOriginalNetworkIDString(int i) {
        String r = original_network_id.find(i);
        if (r == null) {
            r = "unknown";
        }
        return r;
    }

    public static String getPlatformIDString(int i) {
        String r = platform_id.find(i);
        if (r == null) {
            r = "unknown";
        }
        return r;
    }

    public static String getPrivateDataSpecString(long l) {
        String r = private_data_spec_id.find(l);
        if (r == null) {
            r = "unknown";
        }
        return r;
    }

    public static String getNIString(int l) {
        String r = cni.find(l);
        if (r == null) {
            r = "unknown";
        }
        return r;
    }

    public static String getAppTypeIDString(int i) {
        String r = app_type_id.find(i);
        if (r == null) {
            r = "unknown";
        }
        return r;
    }

    public static String getItu35CountryCodeString(int i) {
        String r = itu35_country_code.find(i);
        if (r == null) {
            r = "unknown";
        }
        return r;
    }

    public static String getMHPOrganistionIdString(long i) {
        String r = mhp_organisation_id.find(i);
        if (r == null) {
            r = "unknown";
        }
        return r;
    }

    public static String getActionTypeString(int actionType) {
        return switch (actionType) {
            case 0 -> "reserved";
            case 1 -> "location of IP/MAC streams in DVB networks";
            default -> "reserved for future use";
        };
    }

    public static String toHexString(byte[] block) {
        StringBuilder buf = new StringBuilder();
        if (block == null) {
            return buf.toString();
        }
        int high = 0;
        int low = 0;
        for (byte b : block) {
            high = (b & 0xF0) >> 4;
            low = b & 0xF;
            buf.append(hexChars[high]);
            buf.append(hexChars[low]);
        }
        return buf.toString();
    }

    public static String toHexString(long l, int pos) {
        String r = "0000000000000000" + Long.toHexString(l);
        r = "0x" + r.substring(r.length() - pos);
        return r;
    }

    public static String toHexStringUnformatted(long l, int pos) {
        Object r = "0000000000000000" + Long.toHexString(l);
        r = ((String)r).substring(((String)r).length() - pos);
        return r;
    }

    public static String toHexString(byte[] block, int l) {
        StringBuilder buf = new StringBuilder();
        if (block == null) {
            return buf.toString();
        }
        int high = 0;
        int low = 0;
        for (int i = 0; i < l; ++i) {
            high = (block[i] & 0xF0) >> 4;
            low = block[i] & 0xF;
            buf.append(hexChars[high]);
            buf.append(hexChars[low]);
        }
        return buf.toString();
    }

    public static String toHexString(byte[] block, int offset, int l) {
        StringBuilder buf = new StringBuilder();
        if (block == null) {
            return buf.toString();
        }
        int high = 0;
        int low = 0;
        int end = Math.min(block.length, offset + l);
        for (int i = offset; i < end; ++i) {
            high = (block[i] & 0xF0) >> 4;
            low = block[i] & 0xF;
            buf.append(hexChars[high]);
            buf.append(hexChars[low]);
        }
        return buf.toString();
    }

    public static String toBinaryString(long l, int pos) {
        String r = "00000000000000000000000000000000" + Long.toBinaryString(l);
        r = "0b" + r.substring(r.length() - pos);
        return r;
    }

    public static byte getInt2UnsignedByte(int b) {
        if (b <= 127) {
            return (byte)b;
        }
        return (byte)(b - 256);
    }

    public static int getInt(byte[] bytes, int offset, int len, int mask) {
        int r = 0;
        for (int i = 0; i < len; ++i) {
            r = r << 8 | Byte.toUnsignedInt(bytes[offset + i]);
        }
        return r & mask;
    }

    public static long getLong(byte[] bytes, int offset, int len, long mask) {
        long r = 0L;
        for (int i = 0; i < len; ++i) {
            r = r << 8 | (long)Byte.toUnsignedInt(bytes[offset + i]);
        }
        return r & mask;
    }

    public static BigInteger getBigInteger(byte[] bytes, int offset, int len) {
        return new BigInteger(1, Arrays.copyOfRange(bytes, offset, offset + len));
    }

    public static int getBit(byte b, int i) {
        return b & 128 >> i - 1;
    }

    public static int getBits(byte b, int i, int len) {
        int mask = 0;
        for (int pos = i; pos < i + len; ++pos) {
            mask |= 128 >> pos - 1;
        }
        return (b & mask) >> 9 - i - len;
    }

    public static String getBCD(byte[] b, int startNibbleNo, int len) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int byteNo = (startNibbleNo + i) / 2;
            boolean shift = (startNibbleNo + i) % 2 == 0;
            int t = shift ? (Byte.toUnsignedInt(b[byteNo]) & 0xF0) >> 4 : Byte.toUnsignedInt(b[byteNo]) & 0xF;
            if (t > 9) {
                logger.warning("Error parsing BCD: " + Utils.toHexString(b) + " ,nibble_no: " + startNibbleNo + " ,len: " + len);
            }
            buf.append(Integer.toString(t, 16));
        }
        return buf.toString();
    }

    public static byte[] getBytes(byte[] b, int offset, int len) {
        return Arrays.copyOfRange(b, offset, offset + len);
    }

    public static String getEscapedHTML(List<DVBString> dvbStrings, int maxWidth) {
        StringBuilder raw = new StringBuilder();
        for (DVBString str : dvbStrings) {
            raw.append(str.toRawString());
        }
        String rawString = raw.toString();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int currentLineLength = 0;
        int rawLength = raw.length();
        while (i < rawLength) {
            StringBuilder plainSection = new StringBuilder();
            while (i < rawLength && !Utils.isControlCharacter(rawString.charAt(i))) {
                plainSection.append(rawString.charAt(i));
                ++i;
            }
            StringTokenizer st = new StringTokenizer(plainSection.toString());
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (maxWidth != 0 && currentLineLength + s.length() > maxWidth) {
                    sb.append("<br>").append(Utils.escapeHTML(s));
                    currentLineLength = s.length();
                    continue;
                }
                sb.append(' ').append(Utils.escapeHTML(s));
                currentLineLength += 1 + s.length();
            }
            while (i < rawLength && Utils.isControlCharacter(rawString.charAt(i))) {
                switch (rawString.charAt(i)) {
                    case '\u008a': {
                        sb.append("<br>");
                        currentLineLength = 0;
                        break;
                    }
                    case '\u0086': {
                        sb.append("<em>");
                        break;
                    }
                    case '\u0087': {
                        sb.append("</em>");
                    }
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public static String getString(byte[] b, int off, int len) {
        String decoded = Utils.getCharDecodedStringWithControls(b, off, len);
        return Utils.removeControlChars(decoded);
    }

    private static String removeControlChars(String decoded) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < decoded.length(); ++i) {
            char c = decoded.charAt(i);
            if (Utils.isControlCharacter(c)) continue;
            result.append(c);
        }
        return result.toString();
    }

    private static boolean isControlCharacter(char c) {
        return c >= '\u0080' && c <= '\u009f';
    }

    public static String getCharDecodedStringWithControls(byte[] b, int off, int len) {
        int length = len;
        int offset = off;
        if (length <= 0) {
            return "";
        }
        Charset charset = Utils.getCharSet(b, offset, length);
        int charSetLen = Utils.getCharSetLen(b, offset);
        if ((offset += charSetLen) < 0 || (length -= charSetLen) < 0 || offset > b.length - length) {
            return "";
        }
        if (charset == null) {
            return Iso6937ToUnicode.convert(b, offset, length);
        }
        return new String(b, offset, length, charset);
    }

    public static Charset getCharSet(byte[] b, int offset, int length) {
        Charset charset = null;
        if (length > 0 && b[offset] < 32 && b[offset] >= 0) {
            byte selectorByte = b[offset];
            try {
                if (selectorByte > 0 && selectorByte <= 11) {
                    charset = Charset.forName("ISO-8859-" + (selectorByte + 4));
                } else if (selectorByte == 16 && b.length > offset + 2) {
                    if (b[offset + 1] == 0) {
                        charset = Charset.forName("ISO-8859-" + b[offset + 2]);
                    }
                } else if (selectorByte == 17) {
                    charset = StandardCharsets.UTF_16;
                } else if (selectorByte == 20) {
                    charset = Charset.forName("Big5");
                } else if (selectorByte == 21) {
                    charset = StandardCharsets.UTF_8;
                }
            }
            catch (IllegalArgumentException e) {
                logger.info("IllegalArgumentException in getCharSet:" + String.valueOf(e));
                charset = StandardCharsets.ISO_8859_1;
            }
            if (charset == null) {
                charset = StandardCharsets.ISO_8859_1;
            }
        }
        return charset;
    }

    private static int getCharSetLen(byte[] b, int offset) {
        int charsetLen = 0;
        if (b[offset] < 32 && b[offset] >= 0) {
            byte selectorByte = b[offset];
            if (selectorByte > 0 && selectorByte <= 11) {
                charsetLen = 1;
            } else if (selectorByte == 16) {
                if (b[offset + 1] == 0) {
                    charsetLen = 3;
                }
            } else if (selectorByte == 17) {
                charsetLen = 1;
            } else if (selectorByte == 20) {
                charsetLen = 1;
            } else if (selectorByte == 21) {
                charsetLen = 1;
            } else if (selectorByte == 31) {
                charsetLen = 2;
            }
        }
        return charsetLen;
    }

    public static String getISO8859_1String(byte[] b, int offset, int length) {
        if (length <= 0) {
            return "";
        }
        return new String(b, offset, length, StandardCharsets.ISO_8859_1);
    }

    public static String toCodePointString(String in) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < in.length(); ++i) {
            b.append(Integer.toHexString(in.codePointAt(i))).append(" ");
        }
        return b.toString();
    }

    public static String getUTCFormattedString(byte[] UTC_time) {
        return String.format("%1$tY/%1$tm/%1$td %1$tH:%1$tM:%1$tS", Utils.getUTCLocalDateTime(UTC_time));
    }

    public static String getEITStartTimeAsString(byte[] UTC_time) {
        if (Utils.isUndefined(UTC_time)) {
            return "undefined";
        }
        return Utils.getUTCFormattedString(UTC_time);
    }

    public static boolean isUndefined(byte[] uTC_time) {
        for (byte b : uTC_time) {
            if (b == -1) continue;
            return false;
        }
        return true;
    }

    public static long getDurationSeconds(String eventDuration) {
        int hours = Integer.parseInt(eventDuration.substring(0, 2));
        int minutes = Integer.parseInt(eventDuration.substring(2, 4));
        int seconds = Integer.parseInt(eventDuration.substring(4, 6));
        return ((long)hours * 60L + (long)minutes) * 60L + (long)seconds;
    }

    public static LocalDateTime getUTCLocalDateTime(byte[] UTC_time) {
        long mjd = Utils.getLong(UTC_time, 0, 2, 65535L);
        if ((mjd & 0x8000L) == 0L) {
            mjd += 65536L;
        }
        String hours = Utils.getBCD(UTC_time, 4, 2);
        String minutes = Utils.getBCD(UTC_time, 6, 2);
        String secs = Utils.getBCD(UTC_time, 8, 2);
        long y = (long)(((double)mjd - 15078.2) / 365.25);
        long m = (long)(((double)mjd - 14956.1 - (double)((long)((double)y * 365.25))) / 30.6001);
        long d = mjd - 14956L - (long)((double)y * 365.25) - (long)((double)m * 30.6001);
        long k = m == 14L || m == 15L ? 1L : 0L;
        y = y + k + 1900L;
        m = m - 1L - k * 12L;
        try {
            int h = Integer.parseInt(hours);
            int mins = Integer.parseInt(minutes);
            int s = Integer.parseInt(secs);
            return LocalDateTime.of((int)y, (int)m, (int)d, h, mins, s);
        }
        catch (NumberFormatException ne) {
            logger.log(Level.WARNING, "error parsing calendar:", ne);
            return null;
        }
    }

    public static String getStreamTypeString(int tag) {
        switch (tag) {
            case 0: {
                return "ITU-T | ISO/IEC Reserved";
            }
            case 1: {
                return "ISO/IEC 11172 Video";
            }
            case 2: {
                return "ITU-T Rec. H.262 | ISO/IEC 13818-2 Video or ISO/IEC 11172-2 constrained parameter video stream";
            }
            case 3: {
                return "ISO/IEC 11172 Audio";
            }
            case 4: {
                return "ISO/IEC 13818-3 Audio";
            }
            case 5: {
                return "ITU-T Rec. H.222.0 | ISO/IEC 13818-1 private_sections";
            }
            case 6: {
                return "ITU-T Rec. H.222.0 | ISO/IEC 13818-1 PES packets containing private data";
            }
            case 7: {
                return "ISO/IEC 13522 MHEG";
            }
            case 8: {
                return "ITU-T Rec. H.222.0 | ISO/IEC 13818-1 Annex A DSM-CC";
            }
            case 9: {
                return "ITU-T Rec. H.222.1";
            }
            case 10: {
                return "Multi-protocol Encapsulation";
            }
            case 11: {
                return "DSM-CC U-N Messages";
            }
            case 12: {
                return "DSM-CC Stream Descriptors";
            }
            case 13: {
                return "DSM-CC Sections (any type, including private data)";
            }
            case 14: {
                return "ITU-T Rec. H.222.0 | ISO/IEC 13818-1 auxiliary";
            }
            case 15: {
                return "ISO/IEC 13818-7 Audio with ADTS transport syntax";
            }
            case 16: {
                return "ISO/IEC 14496-2 Visual";
            }
            case 17: {
                return "ISO/IEC 14496-3 Audio with the LATM transport syntax as defined in ISO/IEC 14496-3 / AMD 1";
            }
            case 18: {
                return "ISO/IEC 14496-1 SL-packetized stream or FlexMux stream carried in PES packets";
            }
            case 19: {
                return "ISO/IEC 14496-1 SL-packetized stream or FlexMux stream carried in ISO/IEC14496_sections.";
            }
            case 20: {
                return "DSM-CC Synchronized Download Protocol";
            }
            case 21: {
                return "Metadata carried in PES packets";
            }
            case 22: {
                return "Metadata carried in metadata_sections";
            }
            case 23: {
                return "Metadata carried in ISO/IEC 13818-6 Data Carousel";
            }
            case 24: {
                return "Metadata carried in ISO/IEC 13818-6 Object Carousel";
            }
            case 25: {
                return "Metadata carried in ISO/IEC 13818-6 Synchronized Download Protocol";
            }
            case 26: {
                return "IPMP stream (defined in ISO/IEC 13818-11, MPEG-2 IPMP)";
            }
            case 27: {
                return "AVC video stream as defined in ITU-T Rec. H.264 | ISO/IEC 14496-10 Video, or AVC base layer of an HEVC video stream as defined in ITU-T H.265 | ISO/IEC 23008-2 ";
            }
            case 28: {
                return "ISO/IEC 14496-3 Audio, without using any additional transport syntax, such as DST, ALS and SLS";
            }
            case 29: {
                return "ISO/IEC 14496-17 Text";
            }
            case 30: {
                return "Auxiliary video stream as defined in ISO/IEC 23002-3";
            }
            case 31: {
                return "SVC video sub-bitstream of a video stream as defined in the Annex G of ITU-T Rec. H.264 | ISO/IEC 14496-10 Video";
            }
            case 32: {
                return "MVC video sub-bitstream of an AVC video stream conforming to one or more profiles defined in Annex H of ITU-T Rec. H.264 | ISO/IEC 14496-10";
            }
            case 33: {
                return "J2K Video stream conforming to one or more profiles as defined in ITU-T Rec T.800 | ISO/IEC 15444-1";
            }
            case 34: {
                return "Additional view Rec. ITU-T H.262 | ISO/IEC 13818-2 video stream for service-compatible stereoscopic 3D services";
            }
            case 35: {
                return "Additional view Rec. ITU-T H.264 | ISO/IEC 14496-10 video stream conforming to one or more profiles defined in Annex A for service-compatible stereoscopic 3D services";
            }
            case 36: {
                return "ITU-T H.265 | ISO/IEC 23008-2 video stream or an HEVC temporal video sub-bitstream";
            }
            case 37: {
                return "HEVC temporal video subset of an HEVC video stream conforming to one or more profiles defined in Annex A of Rec. ITU-T H.265 | ISO/IEC 23008-2";
            }
            case 38: {
                return "TMVCD video sub-bitstream of an AVC video stream conforming to one or more profiles defined in Annex I of Rec. ITU-T H.264 | ISO/IEC 14496-10";
            }
            case 39: {
                return "Timeline and External Media Information Stream";
            }
            case 40: {
                return "HEVC enhancement sub-partition which includes TemporalId 0 of an HEVC video stream where all NALs units contained in the stream conform to one or more profiles defined in Annex G of Rec. ITU-T H.265 | ISO/IEC 23008-2 ";
            }
            case 41: {
                return "HEVC temporal enhancement sub-partition of an HEVC video stream where all NAL units contained in the stream conform to one or more profiles defined in Annex G of Rec. ITU-T H.265 | ISO/IEC 23008-2";
            }
            case 42: {
                return "HEVC enhancement sub-partition which includes TemporalId 0 of an HEVC video stream where all NAL units contained in the stream conform to one or more profiles defined in Annex H of Rec. ITU-T H.265 | ISO/IEC 23008-2";
            }
            case 43: {
                return "HEVC temporal enhancement sub-partition of an HEVC video stream where all NAL units contained in the stream conform to one or more profiles defined in Annex H of Rec. ITU-T H.265 | ISO/IEC 23008-2";
            }
            case 44: {
                return "Green access units carried in MPEG-2 sections";
            }
            case 45: {
                return "ISO/IEC 23008-3 Audio with MHAS transport syntax \u2013 main stream";
            }
            case 46: {
                return "ISO/IEC 23008-3 Audio with MHAS transport syntax \u2013 auxiliary stream";
            }
            case 47: {
                return "Quality access units carried in sections";
            }
            case 48: {
                return "Media Orchestration Access Units carried in sections";
            }
            case 49: {
                return "Substream of a Rec. ITU-T H.265 | ISO/IEC 23008 2 video stream that contains a Motion Constrained Tile Set, parameter sets, slice headers or a combination thereof.";
            }
            case 50: {
                return "JPEG XS video stream conforming to one or more profiles as defined in ISO/IEC 21122-2";
            }
            case 51: {
                return "H.266 VVC video stream or a VVC temporal video sub-bitstream";
            }
            case 52: {
                return "H.266 VVC temporal video subset of a VVC video stream";
            }
            case 53: {
                return "EVC video stream or an EVC temporal video sub-bitstream";
            }
            case 54: {
                return "LCEVC video stream conforming to one or more profiles defined in ISO/IEC 23094-2";
            }
            case 127: {
                return "IPMP stream";
            }
            case 128: {
                return "User Private / MPEG Video (ATSC) / PCM (HDMV)";
            }
            case 129: {
                return "User Private / AC-3 (ATSC/HDMV)";
            }
            case 130: {
                return "User Private / SCTE-27 subtitling / DTS 6 ch (HDMV)";
            }
            case 131: {
                return "User Private / Isochronous Data (SCTE) / AC-3 (TrueHD) (HDMV)";
            }
            case 132: {
                return "User Private / E-AC-3 up to 16 ch. (HDMV)";
            }
            case 133: {
                return "User Private / Program Identifier (SCTE) / DTS 8 ch.(HD-HRA) (HDMV)";
            }
            case 134: {
                return "User Private / SCTE-35 splice_info_section / DTS 8 ch. (HD-MA) (HDMV)";
            }
            case 135: {
                return "User Private / E-AC-3 (ATSC)";
            }
            case 136: {
                return "User Private / Microsoft Windows Media Video 9 (VC-1) (lower bit-rate video)";
            }
            case 144: {
                return "User Private / Time Slicing - MPE-FEC (DVB) / Presentation Graphic Stream (subtitling) (HDMV)";
            }
            case 145: {
                return "User Private / Presentation Graphic Stream (subtitling) (HDMV)";
            }
            case 146: {
                return "User Private / Subtitle text (TEXTST) (HDMV)";
            }
            case 149: {
                return "User Private / Data Service Table, Network Resources Table (ATSC)";
            }
            case 161: {
                return "User Private / AC-3 (HDMV)";
            }
            case 162: {
                return "User Private / DTS (HDMV)";
            }
            case 192: {
                return "User Private / DigiCipher II text";
            }
            case 193: {
                return "User Private / Dolby Digital (AC-3) up to six channel audio with AES-128-CBC data encryption";
            }
            case 194: {
                return "User Private / DSM CC synchronous data (ATSC) / Dolby Digital Plus up to 16 channel audio with AES-128-CBC data encryption";
            }
            case 207: {
                return "User Private / ISO/IEC 13818-7 ADTS AAC with AES-128-CBC frame encryption";
            }
            case 209: {
                return "User Private / BBC Dirac (Ultra HD video)";
            }
            case 212: {
                return "User Private / AVS3 Video";
            }
            case 213: {
                return "User Private / AVS3 Audio";
            }
            case 219: {
                return "User Private / ITU-T Rec. H.264 and ISO/IEC 14496-10 with AES-128-CBC slice encryption";
            }
            case 234: {
                return "User Private / Microsoft Windows Media Video 9 (VC-1) (lower bit-rate video)";
            }
        }
        if (44 <= tag && tag <= 126) {
            return "ITU-T Rec. H.222.0 | ISO/IEC 13818-1 Reserved";
        }
        if (128 <= tag && tag <= 255) {
            return "User Private";
        }
        return "illegal/unknown value";
    }

    public static String getStreamTypeShortString(int tag) {
        switch (tag) {
            case 0: {
                return "ITU-T | ISO/IEC Reserved";
            }
            case 1: {
                return "Video MPEG1";
            }
            case 2: {
                return "Video H.262 (MPEG2)";
            }
            case 3: {
                return "Audio MPEG1";
            }
            case 4: {
                return "Audio MPEG2";
            }
            case 5: {
                return "private_sections MPEG2";
            }
            case 6: {
                return "PES packets private data";
            }
            case 7: {
                return "MHEG";
            }
            case 8: {
                return "ITU-T Rec. H.222.0 | ISO/IEC 13818-1 Annex A DSM-CC";
            }
            case 9: {
                return "ITU-T Rec. H.222.1";
            }
            case 10: {
                return "Multi-protocol Encapsulation";
            }
            case 11: {
                return "DSM-CC U-N Messages";
            }
            case 12: {
                return "DSM-CC Stream Descriptors";
            }
            case 13: {
                return "DSM-CC Sections (any)";
            }
            case 14: {
                return "ITU-T Rec. H.222.0 | ISO/IEC 13818-1 auxiliary";
            }
            case 15: {
                return "ISO/IEC 13818-7 Audio with ADTS transport syntax";
            }
            case 16: {
                return "ISO/IEC 14496-2 Visual";
            }
            case 17: {
                return "Audio AAC";
            }
            case 18: {
                return "ISO/IEC 14496-1 SL-packetized stream or FlexMux stream carried in PES packets";
            }
            case 19: {
                return "ISO/IEC 14496-1 SL-packetized stream or FlexMux stream carried in ISO/IEC14496_sections.";
            }
            case 20: {
                return "DSM-CC Synchronized Download Protocol";
            }
            case 21: {
                return "Metadata in PES packets";
            }
            case 22: {
                return "Metadata in metadata_sections";
            }
            case 23: {
                return "Metadata 13818-6 Data Carousel";
            }
            case 24: {
                return "Metadata 13818-6 Object Carousel";
            }
            case 25: {
                return "Metadata 13818-6 Synchronized Download Protocol";
            }
            case 26: {
                return "IPMP stream (13818-11, MPEG-2 IPMP)";
            }
            case 27: {
                return "Video H.264 (AVC)";
            }
            case 28: {
                return "ISO/IEC 14496-3 Audio, like DST, ALS and SLS";
            }
            case 29: {
                return "ISO/IEC 14496-17 Text";
            }
            case 30: {
                return "ISO/IEC 23002-3 Aux. video stream ";
            }
            case 31: {
                return "ISO/IEC 14496-10 Video sub-bitstream";
            }
            case 32: {
                return "MVC video sub-bitstream";
            }
            case 33: {
                return "J2K Video stream";
            }
            case 34: {
                return "H.262 video stream for 3D services";
            }
            case 35: {
                return "H.264 video stream for 3D services";
            }
            case 36: {
                return "Video H.265 (HEVC)";
            }
            case 37: {
                return "H.265 temporal video subset";
            }
            case 38: {
                return "MVCD video sub-bitstream of an AVC video stream";
            }
            case 39: {
                return "TEMI Stream";
            }
            case 40: {
                return "HEVC enhancement sub-partition which includes TemporalId 0 of an HEVC video stream where all NALs units contained in the stream conform to one or more profiles defined in Annex G of Rec. ITU-T H.265 | ISO/IEC 23008-2 ";
            }
            case 41: {
                return "HEVC temporal enhancement sub-partition of an HEVC video stream where all NAL units contained in the stream conform to one or more profiles defined in Annex G of Rec. ITU-T H.265 | ISO/IEC 23008-2";
            }
            case 42: {
                return "HEVC enhancement sub-partition which includes TemporalId 0 of an HEVC video stream where all NAL units contained in the stream conform to one or more profiles defined in Annex H of Rec. ITU-T H.265 | ISO/IEC 23008-2";
            }
            case 43: {
                return "HEVC temporal enhancement sub-partition of an HEVC video stream where all NAL units contained in the stream conform to one or more profiles defined in Annex H of Rec. ITU-T H.265 | ISO/IEC 23008-2";
            }
            case 44: {
                return "Green access units carried in MPEG-2 sections";
            }
            case 45: {
                return "ISO/IEC 23008-3 Audio with MHAS transport syntax \u2013 main stream";
            }
            case 46: {
                return "ISO/IEC 23008-3 Audio with MHAS transport syntax \u2013 auxiliary stream";
            }
            case 47: {
                return "Quality access units carried in sections";
            }
            case 48: {
                return "Media Orchestration Access Units carried in sections";
            }
            case 49: {
                return "Substream of a Rec. ITU-T H.265 | ISO/IEC 23008 2 video stream that contains a Motion Constrained Tile Set, parameter sets, slice headers or a combination thereof.";
            }
            case 50: {
                return "JPEG XS video stream conforming to one or more profiles as defined in ISO/IEC 21122-2";
            }
            case 51: {
                return " Video H.266 (VVC)";
            }
            case 52: {
                return "VVC temporal video subset of a VVC video stream conforming to one or more profiles defined in Annex A of Rec. ITU-T H.266 | ISO/IEC 23090-3";
            }
            case 53: {
                return "EVC video stream or an EVC temporal video sub-bitstream conforming to one or more profiles defined in ISO/IEC 23094-1";
            }
            case 54: {
                return "LCEVC video stream conforming to one or more profiles defined in ISO/IEC 23094-2";
            }
            case 127: {
                return "IPMP stream";
            }
            case 128: {
                return "MPEG Video / PCM";
            }
            case 129: {
                return "AC-3 (ATSC)";
            }
            case 130: {
                return "SCTE-27 subtitling / DTS 6 ch";
            }
            case 131: {
                return "Isochronous Data (SCTE) / AC-3";
            }
            case 132: {
                return "E-AC-3 up to 16 ch.";
            }
            case 133: {
                return "Program Identifier / DTS 8 ch.";
            }
            case 134: {
                return "SCTE-35 splice_info_section / DTS 8 ch.";
            }
            case 135: {
                return "E-AC-3 (ATSC)";
            }
            case 136: {
                return "VC-1";
            }
            case 144: {
                return "Time Slicing - MPE-FEC (DVB) / PGS subtitling)";
            }
            case 145: {
                return "PGS subtitling";
            }
            case 146: {
                return "Subtitle text (TEXTST)";
            }
            case 149: {
                return "Data Service Table, Network Resources Table";
            }
            case 161: {
                return "AC-3";
            }
            case 162: {
                return "DTS";
            }
            case 192: {
                return "DigiCipher II text";
            }
            case 193: {
                return "AC-3 with AES-128-CBC data encryption";
            }
            case 194: {
                return "DSM CC synchronous data / Dolby Digital Plus with AES-128-CBC data encryption";
            }
            case 207: {
                return "ISO/IEC 13818-7 ADTS AAC with AES-128-CBC frame encryption";
            }
            case 209: {
                return "Dirac video";
            }
            case 212: {
                return "AVS3 Video";
            }
            case 219: {
                return "H.264 and ISO/IEC 14496-10 with AES-128-CBC slice encryption";
            }
            case 234: {
                return "VC-1";
            }
        }
        if (39 <= tag && tag <= 126) {
            return "ISO/IEC 13818-1 Reserved";
        }
        if (128 <= tag && tag <= 255) {
            return "User Private";
        }
        return "illegal value";
    }

    public static String getDataIDString(int dataId) {
        if (0 <= dataId && dataId <= 15) {
            return "Reserved";
        }
        if (16 <= dataId && dataId <= 31) {
            return "EBU data EN 300 472/ EN 301 775 (teletext, VPS, WSS)";
        }
        if (35 <= dataId && dataId <= 127) {
            return "Reserved";
        }
        if (128 <= dataId && dataId <= 152) {
            return "user defined";
        }
        if (153 <= dataId && dataId <= 155) {
            return "EBU teletext/VPS/WSS/closed caption/VBI sample data";
        }
        if (156 <= dataId && dataId <= 255) {
            return "user defined";
        }
        return switch (dataId) {
            case 32 -> "DVB subtitling EN 300 743";
            case 33 -> "DVB synchronous data stream";
            case 34 -> "DVB synchronized data stream";
            default -> "illegal value";
        };
    }

    public static void addListJTree(DefaultMutableTreeNode parent, Collection<? extends TreeNode> itemList, int modus, String label) {
        Utils.addListJTree(parent, itemList, modus, label, null);
    }

    public static void addListJTree(DefaultMutableTreeNode parent, Collection<? extends TreeNode> itemCollection, int modus, String label, TableSource tableSource) {
        if (itemCollection != null && !itemCollection.isEmpty()) {
            if (Utils.simpleModus(modus)) {
                Utils.addToList(parent, itemCollection, modus);
            } else {
                KVP kvp = new KVP(label + ": " + itemCollection.size() + " entries");
                kvp.setCrumb(label);
                if (tableSource != null) {
                    kvp.addTableSource(tableSource, label);
                }
                Utils.addToList(kvp, itemCollection, modus);
                parent.add(kvp);
            }
        }
    }

    public static void addToList(DefaultMutableTreeNode parent, Collection<? extends TreeNode> itemCollection, int modus) {
        if (Utils.countListModus(modus)) {
            int count = 0;
            for (TreeNode treeNode : itemCollection) {
                DefaultMutableTreeNode node = treeNode.getJTreeNode(modus);
                Object object = node.getUserObject();
                if (object instanceof KVP) {
                    KVP kvp = (KVP)object;
                    kvp.appendLabel(" [" + count++ + "]");
                }
                parent.add(node);
            }
        } else {
            for (TreeNode treeNode : itemCollection) {
                parent.add(treeNode.getJTreeNode(modus));
            }
        }
    }

    public static String toSafeString(byte[] block) {
        StringBuilder buf = new StringBuilder();
        if (block == null) {
            return buf.toString();
        }
        for (byte b : block) {
            if (32 <= Byte.toUnsignedInt(b) && Byte.toUnsignedInt(b) <= 127) {
                buf.append((char)b);
                continue;
            }
            buf.append('.');
        }
        return buf.toString();
    }

    public static String toSafeString(byte[] block, int offset, int len) {
        StringBuilder buf = new StringBuilder();
        if (block == null) {
            return buf.toString();
        }
        int end = Math.min(block.length, offset + len);
        for (int i = offset; i < end; ++i) {
            byte b = block[i];
            if (32 <= Byte.toUnsignedInt(b) && Byte.toUnsignedInt(b) < 127) {
                buf.append((char)b);
                continue;
            }
            buf.append('.');
        }
        return buf.toString();
    }

    @Deprecated
    public static byte[] copyOfRange(byte[] original, int from, int to) {
        return Arrays.copyOfRange(original, from, to);
    }

    public static String escapeSimpleHTML(String s) {
        StringBuilder sb = new StringBuilder();
        if (s == null) {
            return "";
        }
        int n = s.length();
        block5: for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block5;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block5;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String escapeHTML(String s) {
        StringBuilder sb = new StringBuilder();
        if (s == null) {
            return "&nbsp;";
        }
        int n = s.length();
        block104: for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case ' ': {
                    sb.append("&nbsp;");
                    continue block104;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block104;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block104;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block104;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block104;
                }
                case '\u20ac': {
                    sb.append("&euro;");
                    continue block104;
                }
                case '\u2122': {
                    sb.append("&trade;");
                    continue block104;
                }
                case '\u00a1': {
                    sb.append("&iexcl;");
                    continue block104;
                }
                case '\u00a2': {
                    sb.append("&cent;");
                    continue block104;
                }
                case '\u00a3': {
                    sb.append("&pound;");
                    continue block104;
                }
                case '\u00a4': {
                    sb.append("&curren;");
                    continue block104;
                }
                case '\u00a5': {
                    sb.append("&yen;");
                    continue block104;
                }
                case '\u00a6': {
                    sb.append("&brvbar;");
                    continue block104;
                }
                case '\u00a7': {
                    sb.append("&sect;");
                    continue block104;
                }
                case '\u00a8': {
                    sb.append("&uml;");
                    continue block104;
                }
                case '\u00a9': {
                    sb.append("&copy;");
                    continue block104;
                }
                case '\u00aa': {
                    sb.append("&ordf;");
                    continue block104;
                }
                case '\u00ab': {
                    sb.append("&laquo;");
                    continue block104;
                }
                case '\u00ac': {
                    sb.append("&not;");
                    continue block104;
                }
                case '\u00ad': {
                    sb.append("&shy;");
                    continue block104;
                }
                case '\u00ae': {
                    sb.append("&reg;");
                    continue block104;
                }
                case '\u00af': {
                    sb.append("&macr;");
                    continue block104;
                }
                case '\u00b0': {
                    sb.append("&deg;");
                    continue block104;
                }
                case '\u00b1': {
                    sb.append("&plusmn;");
                    continue block104;
                }
                case '\u00b2': {
                    sb.append("&sup2;");
                    continue block104;
                }
                case '\u00b3': {
                    sb.append("&sup3;");
                    continue block104;
                }
                case '\u00b4': {
                    sb.append("&acute;");
                    continue block104;
                }
                case '\u00b5': {
                    sb.append("&micro;");
                    continue block104;
                }
                case '\u00b6': {
                    sb.append("&para;");
                    continue block104;
                }
                case '\u00b7': {
                    sb.append("&middot;");
                    continue block104;
                }
                case '\u00b8': {
                    sb.append("&cedil;");
                    continue block104;
                }
                case '\u00b9': {
                    sb.append("&sup1;");
                    continue block104;
                }
                case '\u00ba': {
                    sb.append("&ordm;");
                    continue block104;
                }
                case '\u00bb': {
                    sb.append("&raquo;");
                    continue block104;
                }
                case '\u00bc': {
                    sb.append("&frac14;");
                    continue block104;
                }
                case '\u00bd': {
                    sb.append("&frac12;");
                    continue block104;
                }
                case '\u00be': {
                    sb.append("&frac34;");
                    continue block104;
                }
                case '\u00bf': {
                    sb.append("&iquest;");
                    continue block104;
                }
                case '\u00d7': {
                    sb.append("&times;");
                    continue block104;
                }
                case '\u00f7': {
                    sb.append("&divide;");
                    continue block104;
                }
                case '\u00c0': {
                    sb.append("&Agrave;");
                    continue block104;
                }
                case '\u00c1': {
                    sb.append("&Aacute;");
                    continue block104;
                }
                case '\u00c2': {
                    sb.append("&Acirc;");
                    continue block104;
                }
                case '\u00c3': {
                    sb.append("&Atilde;");
                    continue block104;
                }
                case '\u00c4': {
                    sb.append("&Auml;");
                    continue block104;
                }
                case '\u00c5': {
                    sb.append("&Aring;");
                    continue block104;
                }
                case '\u00c6': {
                    sb.append("&AElig;");
                    continue block104;
                }
                case '\u00c7': {
                    sb.append("&Ccedil;");
                    continue block104;
                }
                case '\u00c8': {
                    sb.append("&Egrave;");
                    continue block104;
                }
                case '\u00c9': {
                    sb.append("&Eacute;");
                    continue block104;
                }
                case '\u00ca': {
                    sb.append("&Ecirc;");
                    continue block104;
                }
                case '\u00cb': {
                    sb.append("&Euml;");
                    continue block104;
                }
                case '\u00cc': {
                    sb.append("&Igrave;");
                    continue block104;
                }
                case '\u00cd': {
                    sb.append("&Iacute;");
                    continue block104;
                }
                case '\u00ce': {
                    sb.append("&Icirc;");
                    continue block104;
                }
                case '\u00cf': {
                    sb.append("&Iuml;");
                    continue block104;
                }
                case '\u00d0': {
                    sb.append("&ETH;");
                    continue block104;
                }
                case '\u00d1': {
                    sb.append("&Ntilde;");
                    continue block104;
                }
                case '\u00d2': {
                    sb.append("&Ograve;");
                    continue block104;
                }
                case '\u00d3': {
                    sb.append("&Oacute;");
                    continue block104;
                }
                case '\u00d4': {
                    sb.append("&Ocirc;");
                    continue block104;
                }
                case '\u00d5': {
                    sb.append("&Otilde;");
                    continue block104;
                }
                case '\u00d6': {
                    sb.append("&Ouml;");
                    continue block104;
                }
                case '\u00d8': {
                    sb.append("&Oslash;");
                    continue block104;
                }
                case '\u00d9': {
                    sb.append("&Ugrave;");
                    continue block104;
                }
                case '\u00da': {
                    sb.append("&Uacute;");
                    continue block104;
                }
                case '\u00db': {
                    sb.append("&Ucirc;");
                    continue block104;
                }
                case '\u00dc': {
                    sb.append("&Uuml;");
                    continue block104;
                }
                case '\u00dd': {
                    sb.append("&Yacute;");
                    continue block104;
                }
                case '\u00de': {
                    sb.append("&THORN;");
                    continue block104;
                }
                case '\u00df': {
                    sb.append("&szlig;");
                    continue block104;
                }
                case '\u00e0': {
                    sb.append("&agrave;");
                    continue block104;
                }
                case '\u00e1': {
                    sb.append("&aacute;");
                    continue block104;
                }
                case '\u00e2': {
                    sb.append("&acirc;");
                    continue block104;
                }
                case '\u00e3': {
                    sb.append("&atilde;");
                    continue block104;
                }
                case '\u00e4': {
                    sb.append("&auml;");
                    continue block104;
                }
                case '\u00e5': {
                    sb.append("&aring;");
                    continue block104;
                }
                case '\u00e6': {
                    sb.append("&aelig;");
                    continue block104;
                }
                case '\u00e7': {
                    sb.append("&ccedil;");
                    continue block104;
                }
                case '\u00e8': {
                    sb.append("&egrave;");
                    continue block104;
                }
                case '\u00e9': {
                    sb.append("&eacute;");
                    continue block104;
                }
                case '\u00ea': {
                    sb.append("&ecirc;");
                    continue block104;
                }
                case '\u00eb': {
                    sb.append("&euml;");
                    continue block104;
                }
                case '\u00ec': {
                    sb.append("&igrave;");
                    continue block104;
                }
                case '\u00ed': {
                    sb.append("&iacute;");
                    continue block104;
                }
                case '\u00ee': {
                    sb.append("&icirc;");
                    continue block104;
                }
                case '\u00ef': {
                    sb.append("&iuml;");
                    continue block104;
                }
                case '\u00f0': {
                    sb.append("&eth;");
                    continue block104;
                }
                case '\u00f1': {
                    sb.append("&ntilde;");
                    continue block104;
                }
                case '\u00f2': {
                    sb.append("&ograve;");
                    continue block104;
                }
                case '\u00f3': {
                    sb.append("&oacute;");
                    continue block104;
                }
                case '\u00f4': {
                    sb.append("&ocirc;");
                    continue block104;
                }
                case '\u00f5': {
                    sb.append("&otilde;");
                    continue block104;
                }
                case '\u00f6': {
                    sb.append("&ouml;");
                    continue block104;
                }
                case '\u00f8': {
                    sb.append("&oslash;");
                    continue block104;
                }
                case '\u00f9': {
                    sb.append("&ugrave;");
                    continue block104;
                }
                case '\u00fa': {
                    sb.append("&uacute;");
                    continue block104;
                }
                case '\u00fb': {
                    sb.append("&ucirc;");
                    continue block104;
                }
                case '\u00fc': {
                    sb.append("&uuml;");
                    continue block104;
                }
                case '\u00fd': {
                    sb.append("&yacute;");
                    continue block104;
                }
                case '\u00fe': {
                    sb.append("&thorn;");
                    continue block104;
                }
                case '\u00ff': {
                    sb.append("&yuml;");
                    continue block104;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static boolean simpleModus(int m) {
        return (m & 1) != 0;
    }

    public static boolean psiOnlyModus(int m) {
        return (m & 2) != 0;
    }

    public static boolean packetModus(int m) {
        return (m & 4) != 0;
    }

    public static boolean countListModus(int m) {
        return (m & 8) != 0;
    }

    public static boolean showPtsModus(int m) {
        return (m & 0x10) != 0;
    }

    public static boolean showVersionModus(int m) {
        return (m & 0x20) != 0;
    }

    public static String stripLeadingZeros(String s) {
        int st;
        int len = s.length() - 1;
        for (st = 0; st < len && s.charAt(st) == '0' && s.charAt(st + 1) != '.'; ++st) {
        }
        return s.substring(st);
    }

    public static String formatIPNumber(byte[] ip) {
        StringBuilder r = new StringBuilder();
        if (ip.length > 0) {
            r.append(Byte.toUnsignedInt(ip[0]));
        }
        for (int i = 1; i < ip.length; ++i) {
            r.append('.').append(Byte.toUnsignedInt(ip[i]));
        }
        return r.toString();
    }

    public static String printPCRTime(long program_clock_reference) {
        long p = program_clock_reference / 27L;
        long fa = 1000000L;
        long allSecs = p / 1000000L;
        long h = p / 3600000000L;
        long m = p / 60000000L - h * 60L;
        long s = p / 1000000L - h * 3600L - m * 60L;
        long u = p - h * 1000000L * 60L * 60L - m * 1000000L * 60L - s * 1000000L;
        if (PreferencesManager.isEnableSecondsTimestamp()) {
            return String.format("%1$d.%2$06d", allSecs, u);
        }
        return String.format("%1$d:%2$02d:%3$02d.%4$06d", h, m, s, u);
    }

    public static String printTimebase90kHz(long ts) {
        long p = ts / 9L;
        long allSecs = ts / 90000L;
        long h = p / 36000000L;
        long m = p / 600000L - h * 60L;
        long s = p / 10000L - h * 3600L - m * 60L;
        long u = p - h * 10000L * 60L * 60L - m * 10000L * 60L - s * 10000L;
        if (PreferencesManager.isEnableSecondsTimestamp()) {
            return allSecs + "." + f6.format(u);
        }
        return h + ":" + f2.format(m) + ":" + f2.format(s) + "." + f4.format(u);
    }

    public static int getHammingReverseByte(byte b) {
        int t = Byte.toUnsignedInt(b);
        int r = (t & 0x40) >> 6;
        r |= (t & 0x10) >> 3;
        r |= t & 4;
        return r |= (t & 1) << 3;
    }

    public static int getHammingByte(byte b) {
        int t = Byte.toUnsignedInt(b);
        int r = (t & 0x40) >> 3;
        r |= (t & 0x10) >> 2;
        r |= (t & 4) >> 1;
        return r |= t & 1;
    }

    public static int getHamming24_8Byte(byte[] b, int offset) {
        int lsb = (b[offset] & 0x20) << 2 | (b[offset] & 0xE) << 3 | (b[offset + 1] & 0xF0) >> 4;
        int msb = (b[offset + 1] & 0xE) << 4 | (b[offset + 2] & 0xF8) >> 3;
        int hsb = (b[offset + 2] & 6) << 5;
        return 65536 * invtab[hsb] + 256 * invtab[msb] + invtab[lsb];
    }

    public static int indexOf(byte[] source, byte[] target, int fromIndex) {
        if (fromIndex >= source.length) {
            return -1;
        }
        byte first = target[0];
        int max = source.length - target.length;
        for (int i = fromIndex; i < max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + target.length - 1;
            int k = 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static boolean equals(byte[] data_block, int offset, int len, byte[] data_block2, int offset2, int len2) {
        return Arrays.equals(data_block, offset, offset + len, data_block2, offset2, offset2 + len2);
    }

    public static String getAspectRatioInformationString(int s) {
        return switch (s) {
            case 0 -> "forbidden";
            case 1 -> "1,0 (Square Sample)";
            case 2 -> "3\u00f74";
            case 3 -> "9\u00f716";
            case 4 -> "1\u00f72,21";
            default -> "reserved";
        };
    }

    public static String getHTMLHexviewColored(byte[] byteValue, int offset, int len, RangeHashMap<Integer, Color> coloring) {
        StringBuilder b = new StringBuilder();
        b.append("<pre>");
        b.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0001 0203 0405 0607 0809 0A0B 0C0D 0E0F 0123456789ABCDEF<br>");
        int lines = 1 + (len - 1) / 16;
        for (int l = 0; l < lines; ++l) {
            int start = l * 16;
            b.append(Utils.toHexString(start, 6));
            b.append("&nbsp;");
            b.append("<span>");
            int lineLen = l == lines - 1 ? len - l * 16 : 16;
            Color currentColor = coloring.find(l * 16);
            if (currentColor != null) {
                b.append("<span style=\"color:").append(Utils.toHexString(currentColor)).append("\">");
            }
            for (int i = 0; i < 16; ++i) {
                if (i < lineLen) {
                    b.append(Utils.toHexString(byteValue, offset + l * 16 + i, 1));
                } else {
                    b.append("&nbsp;&nbsp;");
                }
                Color nextColor = coloring.find(l * 16 + i + 1);
                if (currentColor != null && !currentColor.equals(nextColor)) {
                    b.append("</span>");
                }
                if (nextColor != null && !nextColor.equals(currentColor)) {
                    b.append("<span style=\"color:").append(Utils.toHexString(nextColor)).append("\">");
                }
                currentColor = nextColor;
                if (i % 2 == 0) continue;
                b.append("&nbsp;");
            }
            if (currentColor != null) {
                b.append("</span>");
            }
            b.append(Utils.escapeHTML(Utils.toSafeString(byteValue, offset + l * 16, lineLen))).append("</span><br>");
        }
        b.append("</pre>");
        return b.toString();
    }

    public static int findMPEG2VideoPid(PMTsection pmt) {
        int videoPID = 0;
        for (PMTsection.Component component : pmt.getComponentenList()) {
            if (component.getStreamtype() != 2) continue;
            videoPID = component.getElementaryPID();
            break;
        }
        return videoPID;
    }

    public static LocalDateTime roundHourUp(LocalDateTime time) {
        return time.plusMinutes(59L).plusSeconds(59L).plusNanos(999999L).truncatedTo(ChronoUnit.HOURS);
    }

    public static LocalDateTime roundHourDown(LocalDateTime time) {
        return time.truncatedTo(ChronoUnit.HOURS);
    }

    public static String escapeHtmlBreakLines(String t) {
        StringTokenizer st = new StringTokenizer(t);
        int len = 0;
        StringBuilder res = new StringBuilder();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (len + s.length() > 80) {
                res.append("<br>").append(Utils.escapeHTML(s));
                len = s.length();
                continue;
            }
            res.append(' ').append(Utils.escapeHTML(s));
            len += 1 + s.length();
        }
        return res.toString();
    }

    public static String getHexAndDecimalFormattedString(int intValue) {
        StringBuilder b = new StringBuilder();
        b.append("0x").append(Integer.toHexString(intValue).toUpperCase()).append(" (").append(intValue).append(")");
        return b.toString();
    }

    public static String getHexAndDecimalFormattedString(long longValue) {
        StringBuilder b = new StringBuilder();
        b.append("0x").append(Long.toHexString(longValue).toUpperCase()).append(" (").append(longValue).append(")");
        return b.toString();
    }

    public static String getHexAndDecimalFormattedString(BigInteger bigIntValue) {
        StringBuilder b = new StringBuilder();
        b.append("0x").append(bigIntValue.toString(16).toUpperCase()).append(" (").append(bigIntValue).append(")");
        return b.toString();
    }

    public static boolean getBitAsBoolean(byte b, int i) {
        return (b & 128 >> i - 1) != 0;
    }

    public static int getBooleanAsInt(boolean b) {
        return b ? 1 : 0;
    }

    public static String getHTMLHexview(byte[] byteValue, int offset, int len) {
        StringBuilder b = new StringBuilder();
        b.append("<pre>");
        b.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0001 0203 0405 0607 0809 0A0B 0C0D 0E0F 0123456789ABCDEF<br>");
        int lines = 1 + (len - 1) / 16;
        for (int l = 0; l < lines; ++l) {
            int start = l * 16;
            b.append(Utils.toHexString(start, 6));
            b.append("&nbsp;");
            b.append("<span style=\"color:black; background-color: white;\">");
            int lineLen = l == lines - 1 ? len - l * 16 : 16;
            for (int i = 0; i < 16; ++i) {
                if (i < lineLen) {
                    b.append(Utils.toHexString(byteValue, offset + l * 16 + i, 1));
                } else {
                    b.append("&nbsp;&nbsp;");
                }
                if (i % 2 == 0) continue;
                b.append("&nbsp;");
            }
            b.append(Utils.escapeHTML(Utils.toSafeString(byteValue, offset + l * 16, lineLen))).append("</span><br>");
        }
        b.append("</pre>");
        return b.toString();
    }

    public static String toHexString(Color c) {
        Object s = Integer.toHexString(c.getRGB() & 0xFFFFFF);
        if (((String)s).length() < 6) {
            s = "000000".substring(0, 6 - ((String)s).length()) + (String)s;
        }
        return "#" + (String)s;
    }

    public static StringBuilder getChildrenAsHTML(DefaultMutableTreeNode dmtn) {
        String lineSep = "<br>";
        StringBuilder res = new StringBuilder();
        Enumeration<javax.swing.tree.TreeNode> children = dmtn.children();
        while (children.hasMoreElements()) {
            javax.swing.tree.TreeNode next = children.nextElement();
            if (!(next instanceof DefaultMutableTreeNode)) continue;
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)next;
            KVP chKVP = (KVP)child.getUserObject();
            res.append(chKVP.toString(KVP.STRING_DISPLAY.HTML_FRAGMENTS, KVP.NUMBER_DISPLAY.BOTH)).append("<br>");
            if (child.isLeaf()) continue;
            res.append((CharSequence)Utils.getChildrenAsHTML(child));
        }
        return res;
    }

    public static String formatDuration(String duration) {
        if (duration == null || duration.length() != 6) {
            return duration;
        }
        StringBuilder res = new StringBuilder(duration.substring(0, 2)).append('h');
        res.append(duration, 2, 4).append('m').append(duration, 4, 6);
        return res.toString();
    }

    public static String extractTextFromHTML(String htmlString) {
        StringReader reader = new StringReader(htmlString);
        final ArrayList list = new ArrayList();
        HTMLEditorKit.ParserCallback parserCallback = new HTMLEditorKit.ParserCallback(){

            @Override
            public void handleText(char[] data, int pos) {
                list.add(new String(data));
            }

            @Override
            public void handleStartTag(HTML.Tag tag, MutableAttributeSet attribute, int pos) {
            }

            @Override
            public void handleEndTag(HTML.Tag t, int pos) {
                if (t.equals(HTML.Tag.P)) {
                    list.add("\n");
                }
            }

            @Override
            public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (t.equals(HTML.Tag.BR)) {
                    list.add("\n");
                }
            }

            @Override
            public void handleComment(char[] data, int pos) {
            }

            @Override
            public void handleError(String errMsg, int pos) {
            }
        };
        try {
            new ParserDelegator().parse(reader, parserCallback, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuilder result = new StringBuilder();
        for (String s : list) {
            result.append(s);
        }
        return result.toString();
    }

    public static boolean listContainsByteArray(List<byte[]> list, byte[] pay) {
        for (byte[] inList : list) {
            if (!Arrays.equals(inList, pay)) continue;
            return true;
        }
        return false;
    }

    public static byte[] bytesListToArray(List<Byte> payLoad) {
        byte[] res = new byte[payLoad.size()];
        for (int i = 0; i < payLoad.size(); ++i) {
            res[i] = payLoad.get(i);
        }
        return res;
    }

    public static void appendHeader(StringBuilder s, String headerString, Color color) {
        s.append("<br><span style=\"color:").append(Utils.toHexString(color)).append("\"><b>");
        s.append(headerString);
        s.append("</b><br>");
    }

    static {
        Utils.readOIUCsv("res/oui.csv", oui);
        Utils.readCSVIdString("res/bouquet_id.csv", bat);
        Utils.readCSVIdString("res/data_broadcast_id.csv", dataBroadcast);
        Utils.readCSVIdString("res/ca_system_id.csv", ca_system_id);
        Utils.readCSVIdString("res/original_network_id.csv", original_network_id);
        Utils.readCSVIdString("res/platform_id.csv", platform_id);
        Utils.readCSVIdString("res/ni.csv", cni);
        Utils.readCSVIdString("res/app_type_id.csv", app_type_id);
        Utils.readCSVIdString("res/itu35country_codes.csv", itu35_country_code);
        Utils.readCSVIdLongString("res/mhp_organisation_id.csv", mhp_organisation_id);
        Utils.readCSVIdLongString("res/private_data_spec_id.csv", private_data_spec_id);
        invtab = new int[]{0, 128, 64, 192, 32, 160, 96, 224, 16, 144, 80, 208, 48, 176, 112, 240, 8, 136, 72, 200, 40, 168, 104, 232, 24, 152, 88, 216, 56, 184, 120, 248, 4, 132, 68, 196, 36, 164, 100, 228, 20, 148, 84, 212, 52, 180, 116, 244, 12, 140, 76, 204, 44, 172, 108, 236, 28, 156, 92, 220, 60, 188, 124, 252, 2, 130, 66, 194, 34, 162, 98, 226, 18, 146, 82, 210, 50, 178, 114, 242, 10, 138, 74, 202, 42, 170, 106, 234, 26, 154, 90, 218, 58, 186, 122, 250, 6, 134, 70, 198, 38, 166, 102, 230, 22, 150, 86, 214, 54, 182, 118, 246, 14, 142, 78, 206, 46, 174, 110, 238, 30, 158, 94, 222, 62, 190, 126, 254, 1, 129, 65, 193, 33, 161, 97, 225, 17, 145, 81, 209, 49, 177, 113, 241, 9, 137, 73, 201, 41, 169, 105, 233, 25, 153, 89, 217, 57, 185, 121, 249, 5, 133, 69, 197, 37, 165, 101, 229, 21, 149, 85, 213, 53, 181, 117, 245, 13, 141, 77, 205, 45, 173, 109, 237, 29, 157, 93, 221, 61, 189, 125, 253, 3, 131, 67, 195, 35, 163, 99, 227, 19, 147, 83, 211, 51, 179, 115, 243, 11, 139, 75, 203, 43, 171, 107, 235, 27, 155, 91, 219, 59, 187, 123, 251, 7, 135, 71, 199, 39, 167, 103, 231, 23, 151, 87, 215, 55, 183, 119, 247, 15, 143, 79, 207, 47, 175, 111, 239, 31, 159, 95, 223, 63, 191, 127, 255};
    }
}

