/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.util.tablemodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import nl.digitalekabeltelevisie.util.tablemodel.ColumnDetails;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeader;

public class TableHeaderBuilder<E, R> {
    private final List<ColumnDetails<?>> header = new ArrayList();
    private final Map<String, ColumnDetails<?>> map = new HashMap();
    private long keyBase;

    private String nextKey() {
        ++this.keyBase;
        return Long.toHexString(this.keyBase);
    }

    public TableHeaderBuilder<E, R> addRequiredBaseColumn(String name, Function<E, Object> fun, Class<?> type) {
        String key = this.nextKey();
        ColumnDetails<E> bcd = new ColumnDetails<E>(name, key, fun, null, type, true, false, null, true);
        this.header.add(bcd);
        this.map.put(key, bcd);
        return this;
    }

    public TableHeaderBuilder<E, R> addOptionalBaseColumn(String name, Function<E, Object> fun, Class<?> type) {
        String key = this.nextKey();
        ColumnDetails<E> bcd = new ColumnDetails<E>(name, key, fun, null, type, false, false, null, true);
        this.header.add(bcd);
        this.map.put(key, bcd);
        return this;
    }

    public TableHeaderBuilder<E, R> addOptionalRepeatingBaseColumn(String name, Function<E, List<Object>> listFun, Class<?> type) {
        String keyBase = this.nextKey();
        ColumnDetails<E> cd = new ColumnDetails<E>(name, keyBase, null, listFun, type, false, true, null, true);
        this.header.add(cd);
        this.map.put(keyBase, cd);
        return this;
    }

    public TableHeaderBuilder<E, R> addOptionalRepeatingGroupedBaseColumn(String name, Function<E, List<Object>> listFun, Class<?> type, String groupId) {
        String keyBase = this.nextKey();
        ColumnDetails<E> cd = new ColumnDetails<E>(name, keyBase, null, listFun, type, false, true, groupId, true);
        this.header.add(cd);
        this.map.put(keyBase, cd);
        return this;
    }

    public TableHeaderBuilder<E, R> addRequiredRowColumn(String name, Function<R, Object> fun, Class<?> type) {
        String key = this.nextKey();
        ColumnDetails<R> bcd = new ColumnDetails<R>(name, key, fun, null, type, true, false, null, false);
        this.header.add(bcd);
        this.map.put(key, bcd);
        return this;
    }

    public TableHeaderBuilder<E, R> addOptionalRowColumn(String name, Function<R, Object> fun, Class<?> type) {
        String key = this.nextKey();
        ColumnDetails<R> cd = new ColumnDetails<R>(name, key, fun, null, type, false, false, null, false);
        this.header.add(cd);
        this.map.put(key, cd);
        return this;
    }

    public TableHeaderBuilder<E, R> addOptionalRepeatingRowColumn(String name, Function<R, List<Object>> listFun, Class<?> type) {
        String keyBase = this.nextKey();
        ColumnDetails<R> cd = new ColumnDetails<R>(name, keyBase, null, listFun, type, false, true, null, false);
        this.header.add(cd);
        this.map.put(keyBase, cd);
        return this;
    }

    public TableHeaderBuilder<E, R> addOptionalRepeatingGroupedColumn(String name, Function<R, List<Object>> listFun, Class<?> type, String groupId) {
        String keyBase = this.nextKey();
        ColumnDetails<R> cd = new ColumnDetails<R>(name, keyBase, null, listFun, type, false, true, groupId, false);
        this.header.add(cd);
        this.map.put(keyBase, cd);
        return this;
    }

    public TableHeader<E, R> build() {
        return new TableHeader(this.header, this.map);
    }
}

