/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.controller;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import nl.digitalekabeltelevisie.util.Utils;

public class DVBString {
    private final byte[] data;
    private final int offset;

    public DVBString(byte[] data, int offset) {
        this.data = data;
        this.offset = offset;
    }

    public DVBString(byte[] dataIn, int offset, int len) {
        if (len > 255) {
            throw new RuntimeException("DVB String can not be longer than 255 chars:" + len);
        }
        this.data = new byte[len + 1];
        this.data[0] = (byte)len;
        this.offset = 0;
        System.arraycopy(dataIn, offset, this.data, 1, len);
    }

    public String toEscapedHTML() {
        return this.toEscapedHTML(0);
    }

    public String toEscapedHTML(int maxWidth) {
        ArrayList<DVBString> array = new ArrayList<DVBString>(Arrays.asList(this));
        return Utils.getEscapedHTML(array, maxWidth);
    }

    public String toString() {
        return Utils.getString(this.data, this.getOffset() + 1, this.getLength());
    }

    public String toRawString() {
        return Utils.getCharDecodedStringWithControls(this.data, this.getOffset() + 1, this.getLength());
    }

    public String toString(Charset defaultCharSet) {
        if (this.getCharSet() != null || defaultCharSet == null) {
            return this.toString();
        }
        return new String(this.data, this.getOffset() + 1, this.getLength(), defaultCharSet);
    }

    public Charset getCharSet() {
        return Utils.getCharSet(this.data, this.getOffset() + 1, this.getLength());
    }

    public String getEncodingString() {
        if (this.getLength() == 0) {
            return "-";
        }
        int fb = Byte.toUnsignedInt(this.data[this.offset + 1]);
        if (32 <= fb) {
            return "default (ISO 6937, latin)";
        }
        if (1 <= fb && fb <= 31) {
            switch (fb) {
                case 1: {
                    return "ISO/IEC 8859-5";
                }
                case 2: {
                    return "ISO/IEC 8859-6";
                }
                case 3: {
                    return "ISO/IEC 8859-7";
                }
                case 4: {
                    return "ISO/IEC 8859-8";
                }
                case 5: {
                    return "ISO/IEC 8859-9";
                }
                case 6: {
                    return "ISO/IEC 8859-10";
                }
                case 7: {
                    return "ISO/IEC 8859-11";
                }
                case 8: {
                    return "ISO/IEC 8859-12";
                }
                case 9: {
                    return "ISO/IEC 8859-13";
                }
                case 10: {
                    return "ISO/IEC 8859-14";
                }
                case 11: {
                    return "ISO/IEC 8859-15";
                }
                case 16: {
                    if (this.data[this.offset + 2] == 0 && this.data.length > this.offset + 3) {
                        return "ISO/IEC 8859-" + this.data[this.offset + 3];
                    }
                    return "Illegal value";
                }
                case 17: {
                    return "ISO/IEC 10646-1";
                }
                case 18: {
                    return "KSX1001-2004";
                }
                case 19: {
                    return "GB-2312-1980";
                }
                case 20: {
                    return "Big5 subset of ISO/IEC 10646-1";
                }
                case 21: {
                    return "UTF-8 encoding of ISO/IEC 10646-1";
                }
                case 31: {
                    return "Described by encoding_type_id;" + this.data[this.offset + 2];
                }
            }
            return "reserved for future use";
        }
        return "illegal value";
    }

    public int getLength() {
        return Utils.getInt(this.data, this.offset, 1, 255);
    }

    public int getOffset() {
        return this.offset;
    }

    public byte[] getData() {
        return this.data;
    }
}

