/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.controller;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.gui.DetailSource;
import nl.digitalekabeltelevisie.gui.HTMLSource;
import nl.digitalekabeltelevisie.gui.ImageSource;
import nl.digitalekabeltelevisie.gui.TableSource;
import nl.digitalekabeltelevisie.gui.XMLSource;
import nl.digitalekabeltelevisie.util.Utils;

public class KVP
extends DefaultMutableTreeNode {
    private static final int BYTE_DATA_MAX_LEN = 100;
    private String label;
    private String stringValue;
    private String description;
    private int intValue;
    private long longValue;
    private byte[] byteValue;
    private int byteStart = 0;
    private int byteLen = 0;
    private DVBString dvbStringValue;
    private BigInteger bigIntegerValue;
    private static NUMBER_DISPLAY numberDisplay = NUMBER_DISPLAY.DECIMAL;
    private static STRING_DISPLAY stringDisplay = STRING_DISPLAY.PLAIN;
    private FIELD_TYPE fieldType;
    private List<DetailView> detailViews = new ArrayList<DetailView>();
    private String crumb;
    private JMenuItem subMenu;
    private Object owner;
    private String labelAppend = "";
    private String htmlLabel;

    public KVP(String label) {
        this.label = label;
        this.fieldType = FIELD_TYPE.LABEL;
    }

    public KVP(String label, String stringValue) {
        this.label = label;
        this.stringValue = stringValue;
        this.fieldType = FIELD_TYPE.STRING;
    }

    public KVP(String label, String stringValue, String description) {
        this(label, stringValue);
        this.setDescription(description);
    }

    public KVP(String label, int intValue) {
        this.label = label;
        this.intValue = intValue;
        this.fieldType = FIELD_TYPE.INT;
    }

    public KVP(String label, int intValue, String description) {
        this(label, intValue);
        this.setDescription(description);
    }

    public KVP(String label, long longValue) {
        this.label = label;
        this.longValue = longValue;
        this.fieldType = FIELD_TYPE.LONG;
    }

    public KVP(String label, long longValue, String description) {
        this(label, longValue);
        this.setDescription(description);
    }

    public KVP(String label, byte[] byteArray) {
        this.label = label;
        this.byteValue = byteArray;
        this.byteStart = 0;
        this.byteLen = byteArray.length;
        this.fieldType = FIELD_TYPE.BYTES;
        this.addHTMLSource(() -> Utils.getHTMLHexview(this.byteValue, this.byteStart, this.byteLen), "Hex View");
    }

    public KVP(String label, byte[] byteArray, String description) {
        this(label, byteArray);
        this.setDescription(description);
    }

    public KVP(String label, byte[] byteArray, int offset, int len) {
        this.label = label;
        this.byteValue = byteArray;
        this.byteStart = offset;
        this.byteLen = len;
        this.fieldType = FIELD_TYPE.BYTES;
        this.addHTMLSource(() -> Utils.getHTMLHexview(this.byteValue, this.byteStart, this.byteLen), "Hex View");
    }

    public KVP(String label, byte[] byteArray, int offset, int len, String description) {
        this(label, byteArray, offset, len);
        this.setDescription(description);
    }

    public KVP(String label, DVBString dvbStringValue) {
        this.label = label;
        this.dvbStringValue = dvbStringValue;
        this.fieldType = FIELD_TYPE.DVBSTRING;
        this.add(new KVP("encoding", dvbStringValue.getEncodingString()));
        this.add(new KVP("length", dvbStringValue.getLength()));
        this.addHTMLSource(() -> "<b>Encoding:</b> " + dvbStringValue.getEncodingString() + "<br><br><b>Data:</b><br>" + Utils.getHTMLHexview(dvbStringValue.getData(), dvbStringValue.getOffset() + 1, dvbStringValue.getLength()) + "<br><b>Formatted:</b><br>" + dvbStringValue.toEscapedHTML(), "DVB String");
    }

    public KVP(String label, BigInteger bigIntegerValue) {
        this.label = label;
        this.bigIntegerValue = bigIntegerValue;
        this.fieldType = FIELD_TYPE.BIGINT;
    }

    public KVP(String label, BigInteger bigIntegerValue, String description) {
        this(label, bigIntegerValue);
        this.setDescription(description);
    }

    public String getDescription() {
        return this.description;
    }

    public KVP setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public KVP setLabel(String label) {
        this.label = label;
        return this;
    }

    public void appendLabel(String labelAppend) {
        this.labelAppend = this.labelAppend + labelAppend;
    }

    @Override
    public String toString() {
        return this.toString(stringDisplay, numberDisplay);
    }

    public String toString(STRING_DISPLAY stringFormat, NUMBER_DISPLAY numberFormat) {
        StringBuilder b = new StringBuilder();
        if (this.htmlLabel != null && STRING_DISPLAY.PLAIN != stringFormat) {
            b.append(this.htmlLabel);
        } else {
            b.append(this.label);
        }
        if (!this.labelAppend.isEmpty()) {
            b.append(this.labelAppend);
        }
        if (this.fieldType != FIELD_TYPE.LABEL) {
            this.appendValueAfterLabel(numberFormat, b);
        }
        if (stringFormat == STRING_DISPLAY.JAVASCRIPT) {
            return b.toString().replace("\"", "\\\"").replace("'", "\\'");
        }
        if (this.htmlLabel != null && stringFormat == STRING_DISPLAY.HTML_AWT) {
            return "<html>" + b + "</html>";
        }
        return b.toString();
    }

    private void appendValueAfterLabel(NUMBER_DISPLAY numberFormat, StringBuilder b) {
        b.append(": ");
        switch (this.fieldType.ordinal()) {
            case 0: {
                this.appendString(b);
                break;
            }
            case 2: {
                this.appendInteger(numberFormat, b);
                break;
            }
            case 3: {
                this.appendLong(numberFormat, b);
                break;
            }
            case 1: {
                this.appendHexBytes(b);
                break;
            }
            case 5: {
                this.appendDVBString(b);
                break;
            }
            case 6: {
                this.appendBigInteger(numberFormat, b);
            }
        }
        if (this.description != null) {
            b.append(" => ").append(this.description);
        }
    }

    private void appendDVBString(StringBuilder b) {
        b.append(this.dvbStringValue.toString());
    }

    private void appendHexBytes(StringBuilder b) {
        if (this.byteLen == 0) {
            b.append('-');
        } else {
            if (this.byteLen > 100) {
                b.append("[truncated] ");
            }
            int showLen = Math.min(this.byteLen, 100);
            b.append("0x").append(Utils.toHexString(this.byteValue, this.byteStart, showLen)).append(" \"").append(Utils.toSafeString(this.byteValue, this.byteStart, showLen)).append("\"");
        }
    }

    private void appendString(StringBuilder b) {
        b.append(this.stringValue);
    }

    private void appendLong(NUMBER_DISPLAY numberFormat, StringBuilder b) {
        if (numberFormat == NUMBER_DISPLAY.DECIMAL) {
            b.append(this.longValue);
        } else if (numberFormat == NUMBER_DISPLAY.HEX) {
            b.append("0x").append(Long.toHexString(this.longValue).toUpperCase());
        } else {
            b.append("0x").append(Long.toHexString(this.longValue).toUpperCase()).append(" (").append(this.longValue).append(")");
        }
    }

    private void appendInteger(NUMBER_DISPLAY numberFormat, StringBuilder b) {
        if (numberFormat == NUMBER_DISPLAY.DECIMAL) {
            b.append(this.intValue);
        } else if (numberFormat == NUMBER_DISPLAY.HEX) {
            b.append("0x").append(Integer.toHexString(this.intValue).toUpperCase());
        } else {
            b.append(Utils.getHexAndDecimalFormattedString(this.intValue));
        }
    }

    private void appendBigInteger(NUMBER_DISPLAY numberFormat, StringBuilder b) {
        if (numberFormat == NUMBER_DISPLAY.DECIMAL) {
            b.append(this.bigIntegerValue.toString());
        } else if (numberFormat == NUMBER_DISPLAY.HEX) {
            b.append("0x").append(this.bigIntegerValue.toString(16).toUpperCase());
        } else {
            b.append(Utils.getHexAndDecimalFormattedString(this.bigIntegerValue));
        }
    }

    public static NUMBER_DISPLAY getNumberDisplay() {
        return numberDisplay;
    }

    public static void setNumberDisplay(NUMBER_DISPLAY intDisplay) {
        numberDisplay = intDisplay;
    }

    public static String formatInt(int intValue) {
        if (numberDisplay == NUMBER_DISPLAY.DECIMAL) {
            return Integer.toString(intValue);
        }
        if (numberDisplay == NUMBER_DISPLAY.HEX) {
            return "0x" + Integer.toHexString(intValue).toUpperCase();
        }
        return "0x" + Integer.toHexString(intValue).toUpperCase() + " (" + intValue + ")";
    }

    public static STRING_DISPLAY getStringDisplay() {
        return stringDisplay;
    }

    public static void setStringDisplay(STRING_DISPLAY stringDisplay) {
        KVP.stringDisplay = stringDisplay;
    }

    public String getPlainText() {
        return this.toString(STRING_DISPLAY.PLAIN, NUMBER_DISPLAY.BOTH);
    }

    public JMenuItem getSubMenu() {
        return this.subMenu;
    }

    public KVP setSubMenuAndOwner(JMenuItem subMenu, Object owner) {
        this.subMenu = subMenu;
        this.owner = owner;
        return this;
    }

    public KVP setSubMenu(JMenuItem subMenu) {
        this.subMenu = subMenu;
        return this;
    }

    public Object getOwner() {
        return this.owner;
    }

    public boolean isBytes() {
        return this.fieldType == FIELD_TYPE.BYTES;
    }

    public byte[] getByteValue() {
        if (this.fieldType == FIELD_TYPE.BYTES) {
            return Arrays.copyOfRange(this.byteValue, this.byteStart, this.byteStart + this.byteLen);
        }
        return new byte[0];
    }

    public String getCrumb() {
        if (this.crumb != null) {
            return this.crumb;
        }
        return switch (this.fieldType.ordinal()) {
            case 4 -> this.label;
            case 2 -> this.label + ":" + this.intValue;
            case 3 -> this.label + ":" + this.longValue;
            default -> null;
        };
    }

    public KVP setCrumb(String path) {
        this.crumb = path;
        return this;
    }

    public List<DetailView> getDetailViews() {
        return this.detailViews;
    }

    public KVP addHTMLSource(HTMLSource htmlSource, String label) {
        this.detailViews.add(new DetailView(htmlSource, label));
        return this;
    }

    public KVP addImageSource(ImageSource imageSource, String label) {
        this.detailViews.add(new DetailView(imageSource, label));
        return this;
    }

    public KVP addTableSource(TableSource tableSource, String label) {
        this.detailViews.add(new DetailView(tableSource, label));
        return this;
    }

    public KVP addXMLSource(XMLSource xmlSource, String label) {
        this.detailViews.add(new DetailView(xmlSource, label));
        return this;
    }

    @Override
    public Object getUserObject() {
        return this;
    }

    public KVP setHtmlLabel(String htmlLabel) {
        this.htmlLabel = htmlLabel;
        return this;
    }

    public KVP addList(Collection<? extends TreeNode> itemList, int modus, String label) {
        Utils.addListJTree(this, itemList, modus, label);
        return this;
    }

    public KVP addToList(Collection<? extends TreeNode> itemList, int modus) {
        Utils.addToList(this, itemList, modus);
        return this;
    }

    public static enum FIELD_TYPE {
        STRING,
        BYTES,
        INT,
        LONG,
        LABEL,
        DVBSTRING,
        BIGINT;

    }

    public static enum STRING_DISPLAY {
        PLAIN,
        JAVASCRIPT,
        HTML_FRAGMENTS,
        HTML_AWT;

    }

    public static enum NUMBER_DISPLAY {
        DECIMAL,
        HEX,
        BOTH;

    }

    public record DetailView(DetailSource detailSource, String label) {
    }
}

