/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg;

import java.awt.Color;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.AdaptationField;
import nl.digitalekabeltelevisie.data.mpeg.TransportStream;
import nl.digitalekabeltelevisie.data.mpeg.pes.PesHeader;
import nl.digitalekabeltelevisie.gui.HTMLSource;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.RangeHashMap;
import nl.digitalekabeltelevisie.util.Utils;

public class TSPacket
implements HTMLSource,
TreeNode {
    private static final Logger logger = Logger.getLogger(TSPacket.class.getName());
    private static final String ERROR_PARSING_ADAPTATION_FIELD = "Error parsing AdaptationField";
    protected final byte[] buffer;
    protected int packetNo = -1;
    protected static final Color HEADER_COLOR = new Color(255);
    protected static final Color ADAPTATION_FIELD_COLOR = new Color(32768);
    protected static final Color FEC_COLOR = new Color(0x800080);
    protected static final Color PES_HEADER_COLOR = new Color(0x800000);
    protected static final Color ERROR_COLOR = new Color(0xFF0000);
    protected final TransportStream transportStream;
    protected long packetOffset = -1L;
    private PesHeader pesHeader = null;

    public synchronized PesHeader getPesHeader() {
        if (this.pesHeader == null && this.hasPayload() && this.isPayloadUnitStartIndicator()) {
            int payloadStart = 4;
            if (this.hasAdaptationField()) {
                AdaptationField adaptationField = this.getAdaptationField();
                if (adaptationField == null) {
                    return null;
                }
                payloadStart = 5 + adaptationField.getAdaptation_field_length();
            }
            try {
                this.pesHeader = new PesHeader(this.buffer, payloadStart);
            }
            catch (Exception e) {
                logger.info("Exception getting PesHeader at packet " + this.packetNo);
            }
        }
        return this.pesHeader;
    }

    public TSPacket(byte[] buf, int no, TransportStream ts) {
        this.buffer = Arrays.copyOf(buf, buf.length);
        this.packetNo = no;
        this.transportStream = ts;
    }

    public int getTransportScramblingControl() {
        return (this.buffer[3] & 0xC0) >> 6;
    }

    public String getTransportScramblingControlString() {
        switch (this.getTransportScramblingControl()) {
            case 0: {
                return "not scrambled";
            }
            case 1: {
                return "Reserved for future DVB use";
            }
            case 2: {
                return "TS packet scrambled with Even Key";
            }
            case 3: {
                return "TS packet scrambled with Odd Key";
            }
        }
        throw new IllegalArgumentException("Invalid value in getTransportScramblingControl:" + this.getTransportScramblingControl());
    }

    public boolean isTransportErrorIndicator() {
        return (this.buffer[1] & 0x80) != 0;
    }

    public int getTransportErrorIndicator() {
        return (this.buffer[1] & 0x80) >> 7;
    }

    public boolean isPayloadUnitStartIndicator() {
        return (this.buffer[1] & 0x40) != 0;
    }

    public int getPayloadUnitStartIndicator() {
        return (this.buffer[1] & 0x40) >> 6;
    }

    public boolean isTransportPriority() {
        return (this.buffer[1] & 0x20) != 0;
    }

    public int getTransportPriority() {
        return (this.buffer[1] & 0x20) >> 5;
    }

    public int getAdaptationFieldControl() {
        return (this.buffer[3] & 0x30) >> 4;
    }

    public String getAdaptationFieldControlString() {
        switch (this.getAdaptationFieldControl()) {
            case 0: {
                return "reserved for future use by ISO/IEC";
            }
            case 1: {
                return "no adaptation_field, payload only";
            }
            case 2: {
                return "adaptation_field only, no payload";
            }
            case 3: {
                return "adaptation_field followed by payload";
            }
        }
        throw new IllegalArgumentException("Invalid value in getAdaptationFieldControl:" + this.getAdaptationFieldControl());
    }

    public boolean hasAdaptationField() {
        int adaptationFieldControl = this.getAdaptationFieldControl();
        return adaptationFieldControl == 2 || adaptationFieldControl == 3;
    }

    public byte[] getAdaptationFieldBytes() {
        int adaptationFieldControl = this.getAdaptationFieldControl();
        if (adaptationFieldControl == 2 || adaptationFieldControl == 3) {
            return Arrays.copyOfRange(this.buffer, 4, 4 + Byte.toUnsignedInt(this.buffer[4]) + 1);
        }
        return new byte[0];
    }

    public AdaptationField getAdaptationField() {
        int adaptationFieldControl = this.getAdaptationFieldControl();
        if (adaptationFieldControl == 2 || adaptationFieldControl == 3) {
            try {
                AdaptationField adaptationField = new AdaptationField(Arrays.copyOfRange(this.buffer, 4, 4 + Byte.toUnsignedInt(this.buffer[4]) + 1));
                return adaptationField;
            }
            catch (Exception e) {
                logger.info("Exception creating AdaptationField");
            }
        }
        return null;
    }

    public byte[] getData() {
        int adaptationFieldControl = this.getAdaptationFieldControl();
        if (adaptationFieldControl == 1) {
            return Arrays.copyOfRange(this.buffer, 4, 188);
        }
        if (adaptationFieldControl == 3) {
            int start = Math.min(4 + Byte.toUnsignedInt(this.buffer[4]) + 1, 188);
            return Arrays.copyOfRange(this.buffer, start, 188);
        }
        return new byte[0];
    }

    public short getPID() {
        return (short)Utils.getInt(this.buffer, 1, 2, 8191);
    }

    public String toString() {
        return "bytes=" + Utils.toHexString(this.buffer, 4) + " , PID=" + this.getPID() + " (0x" + Integer.toHexString(this.getPID()) + "), packetNo=" + this.packetNo + " , continuity_counter=" + this.getContinuityCounter() + ", Adaptation_field_control=" + this.getAdaptationFieldControlString() + ", Transport Scrambling Control=" + this.getTransportScramblingControlString();
    }

    public int getContinuityCounter() {
        return this.buffer[3] & 0xF;
    }

    public int getPacketNo() {
        return this.packetNo;
    }

    public long getTimeBase() {
        return this.packetNo;
    }

    public void setPacketNo(int packet_no) {
        this.packetNo = packet_no;
    }

    @Override
    public String getHTML() {
        StringBuilder s = new StringBuilder();
        s.append("Packet: ").append(this.packetNo);
        if (this.packetOffset != -1L) {
            s.append("<br>File Offset: ").append(this.packetOffset);
        }
        if (this.transportStream != null) {
            s.append("<br>Time: ").append(this.transportStream.getPacketTime(this.packetNo));
            short pid = this.transportStream.getPacket_pid(this.packetNo);
            s.append("<br>").append(Utils.escapeHtmlBreakLines(this.transportStream.getShortLabel(pid))).append("<br>");
        }
        RangeHashMap<Integer, Color> coloring = new RangeHashMap<Integer, Color>();
        this.addBasicPacketDetails(s, 0, coloring);
        if (this.buffer.length > 188) {
            RangeHashMap<Integer, Color> localColoring = new RangeHashMap<Integer, Color>();
            localColoring.put(0, this.buffer.length - 188, FEC_COLOR);
            Utils.appendHeader(s, "FEC/timestamp:", FEC_COLOR);
            s.append(Utils.getHTMLHexviewColored(this.buffer, 188, this.buffer.length - 188, localColoring)).append("</span>");
            coloring.put(188, this.buffer.length, FEC_COLOR);
        }
        s.append("<br><b>Data:</b><br>").append(Utils.getHTMLHexviewColored(this.buffer, 0, this.buffer.length, coloring));
        return s.toString();
    }

    protected void addBasicPacketDetails(StringBuilder s, int coloringOffset, RangeHashMap<Integer, Color> coloring) {
        Utils.appendHeader(s, "Header:", HEADER_COLOR);
        coloring.put(coloringOffset, coloringOffset + 3, HEADER_COLOR);
        s.append("<br>sync_byte: ").append(Utils.getHexAndDecimalFormattedString(this.getSyncByte()));
        s.append("<br>transport_error_indicator: ").append(this.getTransportErrorIndicator());
        s.append("<br>payload_unit_start_indicator: ").append(this.getPayloadUnitStartIndicator());
        s.append("<br>transport_priority: ").append(this.getTransportPriority());
        s.append("<br>PID: ").append(Utils.getHexAndDecimalFormattedString(this.getPID()));
        s.append("<br>transport_scrambling_control: ").append(this.getTransportScramblingControl()).append(" (").append(this.getTransportScramblingControlString()).append(")");
        s.append("<br>adaptation_field_control: ").append(this.getAdaptationFieldControl()).append(" (").append(this.getAdaptationFieldControlString()).append(")");
        s.append("<br>continuity_counter: ").append(Utils.getHexAndDecimalFormattedString(this.getContinuityCounter())).append("</span><br>");
        AdaptationField adaptationField = null;
        try {
            adaptationField = this.getAdaptationField();
        }
        catch (RuntimeException re) {
            adaptationField = null;
            Utils.appendHeader(s, ERROR_PARSING_ADAPTATION_FIELD, ERROR_COLOR);
            s.append("<br></span>");
        }
        if (adaptationField != null) {
            Utils.appendHeader(s, "adaptation_field:", ADAPTATION_FIELD_COLOR);
            s.append(adaptationField.getHTML()).append("<br></span>");
            coloring.put(coloringOffset + 4, coloringOffset + 4 + adaptationField.getAdaptation_field_length(), ADAPTATION_FIELD_COLOR);
        }
        if (this.hasPayload()) {
            PesHeader pesHeaderView;
            int payloadStart = 4;
            if (adaptationField != null) {
                payloadStart = 5 + adaptationField.getAdaptation_field_length();
            }
            if (this.getPayloadUnitStartIndicator() == 1 && this.getTransportScramblingControl() == 0 && (pesHeaderView = this.getPesHeader()) != null && pesHeaderView.isValidPesHeader()) {
                DefaultMutableTreeNode treeNode = pesHeaderView.getJTreeNode(0);
                Utils.appendHeader(s, "Pes Header:", PES_HEADER_COLOR);
                s.append("<br>").append((CharSequence)Utils.getChildrenAsHTML(treeNode));
                s.append("</span>");
                if (pesHeaderView.hasExtendedHeader()) {
                    coloring.put(coloringOffset + payloadStart, coloringOffset + payloadStart + 8 + pesHeaderView.getPes_header_data_length(), PES_HEADER_COLOR);
                } else {
                    coloring.put(coloringOffset + payloadStart, coloringOffset + payloadStart + 5, PES_HEADER_COLOR);
                }
            }
        }
    }

    public boolean hasPayload() {
        return this.getAdaptationFieldControl() == 1 || this.getAdaptationFieldControl() == 3;
    }

    private int getSyncByte() {
        return Utils.getInt(this.buffer, 0, 1, 255);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        KVP kvp = new KVP(this.buildNodeLabel());
        kvp.addHTMLSource(this, "TS Packet");
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(kvp);
        this.addMainPacketDetails(modus, t);
        if (this.buffer.length > 188) {
            t.add(new DefaultMutableTreeNode(new KVP("FEC/timestamp", this.buffer, 188, this.buffer.length - 188, null)));
        }
        return t;
    }

    protected void addMainPacketDetails(int modus, DefaultMutableTreeNode t) {
        t.add(new DefaultMutableTreeNode(new KVP("sync_byte", this.getSyncByte(), "Should be 0x47")));
        t.add(new DefaultMutableTreeNode(new KVP("transport_error_indicator", this.getTransportErrorIndicator(), null)));
        t.add(new DefaultMutableTreeNode(new KVP("payload_unit_start_indicator", this.getPayloadUnitStartIndicator(), null)));
        t.add(new DefaultMutableTreeNode(new KVP("transport_priority", this.getTransportPriority(), null)));
        t.add(new DefaultMutableTreeNode(new KVP("PID", this.getPID(), null)));
        t.add(new DefaultMutableTreeNode(new KVP("transport_scrambling_control", this.getTransportScramblingControl(), null)));
        t.add(new DefaultMutableTreeNode(new KVP("adaptation_field_control", this.getAdaptationFieldControl(), this.getAdaptationFieldControlString())));
        t.add(new DefaultMutableTreeNode(new KVP("continuity_counter", this.getContinuityCounter(), null)));
        AdaptationField adaptationField = null;
        try {
            adaptationField = this.getAdaptationField();
            if (adaptationField != null) {
                t.add(adaptationField.getJTreeNode(modus));
            }
        }
        catch (RuntimeException re) {
            adaptationField = null;
            t.add(new DefaultMutableTreeNode(GuiUtils.getErrorKVP(ERROR_PARSING_ADAPTATION_FIELD)));
        }
        if (this.hasPayload()) {
            PesHeader pesHeaderView;
            int payloadStart = 4;
            if (adaptationField != null) {
                payloadStart = 5 + adaptationField.getAdaptation_field_length();
            }
            t.add(new DefaultMutableTreeNode(new KVP("data_byte", this.buffer, payloadStart, 188 - payloadStart, null)));
            if (this.getPayloadUnitStartIndicator() == 1 && this.getTransportScramblingControl() == 0 && (pesHeaderView = this.getPesHeader()) != null && pesHeaderView.isValidPesHeader()) {
                t.add(pesHeaderView.getJTreeNode(modus));
            }
        }
    }

    protected String buildNodeLabel() {
        StringBuilder l = new StringBuilder("transport_packet [").append(this.packetNo).append("]");
        if (this.getAdaptationFieldControl() == 2 || this.getAdaptationFieldControl() == 3) {
            l.append(" (adaptation field)");
        }
        if (this.hasPayload()) {
            l.append(" (payload)");
        }
        if (this.isPayloadUnitStartIndicator()) {
            l.append(" (payload start)");
        }
        String nodeLabel = l.toString();
        return nodeLabel;
    }

    public long getPacketOffset() {
        return this.packetOffset;
    }

    public void setPacketOffset(long packetOffset) {
        this.packetOffset = packetOffset;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }
}

