/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg;

import java.math.BigInteger;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.gui.HTMLSource;
import nl.digitalekabeltelevisie.util.Utils;

public class TemiTimeStamp
implements TreeNode,
HTMLSource {
    private final int packetNo;
    private long pts;
    private final BigInteger media_timestamp;
    private final long timescale;
    private final int discontinuity;
    private int timeline_id;
    private final int paused;

    public TemiTimeStamp(int packetNo, long pts, BigInteger media_timestamp, long timescale, int discontinuity, int timeline_id, int paused) {
        this.packetNo = packetNo;
        this.pts = pts;
        this.media_timestamp = media_timestamp;
        this.timescale = timescale;
        this.discontinuity = discontinuity;
        this.timeline_id = timeline_id;
        this.paused = paused;
    }

    public TemiTimeStamp(int packetNo, BigInteger media_timestamp, long timescale, int discontinuity, int timeline_id, int paused) {
        this.packetNo = packetNo;
        this.pts = -1L;
        this.media_timestamp = media_timestamp;
        this.timescale = timescale;
        this.discontinuity = discontinuity;
        this.timeline_id = timeline_id;
        this.paused = paused;
    }

    public double getTime() {
        return this.media_timestamp.doubleValue() / (double)this.timescale;
    }

    public int getPacketNo() {
        return this.packetNo;
    }

    public long getPts() {
        return this.pts;
    }

    public BigInteger getMediaTimeStamp() {
        return this.media_timestamp;
    }

    public long getTimescale() {
        return this.timescale;
    }

    public int getDiscontinuity() {
        return this.discontinuity;
    }

    public int getPaused() {
        return this.paused;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP kvp = new KVP(String.format("temi (time %.2f sec)", Float.valueOf(this.media_timestamp.floatValue() / (float)this.timescale)));
        kvp.addHTMLSource(this, "temi packet");
        kvp.add(new KVP("packetNo", this.packetNo));
        kvp.add(new KVP("pts", this.pts, Utils.printTimebase90kHz(this.pts)));
        kvp.add(new KVP("media_timestamp", this.media_timestamp));
        kvp.add(new KVP("timescale", this.timescale));
        kvp.add(new KVP("paused", this.paused));
        kvp.add(new KVP("discontinuity", this.discontinuity));
        return kvp;
    }

    @Override
    public String getHTML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("packetNo: ").append(this.packetNo).append("<br>");
        stringBuilder.append("PTS: ").append(Utils.printTimebase90kHz(this.pts)).append("<br>");
        stringBuilder.append("media_timestamp: ").append(this.media_timestamp).append("<br>");
        stringBuilder.append("timescale: ").append(this.timescale).append("<br>");
        stringBuilder.append("paused: ").append(this.paused).append("<br>");
        stringBuilder.append("discontinuity:").append(this.discontinuity).append("<br>");
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public int getTimeline_id() {
        return this.timeline_id;
    }

    public void setPts(long pts) {
        this.pts = pts;
    }
}

