/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class AACDescriptor
extends Descriptor {
    private final int profile_and_level;
    private int aac_type_flag = 0;
    private int saoc_de_flag = 0;
    private int aac_type;
    private byte[] additional_info;

    public AACDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        this.profile_and_level = Utils.getInt(b, 2, 1, 255);
        if (this.descriptorLength > 1) {
            this.aac_type_flag = Utils.getInt(b, 3, 1, 128) >> 7;
            this.saoc_de_flag = Utils.getInt(b, 3, 1, 64) >> 6;
            int t = 4;
            if (this.aac_type_flag == 1) {
                this.aac_type = Utils.getInt(b, t++, 1, 255);
            }
            if (t < this.descriptorLength) {
                this.additional_info = Utils.getBytes(b, t, 2 + this.descriptorLength - t);
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new KVP("profile_and_level", this.profile_and_level, AACDescriptor.getProfileLevelString(this.profile_and_level)));
        if (this.descriptorLength > 1) {
            t.add(new KVP("AAC_type_flag", this.aac_type_flag));
            t.add(new KVP("SAOC_DE_flag", this.saoc_de_flag, this.saoc_de_flag == 1 ? "SAOC-DE parametric data shall be present" : "SAOC-DE parametric data shall not be present"));
            if (this.aac_type_flag == 1) {
                t.add(new KVP("aac_type", this.aac_type, AACDescriptor.getComponentType0x06String(this.aac_type)));
            }
            if (this.additional_info != null) {
                t.add(new KVP("additional_info", this.additional_info));
            }
        }
        return t;
    }
}

