/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class AACMpeg2Descriptor
extends Descriptor {
    private final int mpeg2_aac_profile;
    private int mpeg2_aac_channel_configuration;
    private int additional_info;

    public AACMpeg2Descriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.mpeg2_aac_profile = Utils.getInt(b, offset + 2, 1, 255);
        this.mpeg2_aac_channel_configuration = Utils.getInt(b, offset + 3, 1, 255);
        this.additional_info = Utils.getInt(b, offset + 4, 1, 255);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("MPEG-2_AAC_profile", this.mpeg2_aac_profile, AACMpeg2Descriptor.getProfileString(this.mpeg2_aac_profile))));
        t.add(new DefaultMutableTreeNode(new KVP("MPEG-2_AAC_channel_configuration", this.mpeg2_aac_channel_configuration, AACMpeg2Descriptor.getChannelConfigurationString(this.mpeg2_aac_channel_configuration))));
        t.add(new DefaultMutableTreeNode(new KVP("MPEG-2_AAC_additional_information", this.additional_info, AACMpeg2Descriptor.getAdditionalInfoString(this.additional_info))));
        return t;
    }

    public static String getProfileString(int profile) {
        switch (profile) {
            case 0: {
                return "Main profile";
            }
            case 1: {
                return "Low Complexity profile (LC)";
            }
            case 2: {
                return "Scalable Sampling Rate profile (SSR)";
            }
            case 3: {
                return "Reserved";
            }
        }
        return "Unknown";
    }

    public static String getAdditionalInfoString(int code) {
        switch (code) {
            case 0: {
                return "AAC data according to ISO/IEC 13818-7:2003";
            }
            case 1: {
                return "AAC data with Bandwidth Extension data present according to ISO/IEC 13818-7:2003/AMD1:2004";
            }
        }
        return "Reserved";
    }

    public static String getChannelConfigurationString(int code) {
        switch (code) {
            case 1: {
                return "Mono (center front speaker)";
            }
            case 2: {
                return "Stereo (left, right front speakers)";
            }
            case 3: {
                return "3 speakers (center front speaker left, right front speakers)";
            }
            case 4: {
                return "4 speakers (center front speaker left, right center front speakers, rear surround)";
            }
            case 5: {
                return "5 speakers (center front speaker left, right front speakers, left surround, right surround rear speakers)";
            }
            case 6: {
                return "5.1";
            }
            case 7: {
                return "7.1";
            }
        }
        return "Unknown configuration";
    }
}

