/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class AVCTimingAndHRDDescriptor
extends Descriptor {
    private final int hrd_management_valid_flag;
    private final int reserved1;
    private final int picture_and_timing_info_present;
    private int _90kHz_flag;
    private int reserved2;
    private long n;
    private long k;
    private long num_units_in_tick;
    private final int fixed_frame_rate_flag;
    private final int temporal_poc_flag;
    private final int picture_to_display_conversion_flag;
    private final int reserved3;

    public AVCTimingAndHRDDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.hrd_management_valid_flag = Utils.getInt(b, offset + 2, 1, 128) >> 7;
        this.reserved1 = Utils.getInt(b, offset + 2, 1, 126) >> 1;
        this.picture_and_timing_info_present = Utils.getInt(b, offset + 2, 1, 1);
        int t = 0;
        if (this.picture_and_timing_info_present == 1) {
            this._90kHz_flag = Utils.getInt(b, offset + 3, 1, 128) >> 7;
            this.reserved2 = Utils.getInt(b, offset + 3, 1, 127);
            ++t;
            if (this._90kHz_flag == 0) {
                this.n = Utils.getLong(b, offset + 4, 4, -1L);
                this.k = Utils.getLong(b, offset + 8, 4, -1L);
                t += 8;
            }
            this.num_units_in_tick = Utils.getLong(b, offset + 3 + t, 4, -1L);
            t += 4;
        }
        this.fixed_frame_rate_flag = Utils.getInt(b, offset + 3 + t, 1, 128) >> 7;
        this.temporal_poc_flag = Utils.getInt(b, offset + 3 + t, 1, 64) >> 6;
        this.picture_to_display_conversion_flag = Utils.getInt(b, offset + 3 + t, 1, 32) >> 5;
        this.reserved3 = Utils.getInt(b, offset + 3 + t, 1, 31);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("hrd_management_valid_flag", this.hrd_management_valid_flag, this.hrd_management_valid_flag == 1 ? "SEI buffering period shall be contained in the AVC" : "alternative method shall be used for transfer from MBn to EBn")));
        t.add(new DefaultMutableTreeNode(new KVP("reserved1", this.reserved1, null)));
        t.add(new DefaultMutableTreeNode(new KVP("picture_and_timing_info_present", this.picture_and_timing_info_present, null)));
        if (this.picture_and_timing_info_present == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("90kHz_flag", this._90kHz_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("reserved2", this.reserved2, null)));
            if (this._90kHz_flag == 0) {
                t.add(new DefaultMutableTreeNode(new KVP("n", this.n, null)));
                t.add(new DefaultMutableTreeNode(new KVP("k", this.k, null)));
            }
            t.add(new DefaultMutableTreeNode(new KVP("num_units_in_tick", this.num_units_in_tick, null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("fixed_frame_rate_flag", this.fixed_frame_rate_flag, this.fixed_frame_rate_flag == 1 ? "coded frame rate shall be constant within AVC video elementary stream" : "no information about AVC video stream frame rate in the descriptor")));
        t.add(new DefaultMutableTreeNode(new KVP("temporal_poc_flag", this.temporal_poc_flag, this.temporal_poc_flag == 1 ? "AVC video stream shall transmit picture order count (POC) information" : "information about relationship between POC information of AVC video stream and the time shall not be transmitted")));
        t.add(new DefaultMutableTreeNode(new KVP("picture_to_display_conversion_flag", this.picture_to_display_conversion_flag, this.picture_to_display_conversion_flag == 1 ? "AVC video stream shall transmit information about displaying coded pictures" : "pic_struct_present_flag VUI parameter of AVC video stream shall have the value of 0")));
        t.add(new DefaultMutableTreeNode(new KVP("reserved3", this.reserved3, null)));
        return t;
    }
}

