/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.pes.video264.Seq_parameter_set_data;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class AVCVideoDescriptor
extends Descriptor {
    private final int profile_idc;
    private final int constraint_set0_flag;
    private final int constraint_set1_flag;
    private final int constraint_set2_flag;
    private final int constraint_set3_flag;
    private final int constraint_set4_flag;
    private final int constraint_set5_flag;
    private final int AVC_compatible_flags;
    private final int level_idc;
    private final int AVC_still_present;
    private final int AVC_24_hour_picture_flag;
    private final int frame_packing_SEI_not_present_flag;
    private final int reserved;

    public AVCVideoDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.profile_idc = Utils.getInt(b, offset + 2, 1, 255);
        this.constraint_set0_flag = Utils.getInt(b, offset + 3, 1, 128) >> 7;
        this.constraint_set1_flag = Utils.getInt(b, offset + 3, 1, 64) >> 6;
        this.constraint_set2_flag = Utils.getInt(b, offset + 3, 1, 32) >> 5;
        this.constraint_set3_flag = Utils.getInt(b, offset + 3, 1, 16) >> 4;
        this.constraint_set4_flag = Utils.getInt(b, offset + 3, 1, 8) >> 3;
        this.constraint_set5_flag = Utils.getInt(b, offset + 3, 1, 4) >> 2;
        this.AVC_compatible_flags = Utils.getInt(b, offset + 3, 1, 3);
        this.level_idc = Utils.getInt(b, offset + 4, 1, 255);
        this.AVC_still_present = Utils.getInt(b, offset + 5, 1, 128) >> 7;
        this.AVC_24_hour_picture_flag = Utils.getInt(b, offset + 5, 1, 64) >> 6;
        this.frame_packing_SEI_not_present_flag = Utils.getInt(b, offset + 5, 1, 32) >> 5;
        this.reserved = Utils.getInt(b, offset + 5, 1, 31);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("profile_idc", this.profile_idc, Seq_parameter_set_data.getProfileIdcString(this.profile_idc))));
        t.add(new DefaultMutableTreeNode(new KVP("constraint_set0_flag", this.constraint_set0_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("constraint_set1_flag", this.constraint_set1_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("constraint_set2_flag", this.constraint_set2_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("constraint_set3_flag", this.constraint_set3_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("constraint_set4_flag", this.constraint_set4_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("constraint_set5_flag", this.constraint_set5_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("AVC_compatible_flags", this.AVC_compatible_flags, null)));
        t.add(new DefaultMutableTreeNode(new KVP("level_idc", this.level_idc, null)));
        t.add(new DefaultMutableTreeNode(new KVP("AVC_still_present", this.AVC_still_present, this.AVC_still_present == 1 ? "may include AVC still pictures" : "shall not contain AVC still pictures")));
        t.add(new DefaultMutableTreeNode(new KVP("AVC_24_hour_picture_flag", this.AVC_24_hour_picture_flag, this.AVC_24_hour_picture_flag == 1 ? "may contain AVC 24-hour pictures" : "shall not contain any AVC 24-hour picture")));
        t.add(new DefaultMutableTreeNode(new KVP("frame_packing_SEI_not_present_flag", this.frame_packing_SEI_not_present_flag, this.frame_packing_SEI_not_present_flag == 0 ? "frame packing arrangement SEI message is present within the coded video sequence" : "no frame packing arrangement SEI message within the coded video sequence")));
        t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
        return t;
    }
}

