/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class AncillaryDataDescriptor
extends Descriptor {
    private final int ancillaryDataIdentifier;

    public AncillaryDataDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.ancillaryDataIdentifier = Utils.getInt(b, offset + 2, 1, 255);
    }

    @Override
    public String toString() {
        return super.toString() + "ancillaryDataIdentifier=" + this.ancillaryDataIdentifier;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("ancillary_data_identifier", this.ancillaryDataIdentifier, AncillaryDataDescriptor.ancillaryDataIdentifierString(this.ancillaryDataIdentifier))));
        return t;
    }

    public static String ancillaryDataIdentifierString(int id) {
        StringBuilder r = new StringBuilder();
        if ((id & 1) != 0) {
            r.append("DVD-Video Ancillary Data ");
        }
        if ((id & 2) != 0) {
            r.append("Extended Ancillary Data ");
        }
        if ((id & 4) != 0) {
            r.append("Announcement Switching Data ");
        }
        if ((id & 8) != 0) {
            r.append("DAB Ancillary Data ");
        }
        if ((id & 0x10) != 0) {
            r.append("Scale Factor Error Check (ScF-CRC) ");
        }
        if ((id & 0x20) != 0) {
            r.append("MPEG-4 ancillary data ");
        }
        if ((id & 0x40) != 0) {
            r.append("RDS via UECP ");
        }
        if ((id & 0x80) != 0) {
            r.append("reserved for future use ");
        }
        return r.toString();
    }

    public int getAncillaryDataIdentifier() {
        return this.ancillaryDataIdentifier;
    }
}

