/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.Arrays;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class CADescriptor
extends Descriptor {
    private int caSystemID;
    private int caPID;
    private byte[] privateDataByte;

    public CADescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.caSystemID = Utils.getInt(b, offset + 2, 2, 65535);
        this.caPID = Utils.getInt(b, offset + 4, 2, 8191);
        this.privateDataByte = Arrays.copyOfRange(b, offset + 6, offset + this.descriptorLength + 2);
    }

    @Override
    public String toString() {
        return super.toString() + "caSystemID=" + this.caSystemID;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("CA_system_ID", this.caSystemID, Utils.getCASystemIDString(this.caSystemID))));
        t.add(new DefaultMutableTreeNode(new KVP("CA_PID", this.caPID, null)));
        t.add(new DefaultMutableTreeNode(new KVP("private_data_byte", this.privateDataByte, null)));
        return t;
    }

    public int getCaPID() {
        return this.caPID;
    }

    public int getCaSystemID() {
        return this.caSystemID;
    }

    public byte[] getPrivateDataByte() {
        return this.privateDataByte;
    }
}

