/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class CableDeliverySystemDescriptor
extends Descriptor {
    private String frequency;
    private int FEC_outer;
    private int modulation;
    private String symbol_rate;
    private int FEC_inner;

    public CableDeliverySystemDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.frequency = Utils.getBCD(b, offset * 2 + 4, 8);
        this.FEC_outer = Utils.getInt(b, offset + 7, 1, 15);
        this.modulation = Utils.getInt(b, offset + 8, 1, 255);
        this.symbol_rate = Utils.getBCD(b, offset * 2 + 18, 7);
        this.FEC_inner = Utils.getInt(b, offset + 12, 1, 15);
    }

    public int getFEC_inner() {
        return this.FEC_inner;
    }

    public void setFEC_inner(int fec_inner) {
        this.FEC_inner = fec_inner;
    }

    public int getFEC_outer() {
        return this.FEC_outer;
    }

    public String getFEC_outerString() {
        switch (this.getFEC_outer()) {
            case 0: {
                return "not defined";
            }
            case 1: {
                return "no outer FEC coding";
            }
            case 2: {
                return "RS(204/188)";
            }
        }
        return "reserved for future use";
    }

    public static String getModulationString(int mod) {
        switch (mod) {
            case 0: {
                return "not defined";
            }
            case 1: {
                return "16-QAM";
            }
            case 2: {
                return "32-QAM";
            }
            case 3: {
                return "64-QAM";
            }
            case 4: {
                return "128-QAM";
            }
            case 5: {
                return "256-QAM";
            }
        }
        return "reserved for future use";
    }

    public void setFEC_outer(int fec_outer) {
        this.FEC_outer = fec_outer;
    }

    public int getModulation() {
        return this.modulation;
    }

    public void setModulation(int modulation) {
        this.modulation = modulation;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public String getSymbol_rate() {
        return this.symbol_rate;
    }

    public void setSymbol_rate(String symbol_rate) {
        this.symbol_rate = symbol_rate;
    }

    @Override
    public String toString() {
        return super.toString() + "Frequency=" + this.getFrequency() + ", FEC_outer=" + this.getFEC_outerString() + ", modulation=" + CableDeliverySystemDescriptor.getModulationString(this.modulation) + ", Symbol Rate=" + this.getSymbol_rate() + ", FEC_inner=" + Descriptor.getFEC_innerString(this.FEC_inner);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("frequency", this.frequency, Descriptor.formatCableFrequency(this.frequency))));
        t.add(new DefaultMutableTreeNode(new KVP("FEC_outer", this.FEC_outer, this.getFEC_outerString())));
        t.add(new DefaultMutableTreeNode(new KVP("modulation", this.modulation, CableDeliverySystemDescriptor.getModulationString(this.modulation))));
        t.add(new DefaultMutableTreeNode(new KVP("symbol_rate", this.symbol_rate, Descriptor.formatSymbolRate(this.symbol_rate))));
        t.add(new DefaultMutableTreeNode(new KVP("FEC_inner", this.FEC_inner, Descriptor.getFEC_innerString(this.FEC_inner))));
        return t;
    }
}

