/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.Arrays;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class CarouselIdentifierDescriptor
extends Descriptor {
    private final long carouselId;
    private int formatId;
    private byte[] privateDataByte;
    private int moduleVersion;
    private int moduleId;
    private int blockSize;
    private long moduleSize;
    private int compressionMethod;
    private long originalSize;
    private int timeOut;
    private int objectKeyLength;
    private byte[] objectKeyData;

    public CarouselIdentifierDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        this.carouselId = Utils.getLong(b, 2, 4, -1L);
        if (this.descriptorLength > 4) {
            this.formatId = Utils.getInt(b, 6, 1, 255);
            if (this.formatId == 0) {
                this.privateDataByte = Arrays.copyOfRange(b, 7, this.descriptorLength + 2);
            }
            if (this.formatId == 1) {
                this.moduleVersion = Utils.getInt(b, 7, 1, 255);
                this.moduleId = Utils.getInt(b, 8, 2, 65535);
                this.blockSize = Utils.getInt(b, 10, 2, 65535);
                this.moduleSize = Utils.getLong(b, 12, 4, -1L);
                this.compressionMethod = Utils.getInt(b, 16, 1, 255);
                this.originalSize = Utils.getLong(b, 17, 4, -1L);
                this.timeOut = Utils.getInt(b, 21, 1, 255);
                this.objectKeyLength = Utils.getInt(b, 22, 1, 255);
                this.objectKeyData = Arrays.copyOfRange(b, 23, 23 + this.objectKeyLength);
                this.privateDataByte = Arrays.copyOfRange(b, 23 + this.objectKeyLength, this.descriptorLength + 2);
            }
        }
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = (KVP)super.getJTreeNode(modus);
        t.add(new KVP("carousel_id", this.carouselId));
        if (this.descriptorLength > 4) {
            t.add(new KVP("format_id", this.formatId, CarouselIdentifierDescriptor.getFormatIDString(this.formatId)));
            if (this.formatId == 0) {
                t.add(new KVP("private_data_byte", this.privateDataByte));
            }
            if (this.formatId == 1) {
                t.add(new KVP("module_version", this.moduleVersion));
                t.add(new KVP("module_id", this.moduleId));
                t.add(new KVP("block_size", this.blockSize));
                t.add(new KVP("module_size", this.moduleSize));
                t.add(new KVP("compression_method", this.compressionMethod));
                t.add(new KVP("Original_size", this.originalSize));
                t.add(new KVP("time_out", this.timeOut));
                t.add(new KVP("object_key_length", this.objectKeyLength));
                t.add(new KVP("object_key_data", this.objectKeyData));
                t.add(new KVP("private_data_byte", this.privateDataByte));
            }
        }
        return t;
    }

    public static String getFormatIDString(int formatID) {
        switch (formatID) {
            case 0: {
                return "standard boot";
            }
            case 1: {
                return "enhanced boot";
            }
        }
        return "unknown value";
    }

    public long getCarouselId() {
        return this.carouselId;
    }

    public int getFormatId() {
        return this.formatId;
    }

    public byte[] getPrivateDataByte() {
        return this.privateDataByte;
    }

    public int getModuleVersion() {
        return this.moduleVersion;
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public long getModuleSize() {
        return this.moduleSize;
    }

    public int getCompressionMethod() {
        return this.compressionMethod;
    }

    public long getOriginalSize() {
        return this.originalSize;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public int getObjectKeyLength() {
        return this.objectKeyLength;
    }

    public byte[] getObjectKeyData() {
        return this.objectKeyData;
    }
}

