/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class CellFrequencyLinkDescriptor
extends Descriptor {
    private final List<Cell> cellList = new ArrayList<Cell>();

    public CellFrequencyLinkDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        int t = 0;
        while (t + 6 < this.descriptorLength) {
            int r;
            int cell_id = Utils.getInt(b, offset + t + 2, 2, 65535);
            long freq = Utils.getLong(b, offset + t + 4, 4, -1L);
            int subcell_info_loop_length = Utils.getInt(b, offset + t + 8, 1, 255);
            Cell cell = new Cell(cell_id, freq, subcell_info_loop_length);
            this.cellList.add(cell);
            t += 7;
            for (r = 0; r < subcell_info_loop_length; r += 5) {
                int cell_id_extension = Utils.getInt(b, offset + t + 2 + r, 1, 255);
                long trans_freq = Utils.getLong(b, offset + t + 3, 4, -1L);
                SubCell s = new SubCell(cell_id_extension, trans_freq);
                cell.addSubCell(s);
            }
            t += r;
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        for (Cell cell : this.cellList) {
            buf.append(cell.toString());
        }
        return buf.toString();
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.cellList, modus, "cell_list");
        return t;
    }

    public static class Cell
    implements TreeNode {
        private final int cellId;
        private final long frequency;
        private final int subcellInfoLoopLength;
        private final List<SubCell> subCellList = new ArrayList<SubCell>();

        public Cell(int id, long f, int loop) {
            this.cellId = id;
            this.frequency = f;
            this.subcellInfoLoopLength = loop;
        }

        public void addSubCell(SubCell s) {
            this.subCellList.add(s);
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("cell"));
            s.add(new DefaultMutableTreeNode(new KVP("cell_id", this.cellId, null)));
            s.add(new DefaultMutableTreeNode(new KVP("frequency", this.frequency, Descriptor.formatTerrestrialFrequency(this.frequency))));
            s.add(new DefaultMutableTreeNode(new KVP("subcell_info_loop_length", this.subcellInfoLoopLength, null)));
            Utils.addListJTree(s, this.subCellList, modus, "sub_cell_list");
            return s;
        }
    }

    public static class SubCell
    implements TreeNode {
        private final int cellIdExtension;
        private final long transposerFrequency;

        public SubCell(int id, long f) {
            this.cellIdExtension = id;
            this.transposerFrequency = f;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("subcell"));
            s.add(new DefaultMutableTreeNode(new KVP("cell_id_extension", this.cellIdExtension, null)));
            s.add(new DefaultMutableTreeNode(new KVP("transposer_frequency", this.transposerFrequency, Descriptor.formatTerrestrialFrequency(this.transposerFrequency))));
            return s;
        }
    }
}

