/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class CellListDescriptor
extends Descriptor {
    private final List<Cell> cellList = new ArrayList<Cell>();

    public CellListDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        int t = 0;
        while (t + 9 < this.descriptorLength) {
            int r;
            int cell_id = Utils.getInt(b, offset + t + 2, 2, 65535);
            int cell_latitude = Utils.getInt(b, offset + t + 4, 2, 65535);
            int cell_longitude = Utils.getInt(b, offset + t + 6, 2, 65535);
            int cell_extent_of_latitude = Utils.getInt(b, offset + t + 8, 2, 65520) >> 4;
            int cell_extent_of_longitude = Utils.getInt(b, offset + t + 9, 2, 4095);
            int subcell_info_loop_length = Utils.getInt(b, offset + t + 11, 1, 255);
            Cell cell = new Cell(cell_id, cell_latitude, cell_longitude, cell_extent_of_latitude, cell_extent_of_longitude, subcell_info_loop_length);
            this.cellList.add(cell);
            t += 10;
            for (r = 0; r < subcell_info_loop_length; r += 8) {
                int cell_id_extension = Utils.getInt(b, offset + t + 2 + r, 1, 255);
                int subcell_latitude = Utils.getInt(b, offset + t + 3 + r, 2, 65535);
                int subcell_longitude = Utils.getInt(b, offset + t + 5 + r, 2, 65535);
                int subcell_extent_of_latitude = Utils.getInt(b, offset + t + 7 + r, 2, 65520) >> 4;
                int subcell_extent_of_longitude = Utils.getInt(b, offset + t + 8 + r, 2, 4095);
                SubCell s = new SubCell(cell_id_extension, subcell_latitude, subcell_longitude, subcell_extent_of_latitude, subcell_extent_of_longitude);
                cell.addSubCell(s);
            }
            t += r;
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        for (Cell cell : this.cellList) {
            buf.append(cell.toString());
        }
        return buf.toString();
    }

    public static String getCellLatitudeString(int latitude) {
        int c = latitude;
        if (c > Short.MAX_VALUE) {
            c -= 65536;
        }
        float f = (float)c * 90.0f / 32768.0f;
        return Float.toString(f);
    }

    public static String getCellLongitudeString(int longitude) {
        int c = longitude;
        if (c > Short.MAX_VALUE) {
            c -= 65536;
        }
        float f = (float)c * 180.0f / 32768.0f;
        return Float.toString(f);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.cellList, modus, "cell_list");
        return t;
    }

    public static class Cell
    implements TreeNode {
        private final int cellId;
        private final int cellLatitude;
        private final int cellLongitude;
        private final int cellExtentOfLatitude;
        private final int cellExtentOfLongitude;
        private final int subcellInfoLoopLength;
        private List<SubCell> subCellList = new ArrayList<SubCell>();

        public Cell(int cellId, int cellLatitude, int cellLongitude, int cellExtentOfLatitude, int cellExtentOfLongitude, int subcellInfoLoopLength) {
            this.cellId = cellId;
            this.cellLatitude = cellLatitude;
            this.cellLongitude = cellLongitude;
            this.cellExtentOfLatitude = cellExtentOfLatitude;
            this.cellExtentOfLongitude = cellExtentOfLongitude;
            this.subcellInfoLoopLength = subcellInfoLoopLength;
        }

        public void addSubCell(SubCell s) {
            this.subCellList.add(s);
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("cell"));
            s.add(new DefaultMutableTreeNode(new KVP("cell_id", this.cellId, null)));
            s.add(new DefaultMutableTreeNode(new KVP("cell_latitude", this.cellLatitude, CellListDescriptor.getCellLatitudeString(this.cellLatitude))));
            s.add(new DefaultMutableTreeNode(new KVP("cell_longitude", this.cellLongitude, CellListDescriptor.getCellLongitudeString(this.cellLongitude))));
            s.add(new DefaultMutableTreeNode(new KVP("cell_extent_of_latitude", this.cellExtentOfLatitude, CellListDescriptor.getCellLatitudeString(this.cellExtentOfLatitude))));
            s.add(new DefaultMutableTreeNode(new KVP("cell_extent_of_longitude", this.cellExtentOfLongitude, CellListDescriptor.getCellLongitudeString(this.cellExtentOfLongitude))));
            s.add(new DefaultMutableTreeNode(new KVP("subcell_info_loop_length", this.subcellInfoLoopLength, null)));
            Utils.addListJTree(s, this.subCellList, modus, "sub_cell_list");
            return s;
        }
    }

    public static class SubCell
    implements TreeNode {
        private final int cellIdExtension;
        private final int subcellLatitude;
        private final int subcellLongitude;
        private final int subcellExtentOfLatitude;
        private final int subcellExtentOfLongitude;

        public SubCell(int cellIdExtension, int subcellLatitude, int subcellLongitude, int subcellExtentOfLatitude, int subcellExtentOfLongitude) {
            this.cellIdExtension = cellIdExtension;
            this.subcellLatitude = subcellLatitude;
            this.subcellLongitude = subcellLongitude;
            this.subcellExtentOfLatitude = subcellExtentOfLatitude;
            this.subcellExtentOfLongitude = subcellExtentOfLongitude;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("subcell"));
            s.add(new DefaultMutableTreeNode(new KVP("cell_id_extension", this.cellIdExtension, null)));
            s.add(new DefaultMutableTreeNode(new KVP("subcell_latitude", this.subcellLatitude, CellListDescriptor.getCellLatitudeString(this.subcellLatitude))));
            s.add(new DefaultMutableTreeNode(new KVP("subcell_longitude", this.subcellLongitude, CellListDescriptor.getCellLongitudeString(this.subcellLongitude))));
            s.add(new DefaultMutableTreeNode(new KVP("subcell_extent_of_latitude", this.subcellExtentOfLatitude, CellListDescriptor.getCellLatitudeString(this.subcellExtentOfLatitude))));
            s.add(new DefaultMutableTreeNode(new KVP("subcell_extent_of_longitude", this.subcellExtentOfLongitude, CellListDescriptor.getCellLongitudeString(this.subcellExtentOfLongitude))));
            return s;
        }
    }
}

