/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.LanguageDependentEitDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class ComponentDescriptor
extends LanguageDependentEitDescriptor {
    private int streamContentExt;
    private int streamContent;
    private final int componentType;
    private final int componentTag;
    private final String iso639LanguageCode;
    private final DVBString text;

    public ComponentDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        this.streamContentExt = Utils.getInt(b, 2, 1, 240) >> 4;
        this.streamContent = Utils.getInt(b, 2, 1, 15);
        this.componentType = Utils.getInt(b, 3, 1, 255);
        this.componentTag = Utils.getInt(b, 4, 1, 255);
        this.iso639LanguageCode = Utils.getISO8859_1String(b, 5, 3);
        this.text = new DVBString(b, 8, this.descriptorLength - 6);
    }

    @Override
    public String toString() {
        return super.toString() + "streamContent=" + this.streamContent;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = super.getJTreeNode(modus);
        t.add(new KVP("stream_content_ext", this.streamContentExt));
        t.add(new KVP("stream_content", this.streamContent));
        t.add(new KVP("component_type", this.componentType).setDescription(this.getStreamTypeString()));
        t.add(new KVP("component_tag", this.componentTag));
        t.add(new KVP("ISO_639_language_code", this.iso639LanguageCode));
        t.add(new KVP("text", this.text));
        return t;
    }

    public String getStreamTypeString() {
        return ComponentDescriptor.getComponentDescriptorString(this.streamContent, this.streamContentExt, this.componentType);
    }

    public int getStreamContent() {
        return this.streamContent;
    }

    public int getReserved() {
        return this.streamContentExt;
    }

    public int getStreamContentExt() {
        return this.streamContentExt;
    }

    public int getComponentType() {
        return this.componentType;
    }

    public int getComponentTag() {
        return this.componentTag;
    }

    @Override
    public String getIso639LanguageCode() {
        return this.iso639LanguageCode;
    }

    public DVBString getText() {
        return this.text;
    }
}

